/*
 * Decompiled with CFR 0.152.
 */
package proguard.evaluation.value;

import proguard.evaluation.value.DoubleValue;
import proguard.evaluation.value.FloatValue;
import proguard.evaluation.value.IntegerValue;
import proguard.evaluation.value.LongValue;
import proguard.evaluation.value.ParticularDoubleValue;
import proguard.evaluation.value.ParticularFloatValue;
import proguard.evaluation.value.ParticularIntegerValue;
import proguard.evaluation.value.SpecificLongValue;

final class ParticularLongValue
extends SpecificLongValue {
    private final long value;

    public ParticularLongValue(long l) {
        this.value = l;
    }

    @Override
    public long value() {
        return this.value;
    }

    @Override
    public LongValue negate() {
        return new ParticularLongValue(-this.value);
    }

    @Override
    public IntegerValue convertToInteger() {
        return new ParticularIntegerValue((int)this.value);
    }

    @Override
    public FloatValue convertToFloat() {
        return new ParticularFloatValue(this.value);
    }

    @Override
    public DoubleValue convertToDouble() {
        return new ParticularDoubleValue(this.value);
    }

    @Override
    public LongValue generalize(LongValue longValue) {
        return longValue.generalize(this);
    }

    @Override
    public LongValue add(LongValue longValue) {
        return longValue.add(this);
    }

    @Override
    public LongValue subtract(LongValue longValue) {
        return longValue.subtractFrom(this);
    }

    @Override
    public LongValue subtractFrom(LongValue longValue) {
        return longValue.subtract(this);
    }

    @Override
    public LongValue multiply(LongValue longValue) {
        return longValue.multiply(this);
    }

    @Override
    public LongValue divide(LongValue longValue) throws ArithmeticException {
        return longValue.divideOf(this);
    }

    @Override
    public LongValue divideOf(LongValue longValue) throws ArithmeticException {
        return longValue.divide(this);
    }

    @Override
    public LongValue remainder(LongValue longValue) throws ArithmeticException {
        return longValue.remainderOf(this);
    }

    @Override
    public LongValue remainderOf(LongValue longValue) throws ArithmeticException {
        return longValue.remainder(this);
    }

    @Override
    public LongValue shiftLeft(IntegerValue integerValue) {
        return integerValue.shiftLeftOf(this);
    }

    @Override
    public LongValue shiftRight(IntegerValue integerValue) {
        return integerValue.shiftRightOf(this);
    }

    @Override
    public LongValue unsignedShiftRight(IntegerValue integerValue) {
        return integerValue.unsignedShiftRightOf(this);
    }

    @Override
    public LongValue and(LongValue longValue) {
        return longValue.and(this);
    }

    @Override
    public LongValue or(LongValue longValue) {
        return longValue.or(this);
    }

    @Override
    public LongValue xor(LongValue longValue) {
        return longValue.xor(this);
    }

    @Override
    public IntegerValue compare(LongValue longValue) {
        return longValue.compareReverse(this);
    }

    @Override
    public LongValue generalize(ParticularLongValue particularLongValue) {
        return this.generalize((SpecificLongValue)particularLongValue);
    }

    @Override
    public LongValue add(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value + particularLongValue.value);
    }

    @Override
    public LongValue subtract(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value - particularLongValue.value);
    }

    @Override
    public LongValue subtractFrom(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(particularLongValue.value - this.value);
    }

    @Override
    public LongValue multiply(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value * particularLongValue.value);
    }

    @Override
    public LongValue divide(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(this.value / particularLongValue.value);
    }

    @Override
    public LongValue divideOf(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(particularLongValue.value / this.value);
    }

    @Override
    public LongValue remainder(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(this.value % particularLongValue.value);
    }

    @Override
    public LongValue remainderOf(ParticularLongValue particularLongValue) throws ArithmeticException {
        return new ParticularLongValue(particularLongValue.value % this.value);
    }

    @Override
    public LongValue shiftLeft(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value << particularIntegerValue.value());
    }

    @Override
    public LongValue shiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value >> particularIntegerValue.value());
    }

    @Override
    public LongValue unsignedShiftRight(ParticularIntegerValue particularIntegerValue) {
        return new ParticularLongValue(this.value >>> particularIntegerValue.value());
    }

    @Override
    public LongValue and(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value & particularLongValue.value);
    }

    @Override
    public LongValue or(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value | particularLongValue.value);
    }

    @Override
    public LongValue xor(ParticularLongValue particularLongValue) {
        return new ParticularLongValue(this.value ^ particularLongValue.value);
    }

    @Override
    public boolean isParticular() {
        return true;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object) && this.value == ((ParticularLongValue)object).value;
    }

    @Override
    public int hashCode() {
        return this.getClass().hashCode() ^ (int)this.value;
    }

    public String toString() {
        return this.value + "L";
    }
}

