/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import java.util.Map;
import java.util.Objects;

public class AnnoInfo {
    private final SourceFile source;
    private final ClassSymbol sym;
    private final Tree.Anno tree;
    private final ImmutableMap<String, Const> values;

    public AnnoInfo(SourceFile source, ClassSymbol sym, Tree.Anno tree, ImmutableMap<String, Const> values) {
        this.source = source;
        this.sym = sym;
        this.tree = tree;
        this.values = Objects.requireNonNull(values);
    }

    public SourceFile source() {
        return this.source;
    }

    public int position() {
        return this.tree.position();
    }

    public ImmutableList<Tree.Expression> args() {
        return this.tree.args();
    }

    public ImmutableMap<String, Const> values() {
        return this.values;
    }

    public ClassSymbol sym() {
        return this.sym;
    }

    public Tree.Anno tree() {
        return this.tree;
    }

    public AnnoInfo withValues(ImmutableMap<String, Const> values) {
        return new AnnoInfo(this.source, this.sym, this.tree, values);
    }

    public int hashCode() {
        return Objects.hash(this.sym, this.values);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof AnnoInfo)) {
            return false;
        }
        AnnoInfo that = (AnnoInfo)obj;
        return this.sym.equals(that.sym) && this.values.equals(that.values);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('@').append(this.sym.binaryName().replace('/', '.').replace('$', '.'));
        boolean first = true;
        if (this.values != null && !this.values.isEmpty()) {
            sb.append('(');
            if (this.values.size() == 1 && this.values.containsKey((Object)"value")) {
                sb.append(Iterables.getOnlyElement((Iterable)this.values.values()));
            } else {
                for (Map.Entry e : this.values.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    sb.append((String)e.getKey()).append('=').append(e.getValue());
                    first = false;
                }
            }
            sb.append(')');
        }
        return sb.toString();
    }
}

