/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.nullness;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.dataflow.nullnesspropagation.Nullness;
import com.google.errorprone.dataflow.nullnesspropagation.NullnessAnalysis;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Context;
import java.util.Objects;

@BugPattern(name="EqualsBrokenForNull", summary="equals() implementation throws NullPointerException when given null", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class EqualsBrokenForNull
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    public Description matchMethod(MethodTree tree, final VisitorState state) {
        if (!Matchers.equalsMethodDeclaration().matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol varSymbol = ASTHelpers.getSymbol((VariableTree)((VariableTree)Iterables.getOnlyElement(tree.getParameters())));
        final NullnessAnalysis analysis = NullnessAnalysis.instance((Context)state.context);
        final boolean[] crashesWithNull = new boolean[]{false};
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitMemberSelect(MemberSelectTree node, Void aVoid) {
                Nullness nullness;
                if (!crashesWithNull[0] && Objects.equals(varSymbol, ASTHelpers.getSymbol((Tree)node.getExpression())) && (nullness = analysis.getNullness(new TreePath(this.getCurrentPath(), node.getExpression()), state.context)) == Nullness.NULLABLE) {
                    crashesWithNull[0] = true;
                }
                return (Void)super.visitMemberSelect(node, aVoid);
            }
        }.scan(state.getPath(), (Void)null);
        if (!crashesWithNull[0]) {
            return Description.NO_MATCH;
        }
        String stringAddition = String.format("if (%s == null) { return false; }\n", varSymbol.name.toString());
        SuggestedFix fix = SuggestedFix.prefixWith((Tree)tree.getBody().getStatements().get(0), (String)stringAddition);
        return this.describeMatch(tree, (Fix)fix);
    }
}

