/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast;

import java.util.List;
import lombok.ast.Annotation;
import lombok.ast.ClassDeclaration;
import lombok.ast.KeywordModifier;
import lombok.ast.MethodDeclaration;
import lombok.ast.Modifiers;
import lombok.ast.Node;
import lombok.ast.TypeDeclaration;
import lombok.ast.VariableDeclaration;

class ModifiersTemplate {
    List<KeywordModifier> keywords2;
    List<Annotation> annotations1;

    ModifiersTemplate() {
    }

    static int getExplicitModifierFlags(Modifiers m) {
        int out = 0;
        for (KeywordModifier n : m.astKeywords()) {
            out |= n.asReflectModifiers();
        }
        return out;
    }

    static int getEffectiveModifierFlags(Modifiers m) {
        TypeDeclaration container;
        int explicit;
        int out = explicit = ModifiersTemplate.getExplicitModifierFlags(m);
        Node declaration = m.getParent();
        if (declaration instanceof TypeDeclaration && !(declaration instanceof ClassDeclaration)) {
            out |= 8;
        }
        if (declaration instanceof ClassDeclaration && ((ClassDeclaration)declaration).upIfTopLevelToCompilationUnit() != null) {
            out |= 8;
        }
        if (declaration instanceof TypeDeclaration && ((TypeDeclaration)declaration).isInterface()) {
            out |= 0x400;
        }
        if (declaration instanceof ClassDeclaration && (container = ((ClassDeclaration)declaration).upUpToTypeDeclaration()) != null && container.isInterface()) {
            out |= 8;
        }
        if (declaration instanceof MethodDeclaration && (container = ((MethodDeclaration)declaration).upUpToTypeDeclaration()) != null && container.isInterface() && (explicit & 8) == 0) {
            out |= 0x401;
        }
        if (declaration instanceof VariableDeclaration && (container = ((VariableDeclaration)declaration).upUpToTypeDeclaration()) != null && container.isInterface()) {
            out |= 0x19;
        }
        return out;
    }

    static boolean isPublic(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 1);
    }

    static boolean isProtected(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 4);
    }

    static boolean isPrivate(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 2);
    }

    static boolean isPackagePrivate(Modifiers m) {
        return 0 == (ModifiersTemplate.getEffectiveModifierFlags(m) & 7);
    }

    static boolean isStatic(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 8);
    }

    static boolean isFinal(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 0x10);
    }

    static boolean isAbstract(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 0x400);
    }

    static boolean isTransient(Modifiers m) {
        return 0 != (ModifiersTemplate.getEffectiveModifierFlags(m) & 0x80);
    }

    static boolean isEmpty(Modifiers m) {
        return m.rawKeywords().isEmpty() && m.rawAnnotations().isEmpty();
    }
}

