/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns.inject;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.ChildMultiMatcher;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.InjectMatchers;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.MultiMatcher;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import javax.lang.model.element.Modifier;

@BugPattern(name="JavaxInjectOnAbstractMethod", summary="Abstract and default methods are not injectable with javax.inject.Inject", category=BugPattern.Category.INJECT, severity=BugPattern.SeverityLevel.ERROR, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class JavaxInjectOnAbstractMethod
extends BugChecker
implements BugChecker.MethodTreeMatcher {
    private static final MultiMatcher<MethodTree, AnnotationTree> INJECT_FINDER = Matchers.annotations((ChildMultiMatcher.MatchType)ChildMultiMatcher.MatchType.AT_LEAST_ONE, (Matcher)InjectMatchers.IS_APPLICATION_OF_JAVAX_INJECT);
    private static final Matcher<MethodTree> ABSTRACT_OR_DEFAULT_METHOD_WITH_INJECT = Matchers.allOf((Matcher[])new Matcher[]{Matchers.anyOf((Matcher[])new Matcher[]{Matchers.hasModifier((Modifier)Modifier.ABSTRACT), Matchers.hasModifier((Modifier)Modifier.DEFAULT)})});

    public Description matchMethod(MethodTree methodTree, VisitorState state) {
        MultiMatcher.MultiMatchResult injectAnnotations;
        if (ABSTRACT_OR_DEFAULT_METHOD_WITH_INJECT.matches((Tree)methodTree, state) && (injectAnnotations = INJECT_FINDER.multiMatchResult((Tree)methodTree, state)).matches()) {
            AnnotationTree injectAnnotation = (AnnotationTree)injectAnnotations.onlyMatchingNode();
            return this.describeMatch(injectAnnotation, (Fix)SuggestedFix.delete((Tree)injectAnnotation));
        }
        return Description.NO_MATCH;
    }
}

