/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.annotations.RestrictedApi;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.NewClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.tree.JCTree;
import java.net.URI;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.type.MirroredTypesException;

@BugPattern(name="RestrictedApiChecker", summary=" Check for non-whitelisted callers to RestrictedApiChecker.", category=BugPattern.Category.ONE_OFF, severity=BugPattern.SeverityLevel.ERROR, suppressionAnnotations={}, disableable=false, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class RestrictedApiChecker
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher,
BugChecker.NewClassTreeMatcher,
BugChecker.AnnotationTreeMatcher {
    public Description matchAnnotation(AnnotationTree tree, VisitorState state) {
        if (!ASTHelpers.getSymbol((Tree)tree).toString().equals(RestrictedApi.class.getName())) {
            return Description.NO_MATCH;
        }
        AnnotationMirror restrictedApi = ASTHelpers.getAnnotationMirror((AnnotationTree)tree);
        if (restrictedApi == null) {
            return Description.NO_MATCH;
        }
        return Description.NO_MATCH;
    }

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        RestrictedApi annotation = (RestrictedApi)ASTHelpers.getAnnotation((Tree)tree, RestrictedApi.class);
        if (annotation != null) {
            return this.checkRestriction(annotation, tree, state);
        }
        Symbol.MethodSymbol methSymbol = ASTHelpers.getSymbol((MethodInvocationTree)tree);
        if (methSymbol == null) {
            return Description.NO_MATCH;
        }
        Optional<Symbol.MethodSymbol> superWithRestrictedApi = ASTHelpers.findSuperMethods((Symbol.MethodSymbol)methSymbol, (Types)state.getTypes()).stream().filter(t -> ASTHelpers.hasAnnotation((Symbol)t, RestrictedApi.class, (VisitorState)state)).findFirst();
        if (!superWithRestrictedApi.isPresent()) {
            return Description.NO_MATCH;
        }
        return this.checkRestriction((RestrictedApi)ASTHelpers.getAnnotation((Symbol)superWithRestrictedApi.get(), RestrictedApi.class), tree, state);
    }

    public Description matchNewClass(NewClassTree tree, VisitorState state) {
        return this.checkRestriction((RestrictedApi)ASTHelpers.getAnnotation((Tree)tree, RestrictedApi.class), tree, state);
    }

    private Description checkRestriction(@Nullable RestrictedApi restriction, Tree where, VisitorState state) {
        if (restriction == null) {
            return Description.NO_MATCH;
        }
        if (!restriction.allowedOnPath().isEmpty()) {
            JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
            String path = ASTHelpers.getFileNameFromUri((URI)compilationUnit.getSourceFile().toUri());
            if (Pattern.matches(restriction.allowedOnPath(), path)) {
                return Description.NO_MATCH;
            }
        }
        boolean warn = Matchers.enclosingNode(RestrictedApiChecker.shouldAllowWithWarning(restriction)).matches(where, state);
        boolean allow = Matchers.enclosingNode(RestrictedApiChecker.shouldAllow(restriction)).matches(where, state);
        if (warn && allow) {
            return this.buildDescription(where).setMessage("The Restricted API ([" + restriction.checkerName() + "]" + restriction.explanation() + ") call here is both whitelisted-as-warning and silently whitelisted. Please remove one of the conflicting suppression annotations.").build();
        }
        if (allow) {
            return Description.NO_MATCH;
        }
        BugPattern.SeverityLevel level = warn ? BugPattern.SeverityLevel.WARNING : BugPattern.SeverityLevel.ERROR;
        Description.Builder description = Description.builder((Tree)where, (String)restriction.checkerName(), (String)restriction.link(), (BugPattern.SeverityLevel)level, (String)restriction.explanation());
        return description.build();
    }

    private static Matcher<Tree> shouldAllow(RestrictedApi api) {
        try {
            return Matchers.hasAnyAnnotation((Class[])api.whitelistAnnotations());
        }
        catch (MirroredTypesException e) {
            return Matchers.hasAnyAnnotation(e.getTypeMirrors());
        }
    }

    private static Matcher<Tree> shouldAllowWithWarning(RestrictedApi api) {
        try {
            return Matchers.hasAnyAnnotation((Class[])api.whitelistWithWarningAnnotations());
        }
        catch (MirroredTypesException e) {
            return Matchers.hasAnyAnnotation(e.getTypeMirrors());
        }
    }
}

