/*
 * Decompiled with CFR 0.152.
 */
package com.google.auth.oauth2;

import com.google.auth.oauth2.AutoValue_JwtClaims;
import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableMap;
import java.io.Serializable;
import java.util.Map;
import javax.annotation.Nullable;

@AutoValue
public abstract class JwtClaims
implements Serializable {
    private static final long serialVersionUID = 4974444151019426702L;

    @Nullable
    abstract String getAudience();

    @Nullable
    abstract String getIssuer();

    @Nullable
    abstract String getSubject();

    abstract Map<String, String> getAdditionalClaims();

    static Builder newBuilder() {
        return new AutoValue_JwtClaims.Builder().setAdditionalClaims((Map<String, String>)ImmutableMap.of());
    }

    public JwtClaims merge(JwtClaims other) {
        ImmutableMap.Builder newClaimsBuilder = ImmutableMap.builder();
        newClaimsBuilder.putAll(this.getAdditionalClaims());
        newClaimsBuilder.putAll(other.getAdditionalClaims());
        return JwtClaims.newBuilder().setAudience(other.getAudience() == null ? this.getAudience() : other.getAudience()).setIssuer(other.getIssuer() == null ? this.getIssuer() : other.getIssuer()).setSubject(other.getSubject() == null ? this.getSubject() : other.getSubject()).setAdditionalClaims((Map<String, String>)newClaimsBuilder.build()).build();
    }

    public boolean isComplete() {
        return this.getAudience() != null && this.getIssuer() != null && this.getSubject() != null;
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setAudience(String var1);

        abstract Builder setIssuer(String var1);

        abstract Builder setSubject(String var1);

        abstract Builder setAdditionalClaims(Map<String, String> var1);

        abstract JwtClaims build();
    }
}

