/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.sun.source.tree.CatchTree;
import com.sun.source.tree.ExpressionStatementTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.TryTree;
import com.sun.tools.javac.tree.JCTree;
import java.util.List;

@BugPattern(name="TryFailRefactoring", category=BugPattern.Category.JUNIT, summary="Prefer assertThrows to try/fail", severity=BugPattern.SeverityLevel.SUGGESTION, tags={"Refactoring"}, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class TryFailRefactoring
extends BugChecker
implements BugChecker.TryTreeMatcher {
    private static final Matcher<StatementTree> FAIL_METHOD = Matchers.expressionStatement((Matcher)MethodMatchers.staticMethod().anyClass().named("fail"));

    public Description matchTry(TryTree tree, VisitorState state) {
        boolean useExpressionLambda;
        List<? extends StatementTree> body = tree.getBlock().getStatements();
        if (body.isEmpty() || tree.getFinallyBlock() != null || tree.getCatches().size() != 1) {
            return Description.NO_MATCH;
        }
        CatchTree catchTree = (CatchTree)Iterables.getOnlyElement(tree.getCatches());
        if (catchTree.getParameter().getType().getKind() == Tree.Kind.UNION_TYPE) {
            return Description.NO_MATCH;
        }
        if (!FAIL_METHOD.matches((Tree)Iterables.getLast(body), state)) {
            return Description.NO_MATCH;
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        StringBuilder fixPrefix = new StringBuilder();
        List<? extends StatementTree> throwingStatements = tree.getBlock().getStatements().subList(0, tree.getBlock().getStatements().size() - 1);
        if (throwingStatements.isEmpty()) {
            return Description.NO_MATCH;
        }
        List<? extends StatementTree> catchStatements = catchTree.getBlock().getStatements();
        fix.addStaticImport("org.junit.Assert.assertThrows");
        if (!catchStatements.isEmpty()) {
            fixPrefix.append(String.format("%s = ", state.getSourceForNode((Tree)catchTree.getParameter())));
        }
        fixPrefix.append(String.format("assertThrows(%s.class, () -> ", state.getSourceForNode(catchTree.getParameter().getType())));
        boolean bl = useExpressionLambda = throwingStatements.size() == 1 && ((StatementTree)Iterables.getOnlyElement(throwingStatements)).getKind() == Tree.Kind.EXPRESSION_STATEMENT;
        if (!useExpressionLambda) {
            fixPrefix.append("{");
        }
        fix.replace(((JCTree)((Object)tree)).getStartPosition(), ((JCTree)((Object)throwingStatements.iterator().next())).getStartPosition(), fixPrefix.toString());
        if (useExpressionLambda) {
            fix.postfixWith((Tree)((ExpressionStatementTree)throwingStatements.iterator().next()).getExpression(), ")");
        } else {
            fix.postfixWith((Tree)Iterables.getLast(throwingStatements), "});");
        }
        if (catchStatements.isEmpty()) {
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(throwingStatements)), state.getEndPosition((Tree)tree), "");
        } else {
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(throwingStatements)), ((JCTree)((Object)catchStatements.get(0))).getStartPosition(), "\n");
            fix.replace(state.getEndPosition((Tree)Iterables.getLast(catchStatements)), state.getEndPosition((Tree)tree), "");
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }
}

