/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.Lists;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import java.util.ArrayList;
import java.util.Comparator;

@BugPattern(name="ComparableAndComparator", summary="Class should not implement both `Comparable` and `Comparator`", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class ComparableAndComparator
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    private static final String COMPARABLE = Comparable.class.getCanonicalName();
    private static final String COMPARATOR = Comparator.class.getCanonicalName();
    private static final Matcher<Tree> COMPARABLE_MATCHER = Matchers.isSubtypeOf((String)COMPARABLE);
    private static final Matcher<Tree> COMPARATOR_MATCHER = Matchers.isSubtypeOf((String)COMPARATOR);
    private static final Matcher<Tree> COMPARABLE_AND_COMPARATOR_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{COMPARABLE_MATCHER, COMPARATOR_MATCHER});

    private static boolean matchAnySuperType(ClassTree tree, VisitorState state) {
        ArrayList superTypes = Lists.newArrayList(tree.getImplementsClause());
        Tree superClass = tree.getExtendsClause();
        if (superClass != null) {
            superTypes.add(superClass);
        }
        return superTypes.stream().anyMatch(superType -> COMPARABLE_AND_COMPARATOR_MATCHER.matches(superType, state));
    }

    public Description matchClass(ClassTree tree, VisitorState state) {
        if (COMPARABLE_AND_COMPARATOR_MATCHER.matches((Tree)tree, state)) {
            if (ComparableAndComparator.matchAnySuperType(tree, state)) {
                return Description.NO_MATCH;
            }
            Symbol.ClassSymbol symbol = ASTHelpers.getSymbol((ClassTree)tree);
            if (symbol.isEnum()) {
                return Description.NO_MATCH;
            }
            return this.describeMatch(tree);
        }
        return Description.NO_MATCH;
    }
}

