/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Optional;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.AbstractToString;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.predicates.TypePredicate;
import com.google.errorprone.predicates.TypePredicates;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Type;

@BugPattern(name="TreeToString", summary="Tree#toString shouldn't be used for Trees deriving from the code being compiled, as it discards whitespace and comments.", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.NO_FIX)
public class TreeToString
extends AbstractToString {
    private static final Matcher<ClassTree> IS_BUGCHECKER = Matchers.isSubtypeOf((String)"com.google.errorprone.bugpatterns.BugChecker");
    private static final TypePredicate IS_TREE = TypePredicates.isDescendantOf((String)"com.sun.source.tree.Tree");

    private static boolean treeToStringInBugChecker(Type type, VisitorState state) {
        ClassTree enclosingClass = (ClassTree)ASTHelpers.findEnclosingNode((TreePath)state.getPath(), ClassTree.class);
        if (enclosingClass == null || !IS_BUGCHECKER.matches((Tree)enclosingClass, state)) {
            return false;
        }
        return IS_TREE.apply(type, state);
    }

    @Override
    protected TypePredicate typePredicate() {
        return TreeToString::treeToStringInBugChecker;
    }

    @Override
    protected Optional<String> descriptionMessageForDefaultMatch(Type type, VisitorState state) {
        return Optional.of((Object)"Tree#toString shouldn't be used.");
    }

    @Override
    protected Optional<Fix> implicitToStringFix(ExpressionTree tree, VisitorState state) {
        return TreeToString.fix(tree, tree, state);
    }

    @Override
    protected Optional<Fix> toStringFix(Tree parent, ExpressionTree tree, VisitorState state) {
        if (!(parent instanceof MethodInvocationTree)) {
            return Optional.absent();
        }
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)((ExpressionTree)parent));
        if (receiver == null) {
            return Optional.absent();
        }
        return TreeToString.fix(receiver, parent, state);
    }

    private static Optional<Fix> fix(Tree target, Tree replace, VisitorState state) {
        return Optional.fromJavaUtil(FindIdentifiers.findAllIdents((VisitorState)state).stream().filter(s -> ASTHelpers.isSubtype((Type)s.type, (Type)state.getTypeFromString("com.google.errorprone.VisitorState"), (VisitorState)state)).findFirst().map(s -> SuggestedFix.replace((Tree)replace, (String)String.format("%s.getSourceForNode(%s)", s, state.getSourceForNode(target)))));
    }
}

