/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.collect.ImmutableList;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFixes;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;

@BugPattern(name="OverrideThrowableToString", summary="To return a custom message with a Throwable class, one should override getMessage() instead of toString().", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public final class OverrideThrowableToString
extends BugChecker
implements BugChecker.ClassTreeMatcher {
    public Description matchClass(ClassTree classTree, VisitorState state) {
        if (!ASTHelpers.isSubtype((Type)ASTHelpers.getType((ClassTree)classTree), (Type)state.getSymtab().throwableType, (VisitorState)state)) {
            return Description.NO_MATCH;
        }
        ImmutableList methods = (ImmutableList)classTree.getMembers().stream().filter(m -> m instanceof MethodTree).map(m -> (MethodTree)m).collect(ImmutableList.toImmutableList());
        if (methods.stream().anyMatch(m -> m.getName().contentEquals("getMessage"))) {
            return Description.NO_MATCH;
        }
        return methods.stream().filter(m -> Matchers.toStringMethodDeclaration().matches((Tree)m, state)).findFirst().map(m -> this.describeMatch(classTree, (Fix)SuggestedFixes.renameMethod((MethodTree)m, (String)"getMessage", (VisitorState)state))).orElse(Description.NO_MATCH);
    }
}

