/*
 * Decompiled with CFR 0.152.
 */
package com.android.util;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class PropertiesMap
extends HashMap<String, Property> {
    public static final PropertiesMap EMPTY_MAP = new EmptyMap();

    public PropertiesMap() {
    }

    public PropertiesMap(int capacity) {
        super(capacity);
    }

    private static class EmptyMap
    extends PropertiesMap {
        EmptyMap() {
            super(0);
        }

        @Override
        public int size() {
            return 0;
        }

        @Override
        public boolean isEmpty() {
            return true;
        }

        @Override
        public Property get(Object key) {
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            return false;
        }

        @Override
        public Property put(String key, Property value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends String, ? extends Property> m) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Property remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
        }

        @Override
        public boolean containsValue(Object value) {
            return false;
        }

        @Override
        public Set<String> keySet() {
            return Collections.emptySet();
        }

        @Override
        public Collection<Property> values() {
            return Collections.emptySet();
        }

        @Override
        public Set<Map.Entry<String, Property>> entrySet() {
            return Collections.emptySet();
        }

        @Override
        public Property getOrDefault(Object key, Property defaultValue) {
            return defaultValue;
        }

        @Override
        public Property putIfAbsent(String key, Property value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(String key, Property oldValue, Property newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public Property replace(String key, Property value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        @Override
        public int hashCode() {
            return 0;
        }
    }

    public static class Property {
        public final String resource;
        public final String value;

        public Property(String resource, String value) {
            this.resource = resource;
            this.value = value;
        }

        public boolean equals(Object other) {
            if (!(other instanceof Property)) {
                return false;
            }
            Property otherProperty = (Property)other;
            return Objects.equals(this.resource, otherProperty.resource) && Objects.equals(this.value, otherProperty.value);
        }

        public int hashCode() {
            return Objects.hash(this.resource, this.value);
        }
    }
}

