/*
 * Decompiled with CFR 0.152.
 */
package com.android.sdklib.repository.local;

import com.android.repository.Revision;
import com.android.sdklib.repository.descriptors.IPkgDesc;
import com.android.sdklib.repository.descriptors.IPkgDescExtra;
import com.android.sdklib.repository.descriptors.PkgDesc;
import com.android.sdklib.repository.local.LocalPkgInfo;
import com.android.sdklib.repository.local.LocalSdk;
import com.android.sdklib.repositoryv2.IdDisplay;
import java.io.File;
import java.util.Properties;

public class LocalExtraPkgInfo
extends LocalPkgInfo {
    private final IPkgDescExtra mDesc;

    public LocalExtraPkgInfo(LocalSdk localSdk, File localDir, Properties sourceProps, IdDisplay vendor, String path, String displayName, String[] oldPaths, Revision revision) {
        super(localSdk, localDir, sourceProps);
        this.mDesc = (IPkgDescExtra)PkgDesc.Builder.newExtra(vendor, path, displayName, oldPaths, revision).create();
    }

    @Override
    public IPkgDesc getDesc() {
        return this.mDesc;
    }

    public String[] getOldPaths() {
        return this.mDesc.getOldPaths();
    }

    public static String getPrettyName(IdDisplay vendor, String extraPath) {
        String disp;
        String name = extraPath;
        String string = disp = vendor == null ? null : vendor.getDisplay();
        if (disp != null && !disp.isEmpty() && name.startsWith(disp + "-")) {
            name = name.substring(disp.length() + 1);
        }
        if (name != null) {
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        if (name == null || name.isEmpty()) {
            name = "Unknown Extra";
        }
        if (disp != null && !disp.isEmpty()) {
            name = disp + " " + name;
            name = name.replaceAll("[ _\t\f-]+", " ").trim();
        }
        boolean changed = false;
        char[] chars = name.toCharArray();
        int n = chars.length - 1;
        for (int i = 0; i < n; ++i) {
            if (!Character.isLowerCase(chars[i]) || i != 0 && chars[i - 1] != ' ') continue;
            chars[i] = Character.toUpperCase(chars[i]);
            changed = true;
        }
        if (changed) {
            name = new String(chars);
        }
        name = name.replaceAll(" Usb ", " USB ");
        name = name.replaceAll(" Api ", " API ");
        return name;
    }
}

