/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableList;
import com.google.devtools.build.lib.skyframe.serialization.DeserializationContext;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationContext;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

class MapCodec<K, V>
implements ObjectCodec<Map<K, V>> {
    private static final Class<Map<?, ?>> UNMODIFIABLE_TYPE = Collections.unmodifiableMap(new HashMap()).getClass();

    MapCodec() {
    }

    @Override
    public Class<Map<K, V>> getEncodedClass() {
        return this.cast(HashMap.class);
    }

    @Override
    public List<Class<? extends Map<K, V>>> additionalEncodedClasses() {
        return ImmutableList.of(this.cast(UNMODIFIABLE_TYPE));
    }

    @Override
    public void serialize(SerializationContext context, Map<K, V> obj, CodedOutputStream codedOut) throws SerializationException, IOException {
        codedOut.writeInt32NoTag(obj.size());
        for (Map.Entry<K, V> entry : obj.entrySet()) {
            context.serialize(entry.getKey(), codedOut);
            context.serialize(entry.getValue(), codedOut);
        }
    }

    @Override
    public Map<K, V> deserialize(DeserializationContext context, CodedInputStream codedIn) throws SerializationException, IOException {
        int size = codedIn.readInt32();
        LinkedHashMap result = new LinkedHashMap(4 * size / 3);
        for (int i = 0; i < size; ++i) {
            result.put(context.deserialize(codedIn), context.deserialize(codedIn));
        }
        return Collections.unmodifiableMap(result);
    }

    private Class<Map<K, V>> cast(Class<? extends Map> clazz) {
        return clazz;
    }
}

