/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.auto.value.AutoValue;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import com.google.turbine.binder.AutoValue_Processing_ProcessorInfo;
import com.google.turbine.binder.Binder;
import com.google.turbine.binder.ClassPath;
import com.google.turbine.binder.bound.SourceTypeBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.parse.Parser;
import com.google.turbine.processing.ModelFactory;
import com.google.turbine.processing.TurbineElement;
import com.google.turbine.processing.TurbineFiler;
import com.google.turbine.processing.TurbineProcessingEnvironment;
import com.google.turbine.processing.TurbineRoundEnvironment;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.annotation.processing.Processor;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.TypeElement;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Processing {
    static Binder.BindingResult process(TurbineLog log, List<Tree.CompUnit> initialSources, final ClassPath classpath, ProcessorInfo processorInfo, ClassPath bootclasspath, Binder.BindingResult result, Optional<String> moduleVersion) {
        HashSet<String> seen = new HashSet<String>();
        for (Tree.CompUnit u : initialSources) {
            if (u.source() == null) continue;
            seen.add(u.source().path());
        }
        TurbineFiler filer = new TurbineFiler(seen, new Function<String, Supplier<byte[]>>(){

            public @Nullable Supplier<byte[]> apply(@Nullable String input) {
                return classpath.resource(input);
            }
        }, processorInfo.loader());
        SimpleEnv<ClassSymbol, SourceTypeBoundClass> tenv = new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(result.units());
        CompoundEnv<ClassSymbol, TypeBoundClass> env = CompoundEnv.of(result.classPathEnv()).append(tenv);
        ModelFactory factory = new ModelFactory(env, processorInfo.loader(), result.tli());
        for (Processor processor : processorInfo.processors()) {
            processor.init(new TurbineProcessingEnvironment(factory, filer, log, (Map<String, String>)processorInfo.options(), processorInfo.sourceVersion()));
        }
        HashMap<Processor, Pattern> wanted = new HashMap<Processor, Pattern>();
        for (Processor processor : processorInfo.processors()) {
            ArrayList<String> patterns = new ArrayList<String>();
            for (String supportedAnnotationType : processor.getSupportedAnnotationTypes()) {
                patterns.add(supportedAnnotationType.replace("*", ".*"));
            }
            wanted.put(processor, Pattern.compile(Joiner.on((char)'|').join(patterns)));
        }
        HashSet allSymbols = new HashSet();
        ArrayList<Tree.CompUnit> units = new ArrayList<Tree.CompUnit>(initialSources);
        LinkedHashSet<Processor> toRun = new LinkedHashSet<Processor>();
        boolean errorRaised = false;
        while (true) {
            ImmutableSet syms = Sets.difference((Set)result.units().keySet(), allSymbols).immutableCopy();
            allSymbols.addAll(syms);
            if (syms.isEmpty()) break;
            ImmutableSetMultimap<ClassSymbol, Symbol> allAnnotations = Processing.getAllAnnotations(env, (Iterable<ClassSymbol>)syms);
            TurbineRoundEnvironment roundEnv = null;
            for (Processor processor : processorInfo.processors()) {
                HashSet<TurbineElement.TurbineTypeElement> annotations = new HashSet<TurbineElement.TurbineTypeElement>();
                Pattern pattern = (Pattern)wanted.get(processor);
                boolean run = toRun.contains(processor);
                for (ClassSymbol a : allAnnotations.keys()) {
                    if (!pattern.matcher(a.toString()).matches()) continue;
                    annotations.add(factory.typeElement(a));
                    run = true;
                }
                if (!run) continue;
                toRun.add(processor);
                if (roundEnv == null) {
                    roundEnv = new TurbineRoundEnvironment(factory, (ImmutableSet<ClassSymbol>)syms, false, errorRaised, allAnnotations);
                }
                boolean bl = processor.process(annotations, roundEnv);
            }
            Collection<SourceFile> files = filer.finishRound();
            if (files.isEmpty()) break;
            for (SourceFile file : files) {
                units.add(Parser.parse(file));
            }
            errorRaised = log.errorRaised();
            if (errorRaised) {
                log.maybeThrow();
            }
            log.clear();
            result = Binder.bind(log, units, filer.generatedSources(), filer.generatedClasses(), classpath, bootclasspath, moduleVersion);
            tenv = new SimpleEnv<ClassSymbol, SourceTypeBoundClass>(result.units());
            env = CompoundEnv.of(result.classPathEnv()).append(tenv);
            factory.round(env, result.tli());
        }
        TurbineRoundEnvironment roundEnv = null;
        for (Processor processor : toRun) {
            if (roundEnv == null) {
                roundEnv = new TurbineRoundEnvironment(factory, (ImmutableSet<ClassSymbol>)ImmutableSet.of(), true, errorRaised, (ImmutableSetMultimap<ClassSymbol, Symbol>)ImmutableSetMultimap.of());
            }
            processor.process((Set<? extends TypeElement>)ImmutableSet.of(), roundEnv);
        }
        Collection<SourceFile> files = filer.finishRound();
        if (!files.isEmpty()) {
            for (SourceFile file : files) {
                units.add(Parser.parse(file));
            }
            result = Binder.bind(log, units, filer.generatedSources(), filer.generatedClasses(), classpath, bootclasspath, moduleVersion);
            log.maybeThrow();
        }
        if (!filer.generatedClasses().isEmpty()) {
            result = new Binder.BindingResult(result.units(), result.modules(), result.classPathEnv(), result.tli(), result.generatedSources(), filer.generatedClasses());
        }
        return result;
    }

    private static ImmutableSetMultimap<ClassSymbol, Symbol> getAllAnnotations(Env<ClassSymbol, TypeBoundClass> env, Iterable<ClassSymbol> syms) {
        ImmutableSetMultimap.Builder result = ImmutableSetMultimap.builder();
        for (ClassSymbol sym : syms) {
            TypeBoundClass info = env.get(sym);
            for (AnnoInfo annoInfo : info.annotations()) {
                if (sym.simpleName().equals("package-info")) {
                    Processing.addAnno((ImmutableSetMultimap.Builder<ClassSymbol, Symbol>)result, annoInfo, sym.owner());
                    continue;
                }
                Processing.addAnno((ImmutableSetMultimap.Builder<ClassSymbol, Symbol>)result, annoInfo, sym);
            }
            for (TypeBoundClass.MethodInfo method : info.methods()) {
                for (AnnoInfo annoInfo : method.annotations()) {
                    Processing.addAnno((ImmutableSetMultimap.Builder<ClassSymbol, Symbol>)result, annoInfo, method.sym());
                }
                for (TypeBoundClass.ParamInfo param : method.parameters()) {
                    for (AnnoInfo annoInfo : param.annotations()) {
                        Processing.addAnno((ImmutableSetMultimap.Builder<ClassSymbol, Symbol>)result, annoInfo, param.sym());
                    }
                }
            }
            for (TypeBoundClass.FieldInfo field : info.fields()) {
                for (AnnoInfo annoInfo : field.annotations()) {
                    Processing.addAnno((ImmutableSetMultimap.Builder<ClassSymbol, Symbol>)result, annoInfo, field.sym());
                }
            }
        }
        return result.build();
    }

    private static void addAnno(ImmutableSetMultimap.Builder<ClassSymbol, Symbol> result, AnnoInfo annoInfo, Symbol owner) {
        ClassSymbol sym = annoInfo.sym();
        if (sym != null) {
            result.put((Object)sym, (Object)owner);
        }
    }

    public static ProcessorInfo initializeProcessors(ImmutableList<String> javacopts, ImmutableList<String> processorPath, ImmutableSet<String> processorNames) throws MalformedURLException {
        ImmutableMap<String, String> processorOptions;
        ClassLoader processorLoader = null;
        ImmutableList.Builder processors = ImmutableList.builder();
        if (!processorNames.isEmpty() && !javacopts.contains((Object)"-proc:none")) {
            processorLoader = !processorPath.isEmpty() ? new URLClassLoader(Processing.toUrls(processorPath), new ClassLoader(Processing.getPlatformClassLoader()){

                @Override
                protected Class<?> findClass(String name) throws ClassNotFoundException {
                    if (name.startsWith("com.sun.source.") || name.startsWith("com.sun.tools.") || name.startsWith("com.google.common.collect.") || name.startsWith("com.google.common.base.")) {
                        return Class.forName(name);
                    }
                    throw new ClassNotFoundException(name);
                }
            }) : Processing.class.getClassLoader();
            for (String processor : processorNames) {
                try {
                    Class<Processor> clazz = Class.forName(processor, false, processorLoader).asSubclass(Processor.class);
                    processors.add((Object)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
                }
                catch (ReflectiveOperationException e) {
                    throw new LinkageError(e.getMessage(), e);
                }
            }
            processorOptions = Processing.processorOptions(javacopts);
        } else {
            processorOptions = ImmutableMap.of();
        }
        SourceVersion sourceVersion = SourceVersion.latestSupported();
        UnmodifiableIterator it = javacopts.iterator();
        while (it.hasNext()) {
            String option;
            block4 : switch (option = (String)it.next()) {
                case "-target": {
                    String value;
                    if (!it.hasNext()) break;
                    switch (value = (String)it.next()) {
                        case "5": 
                        case "1.5": {
                            sourceVersion = SourceVersion.RELEASE_5;
                            break block4;
                        }
                        case "6": 
                        case "1.6": {
                            sourceVersion = SourceVersion.RELEASE_6;
                            break block4;
                        }
                        case "7": 
                        case "1.7": {
                            sourceVersion = SourceVersion.RELEASE_7;
                            break block4;
                        }
                        case "8": {
                            sourceVersion = SourceVersion.RELEASE_8;
                            break block4;
                        }
                    }
                    break;
                }
            }
        }
        return ProcessorInfo.create((ImmutableList<Processor>)processors.build(), processorLoader, processorOptions, sourceVersion);
    }

    private static URL[] toUrls(ImmutableList<String> processorPath) throws MalformedURLException {
        URL[] urls = new URL[processorPath.size()];
        int i = 0;
        for (String path : processorPath) {
            urls[i++] = Paths.get(path, new String[0]).toUri().toURL();
        }
        return urls;
    }

    public static ClassLoader getPlatformClassLoader() {
        try {
            return (ClassLoader)ClassLoader.class.getMethod("getPlatformClassLoader", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    private static ImmutableMap<String, String> processorOptions(ImmutableList<String> javacopts) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String javacopt : javacopts) {
            String value;
            String key;
            if (!javacopt.startsWith("-A")) continue;
            int idx = (javacopt = javacopt.substring("-A".length())).indexOf(61);
            if (idx != -1) {
                key = javacopt.substring(0, idx);
                value = javacopt.substring(idx + 1);
            } else {
                key = javacopt;
                value = javacopt;
            }
            result.put(key, value);
        }
        return ImmutableMap.copyOf(result);
    }

    @AutoValue
    public static abstract class ProcessorInfo {
        abstract ImmutableList<Processor> processors();

        abstract @Nullable ClassLoader loader();

        abstract ImmutableMap<String, String> options();

        public abstract SourceVersion sourceVersion();

        public static ProcessorInfo create(ImmutableList<Processor> processors, @Nullable ClassLoader loader, ImmutableMap<String, String> options, SourceVersion sourceVersion) {
            return new AutoValue_Processing_ProcessorInfo(processors, loader, options, sourceVersion);
        }

        static ProcessorInfo empty() {
            return ProcessorInfo.create((ImmutableList<Processor>)ImmutableList.of(), null, (ImmutableMap<String, String>)ImmutableMap.of(), SourceVersion.latest());
        }
    }
}

