/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.EnumConstantValue;
import com.google.turbine.binder.bound.TurbineAnnotationValue;
import com.google.turbine.binder.bound.TurbineClassValue;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.lookup.MemberImportIndex;
import com.google.turbine.binder.lookup.Scope;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.Symbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.diag.TurbineLog;
import com.google.turbine.model.Const;
import com.google.turbine.model.TurbineConstantTypeKind;
import com.google.turbine.tree.Tree;
import com.google.turbine.type.AnnoInfo;
import com.google.turbine.type.Type;
import java.util.ArrayDeque;
import java.util.Iterator;
import java.util.LinkedHashMap;

public strictfp class ConstEvaluator {
    private final ClassSymbol origin;
    private final ClassSymbol owner;
    private final MemberImportIndex memberImports;
    private final SourceFile source;
    private final Env<FieldSymbol, Const.Value> values;
    private final CompoundEnv<ClassSymbol, TypeBoundClass> env;
    private final Scope scope;
    private final TurbineLog.TurbineLogWithSource log;
    static final int INT_SHIFT_MASK = 31;
    static final int LONG_SHIFT_MASK = 63;

    public ConstEvaluator(ClassSymbol origin, ClassSymbol owner, MemberImportIndex memberImports, SourceFile source, Scope scope, Env<FieldSymbol, Const.Value> values, CompoundEnv<ClassSymbol, TypeBoundClass> env, TurbineLog.TurbineLogWithSource log) {
        this.origin = origin;
        this.owner = owner;
        this.memberImports = memberImports;
        this.source = source;
        this.values = values;
        this.env = env;
        this.scope = scope;
        this.log = log;
    }

    public Const eval(Tree t) {
        switch (t.kind()) {
            case LITERAL: {
                Const.Value a = (Const.Value)((Tree.Literal)t).value();
                if (a == null) {
                    return null;
                }
                switch (a.constantTypeKind()) {
                    case CHAR: {
                        return new Const.CharValue(((Const.CharValue)a).value());
                    }
                    case INT: {
                        return new Const.IntValue(((Const.IntValue)a).value());
                    }
                    case LONG: {
                        return new Const.LongValue(((Const.LongValue)a).value());
                    }
                    case FLOAT: {
                        return new Const.FloatValue(((Const.FloatValue)a).value());
                    }
                    case DOUBLE: {
                        return new Const.DoubleValue(((Const.DoubleValue)a).value());
                    }
                    case BOOLEAN: {
                        return new Const.BooleanValue(((Const.BooleanValue)a).value());
                    }
                    case STRING: {
                        return new Const.StringValue(((Const.StringValue)a).value());
                    }
                }
                throw new AssertionError((Object)a.constantTypeKind());
            }
            case VOID_TY: {
                throw new AssertionError((Object)t.kind());
            }
            case CONST_VAR_NAME: {
                return this.evalConstVar((Tree.ConstVarName)t);
            }
            case CLASS_LITERAL: {
                return this.evalClassLiteral((Tree.ClassLiteral)t);
            }
            case BINARY: {
                return this.evalBinary((Tree.Binary)t);
            }
            case TYPE_CAST: {
                return this.evalCast((Tree.TypeCast)t);
            }
            case UNARY: {
                return this.evalUnary((Tree.Unary)t);
            }
            case CONDITIONAL: {
                return this.evalConditional((Tree.Conditional)t);
            }
            case ARRAY_INIT: {
                return this.evalArrayInit((Tree.ArrayInit)t);
            }
            case ANNO_EXPR: {
                return this.evalAnno(((Tree.AnnoExpr)t).value());
            }
        }
        throw this.error(t.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
    }

    Const evalClassLiteral(Tree.ClassLiteral t) {
        return new TurbineClassValue(this.evalClassLiteralType(t.type()));
    }

    private Type evalClassLiteralType(Tree.Type type) {
        switch (type.kind()) {
            case PRIM_TY: {
                return Type.PrimTy.create(((Tree.PrimTy)type).tykind(), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
            case VOID_TY: {
                return Type.VOID;
            }
            case CLASS_TY: {
                return this.resolveClass((Tree.ClassTy)type);
            }
            case ARR_TY: {
                return Type.ArrayTy.create(this.evalClassLiteralType(((Tree.ArrTy)type).elem()), (ImmutableList<AnnoInfo>)ImmutableList.of());
            }
        }
        throw new AssertionError((Object)type.kind());
    }

    private Type resolveClass(Tree.ClassTy classTy) {
        ArrayDeque<Tree.Ident> flat = new ArrayDeque<Tree.Ident>();
        Tree.ClassTy curr = classTy;
        while (curr != null) {
            flat.addFirst(curr.name());
            curr = curr.base().orElse(null);
        }
        LookupResult result = this.scope.lookup(new LookupKey((ImmutableList<Tree.Ident>)ImmutableList.copyOf(flat)));
        if (result == null) {
            this.log.error(classTy.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, flat.peekFirst());
            return Type.ErrorTy.create(flat);
        }
        if (result.sym().symKind() != Symbol.Kind.CLASS) {
            throw this.error(classTy.position(), TurbineError.ErrorKind.UNEXPECTED_TYPE_PARAMETER, flat.peekFirst());
        }
        ClassSymbol classSym = (ClassSymbol)result.sym();
        for (Tree.Ident bit : result.remaining()) {
            classSym = this.resolveNext(classTy.position(), classSym, bit);
        }
        return Type.ClassTy.asNonParametricClassTy(classSym);
    }

    private ClassSymbol resolveNext(int position, ClassSymbol sym, Tree.Ident bit) {
        ClassSymbol next = Resolve.resolve(this.env, this.origin, sym, bit);
        if (next == null) {
            throw this.error(position, TurbineError.ErrorKind.SYMBOL_NOT_FOUND, new ClassSymbol(sym.binaryName() + '$' + bit));
        }
        return next;
    }

    Const evalConstVar(Tree.ConstVarName t) {
        TypeBoundClass.FieldInfo field = this.resolveField(t);
        if (field == null) {
            return null;
        }
        if ((field.access() & 0x4000) == 16384) {
            return new EnumConstantValue(field.sym());
        }
        if (field.value() != null) {
            return field.value();
        }
        return this.values.get(field.sym());
    }

    TypeBoundClass.FieldInfo resolveField(Tree.ConstVarName t) {
        Tree.Ident simpleName = (Tree.Ident)t.name().get(0);
        TypeBoundClass.FieldInfo field = this.lexicalField(this.env, this.owner, simpleName);
        if (field != null) {
            return field;
        }
        field = this.resolveQualifiedField(t);
        if (field != null) {
            return field;
        }
        ClassSymbol classSymbol = this.memberImports.singleMemberImport(simpleName.value());
        if (classSymbol != null && (field = Resolve.resolveField(this.env, this.origin, classSymbol, simpleName)) != null) {
            return field;
        }
        Iterator<ClassSymbol> it = this.memberImports.onDemandImports();
        while (it.hasNext()) {
            field = Resolve.resolveField(this.env, this.origin, it.next(), simpleName);
            if (field == null || (field.access() & 2) == 2) continue;
            return field;
        }
        throw this.error(t.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, String.format("field %s", Iterables.getLast(t.name())));
    }

    private TypeBoundClass.FieldInfo resolveQualifiedField(Tree.ConstVarName t) {
        if (t.name().size() <= 1) {
            return null;
        }
        LookupResult result = this.scope.lookup(new LookupKey(t.name()));
        if (result == null) {
            return null;
        }
        if (result.remaining().isEmpty()) {
            return null;
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (int i = 0; i < result.remaining().size() - 1; ++i) {
            if ((sym = Resolve.resolve(this.env, sym, sym, (Tree.Ident)result.remaining().get(i))) != null) continue;
            return null;
        }
        return Resolve.resolveField(this.env, this.origin, sym, (Tree.Ident)Iterables.getLast(result.remaining()));
    }

    private TypeBoundClass.FieldInfo lexicalField(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol sym, Tree.Ident name) {
        while (sym != null) {
            TypeBoundClass info = env.get(sym);
            TypeBoundClass.FieldInfo field = Resolve.resolveField(env, this.origin, sym, name);
            if (field != null) {
                return field;
            }
            sym = info.owner();
        }
        return null;
    }

    static Const cast(Type ty, Const value) {
        Preconditions.checkNotNull((Object)value);
        switch (ty.tyKind()) {
            case CLASS_TY: 
            case TY_VAR: {
                return value;
            }
            case PRIM_TY: {
                return ConstEvaluator.coerce((Const.Value)value, ((Type.PrimTy)ty).primkind());
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private static Const.Value coerce(Const.Value value, TurbineConstantTypeKind kind) {
        switch (kind) {
            case BOOLEAN: {
                return value.asBoolean();
            }
            case STRING: {
                return value.asString();
            }
            case LONG: {
                return value.asLong();
            }
            case INT: {
                return value.asInteger();
            }
            case BYTE: {
                return value.asByte();
            }
            case CHAR: {
                return value.asChar();
            }
            case SHORT: {
                return value.asShort();
            }
            case DOUBLE: {
                return value.asDouble();
            }
            case FLOAT: {
                return value.asFloat();
            }
        }
        throw new AssertionError((Object)kind);
    }

    private Const.Value evalValue(Tree.Expression tree) {
        Const result = this.eval(tree);
        return result instanceof Const.Value ? (Const.Value)result : null;
    }

    private Const.Value evalConditional(Tree.Conditional t) {
        Const.Value condition = this.evalValue(t.cond());
        if (condition == null) {
            return null;
        }
        return condition.asBoolean().value() ? this.evalValue(t.iftrue()) : this.evalValue(t.iffalse());
    }

    private Const.Value evalUnary(Tree.Unary t) {
        Const.Value expr = this.evalValue(t.expr());
        if (expr == null) {
            return null;
        }
        switch (t.op()) {
            case NOT: {
                return ConstEvaluator.unaryNegate(expr);
            }
            case BITWISE_COMP: {
                return ConstEvaluator.bitwiseComp(expr);
            }
            case UNARY_PLUS: {
                return ConstEvaluator.unaryPlus(expr);
            }
            case NEG: {
                return ConstEvaluator.unaryMinus(expr);
            }
        }
        throw new AssertionError((Object)t.op());
    }

    private static Const.Value unaryNegate(Const.Value expr) {
        switch (expr.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(!expr.asBoolean().value());
            }
        }
        throw new AssertionError((Object)expr.constantTypeKind());
    }

    private static Const.Value bitwiseComp(Const.Value expr) {
        expr = ConstEvaluator.promoteUnary(expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(~expr.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(expr.asLong().value() ^ 0xFFFFFFFFFFFFFFFFL);
            }
        }
        throw new AssertionError((Object)expr.constantTypeKind());
    }

    private static Const.Value unaryPlus(Const.Value expr) {
        expr = ConstEvaluator.promoteUnary(expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(expr.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(expr.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(expr.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(expr.asDouble().value());
            }
        }
        throw new AssertionError((Object)expr.constantTypeKind());
    }

    private static Const.Value unaryMinus(Const.Value expr) {
        expr = ConstEvaluator.promoteUnary(expr);
        switch (expr.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(-expr.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(-expr.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(-expr.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(-expr.asDouble().value());
            }
        }
        throw new AssertionError((Object)expr.constantTypeKind());
    }

    private Const.Value evalCast(Tree.TypeCast t) {
        Const.Value expr = this.evalValue(t.expr());
        if (expr == null) {
            return null;
        }
        switch (t.ty().kind()) {
            case PRIM_TY: {
                return ConstEvaluator.coerce(expr, ((Tree.PrimTy)t.ty()).tykind());
            }
            case CLASS_TY: {
                Tree.ClassTy classTy = (Tree.ClassTy)t.ty();
                if (!classTy.name().value().equals("String")) {
                    return null;
                }
                return expr.asString();
            }
        }
        throw new AssertionError((Object)t.ty().kind());
    }

    static Const.Value add(Const.Value a, Const.Value b) {
        if (a.constantTypeKind() == TurbineConstantTypeKind.STRING || b.constantTypeKind() == TurbineConstantTypeKind.STRING) {
            return new Const.StringValue(a.asString().value() + b.asString().value());
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() + b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() + b.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(a.asFloat().value() + b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(a.asDouble().value() + b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value subtract(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() - b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() - b.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(a.asFloat().value() - b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(a.asDouble().value() - b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value mult(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() * b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() * b.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(a.asFloat().value() * b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(a.asDouble().value() * b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value divide(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() / b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() / b.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(a.asFloat().value() / b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(a.asDouble().value() / b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value mod(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() % b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() % b.asLong().value());
            }
            case FLOAT: {
                return new Const.FloatValue(a.asFloat().value() % b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.DoubleValue(a.asDouble().value() % b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value shiftLeft(Const.Value a, Const.Value b) {
        a = ConstEvaluator.promoteUnary(a);
        b = ConstEvaluator.promoteUnary(b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() << (b.asInteger().value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() << (b.asInteger().value() & 0x3F));
            }
        }
        throw new AssertionError((Object)a.constantTypeKind());
    }

    static Const.Value shiftRight(Const.Value a, Const.Value b) {
        a = ConstEvaluator.promoteUnary(a);
        b = ConstEvaluator.promoteUnary(b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() >> (b.asInteger().value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() >> (b.asInteger().value() & 0x3F));
            }
        }
        throw new AssertionError((Object)a.constantTypeKind());
    }

    static Const.Value unsignedShiftRight(Const.Value a, Const.Value b) {
        a = ConstEvaluator.promoteUnary(a);
        b = ConstEvaluator.promoteUnary(b);
        switch (a.constantTypeKind()) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() >>> (b.asInteger().value() & 0x1F));
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() >>> (b.asInteger().value() & 0x3F));
            }
        }
        throw new AssertionError((Object)a.constantTypeKind());
    }

    static Const.Value lessThan(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() < b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() < b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() < b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() < b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value lessThanEqual(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() <= b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() <= b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() <= b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() <= b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value greaterThan(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() > b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() > b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() > b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() > b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value greaterThanEqual(Const.Value a, Const.Value b) {
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() >= b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() >= b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() >= b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() >= b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value equal(Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case STRING: {
                return new Const.BooleanValue(a.asString().value().equals(b.asString().value()));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(a.asBoolean().value() == b.asBoolean().value());
            }
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() == b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() == b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() == b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() == b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value notEqual(Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case STRING: {
                return new Const.BooleanValue(!a.asString().value().equals(b.asString().value()));
            }
            case BOOLEAN: {
                return new Const.BooleanValue(a.asBoolean().value() != b.asBoolean().value());
            }
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.BooleanValue(a.asInteger().value() != b.asInteger().value());
            }
            case LONG: {
                return new Const.BooleanValue(a.asLong().value() != b.asLong().value());
            }
            case FLOAT: {
                return new Const.BooleanValue(a.asFloat().value() != b.asFloat().value());
            }
            case DOUBLE: {
                return new Const.BooleanValue(a.asDouble().value() != b.asDouble().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value bitwiseAnd(Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(a.asBoolean().value() & b.asBoolean().value());
            }
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() & b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() & b.asLong().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value bitwiseOr(Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(a.asBoolean().value() | b.asBoolean().value());
            }
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() | b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() | b.asLong().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    static Const.Value bitwiseXor(Const.Value a, Const.Value b) {
        switch (a.constantTypeKind()) {
            case BOOLEAN: {
                return new Const.BooleanValue(a.asBoolean().value() ^ b.asBoolean().value());
            }
        }
        TurbineConstantTypeKind type = ConstEvaluator.promoteBinary(a, b);
        a = ConstEvaluator.coerce(a, type);
        b = ConstEvaluator.coerce(b, type);
        switch (type) {
            case INT: {
                return new Const.IntValue(a.asInteger().value() ^ b.asInteger().value());
            }
            case LONG: {
                return new Const.LongValue(a.asLong().value() ^ b.asLong().value());
            }
        }
        throw new AssertionError((Object)type);
    }

    private Const.Value evalBinary(Tree.Binary t) {
        Const.Value lhs = this.evalValue(t.lhs());
        Const.Value rhs = this.evalValue(t.rhs());
        if (lhs == null || rhs == null) {
            return null;
        }
        switch (t.op()) {
            case PLUS: {
                return ConstEvaluator.add(lhs, rhs);
            }
            case MINUS: {
                return ConstEvaluator.subtract(lhs, rhs);
            }
            case MULT: {
                return ConstEvaluator.mult(lhs, rhs);
            }
            case DIVIDE: {
                return ConstEvaluator.divide(lhs, rhs);
            }
            case MODULO: {
                return ConstEvaluator.mod(lhs, rhs);
            }
            case SHIFT_LEFT: {
                return ConstEvaluator.shiftLeft(lhs, rhs);
            }
            case SHIFT_RIGHT: {
                return ConstEvaluator.shiftRight(lhs, rhs);
            }
            case UNSIGNED_SHIFT_RIGHT: {
                return ConstEvaluator.unsignedShiftRight(lhs, rhs);
            }
            case LESS_THAN: {
                return ConstEvaluator.lessThan(lhs, rhs);
            }
            case GREATER_THAN: {
                return ConstEvaluator.greaterThan(lhs, rhs);
            }
            case LESS_THAN_EQ: {
                return ConstEvaluator.lessThanEqual(lhs, rhs);
            }
            case GREATER_THAN_EQ: {
                return ConstEvaluator.greaterThanEqual(lhs, rhs);
            }
            case EQUAL: {
                return ConstEvaluator.equal(lhs, rhs);
            }
            case NOT_EQUAL: {
                return ConstEvaluator.notEqual(lhs, rhs);
            }
            case AND: {
                return new Const.BooleanValue(lhs.asBoolean().value() && rhs.asBoolean().value());
            }
            case OR: {
                return new Const.BooleanValue(lhs.asBoolean().value() || rhs.asBoolean().value());
            }
            case BITWISE_AND: {
                return ConstEvaluator.bitwiseAnd(lhs, rhs);
            }
            case BITWISE_XOR: {
                return ConstEvaluator.bitwiseXor(lhs, rhs);
            }
            case BITWISE_OR: {
                return ConstEvaluator.bitwiseOr(lhs, rhs);
            }
        }
        throw new AssertionError((Object)t.op());
    }

    private static Const.Value promoteUnary(Const.Value v) {
        switch (v.constantTypeKind()) {
            case CHAR: 
            case SHORT: 
            case BYTE: {
                return v.asInteger();
            }
            case INT: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: {
                return v;
            }
        }
        throw new AssertionError((Object)v.constantTypeKind());
    }

    private static TurbineConstantTypeKind promoteBinary(Const.Value a, Const.Value b) {
        a = ConstEvaluator.promoteUnary(a);
        b = ConstEvaluator.promoteUnary(b);
        switch (a.constantTypeKind()) {
            case INT: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return b.constantTypeKind();
                    }
                }
                throw new AssertionError((Object)b.constantTypeKind());
            }
            case LONG: {
                switch (b.constantTypeKind()) {
                    case INT: {
                        return TurbineConstantTypeKind.LONG;
                    }
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return b.constantTypeKind();
                    }
                }
                throw new AssertionError((Object)b.constantTypeKind());
            }
            case FLOAT: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: {
                        return TurbineConstantTypeKind.FLOAT;
                    }
                    case DOUBLE: {
                        return TurbineConstantTypeKind.DOUBLE;
                    }
                }
                throw new AssertionError((Object)b.constantTypeKind());
            }
            case DOUBLE: {
                switch (b.constantTypeKind()) {
                    case INT: 
                    case LONG: 
                    case FLOAT: 
                    case DOUBLE: {
                        return TurbineConstantTypeKind.DOUBLE;
                    }
                }
                throw new AssertionError((Object)b.constantTypeKind());
            }
        }
        throw new AssertionError((Object)a.constantTypeKind());
    }

    ImmutableList<AnnoInfo> evaluateAnnotations(ImmutableList<AnnoInfo> annotations) {
        ImmutableList.Builder result = ImmutableList.builder();
        for (AnnoInfo annotation : annotations) {
            result.add((Object)this.evaluateAnnotation(annotation));
        }
        return result.build();
    }

    AnnoInfo evaluateAnnotation(AnnoInfo info) {
        LinkedHashMap<String, Type> template = new LinkedHashMap<String, Type>();
        TypeBoundClass annoClass = this.env.get(info.sym());
        if (annoClass != null) {
            for (TypeBoundClass.MethodInfo method : annoClass.methods()) {
                template.put(method.name(), method.returnType());
            }
        }
        LinkedHashMap<String, Const> values = new LinkedHashMap<String, Const>();
        for (Tree.Expression arg : info.args()) {
            Tree.Expression expr;
            String key;
            if (arg.kind() == Tree.Kind.ASSIGN) {
                Tree.Assign assign = (Tree.Assign)arg;
                key = assign.name().value();
                expr = assign.expr();
            } else {
                key = "value";
                expr = arg;
            }
            Type ty = (Type)template.get(key);
            if (ty == null) {
                throw this.error(arg.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, String.format("element %s() in %s", key, info.sym()));
            }
            Const value = this.evalAnnotationValue(expr, ty);
            if (value == null) {
                throw this.error(expr.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
            }
            Const existing = values.put(key, value);
            if (existing == null) continue;
            throw this.error(arg.position(), TurbineError.ErrorKind.INVALID_ANNOTATION_ARGUMENT, new Object[0]);
        }
        return info.withValues((ImmutableMap<String, Const>)ImmutableMap.copyOf(values));
    }

    private TurbineAnnotationValue evalAnno(Tree.Anno t) {
        LookupResult result = this.scope.lookup(new LookupKey(t.name()));
        if (result == null) {
            throw this.error(((Tree.Ident)t.name().get(0)).position(), TurbineError.ErrorKind.CANNOT_RESOLVE, Joiner.on((String)".").join(t.name()));
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (Tree.Ident name : result.remaining()) {
            if ((sym = Resolve.resolve(this.env, sym, sym, name)) != null) continue;
            throw this.error(name.position(), TurbineError.ErrorKind.CANNOT_RESOLVE, name.value());
        }
        if (sym == null) {
            return null;
        }
        AnnoInfo annoInfo = this.evaluateAnnotation(new AnnoInfo(this.source, sym, t, null));
        return new TurbineAnnotationValue(annoInfo);
    }

    private Const.ArrayInitValue evalArrayInit(Tree.ArrayInit t) {
        ImmutableList.Builder elements = ImmutableList.builder();
        for (Tree.Expression e : t.exprs()) {
            Const arg = this.eval(e);
            if (arg == null) {
                return null;
            }
            elements.add((Object)arg);
        }
        return new Const.ArrayInitValue((ImmutableList<Const>)elements.build());
    }

    Const evalAnnotationValue(Tree tree, Type ty) {
        if (ty == null) {
            throw this.error(tree.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
        }
        Const value = this.eval(tree);
        if (value == null) {
            throw this.error(tree.position(), TurbineError.ErrorKind.EXPRESSION_ERROR, new Object[0]);
        }
        switch (ty.tyKind()) {
            case PRIM_TY: {
                return ConstEvaluator.coerce((Const.Value)value, ((Type.PrimTy)ty).primkind());
            }
            case CLASS_TY: 
            case TY_VAR: {
                return value;
            }
            case ARRAY_TY: {
                Type elementType = ((Type.ArrayTy)ty).elementType();
                ImmutableList<Const> elements = value.kind() == Const.Kind.ARRAY ? ((Const.ArrayInitValue)value).elements() : ImmutableList.of((Object)value);
                ImmutableList.Builder coerced = ImmutableList.builder();
                for (Const element : elements) {
                    coerced.add((Object)ConstEvaluator.cast(elementType, element));
                }
                return new Const.ArrayInitValue((ImmutableList<Const>)coerced.build());
            }
        }
        throw new AssertionError((Object)ty.tyKind());
    }

    private TurbineError error(int position, TurbineError.ErrorKind kind, Object ... args) {
        return TurbineError.format(this.source, position, kind, args);
    }

    public Const.Value evalFieldInitializer(Tree.Expression expression, Type type) {
        try {
            Const value = this.eval(expression);
            if (value == null || value.kind() != Const.Kind.PRIMITIVE) {
                return null;
            }
            return (Const.Value)ConstEvaluator.cast(type, value);
        }
        catch (TurbineError | Const.ConstCastError error) {
            return null;
        }
    }
}

