/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.nio.tcp;

import com.hazelcast.logging.ILogger;
import com.hazelcast.nio.Address;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.ConnectionType;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.nio.tcp.IOThreadingModel;
import com.hazelcast.nio.tcp.SocketChannelWrapper;
import com.hazelcast.nio.tcp.SocketReader;
import com.hazelcast.nio.tcp.SocketWriter;
import com.hazelcast.nio.tcp.TcpIpConnectionManager;
import com.hazelcast.nio.tcp.TcpIpConnectionMonitor;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.util.concurrent.atomic.AtomicBoolean;

public final class TcpIpConnection
implements Connection {
    private final SocketChannelWrapper socketChannel;
    private final SocketReader socketReader;
    private final SocketWriter socketWriter;
    private final TcpIpConnectionManager connectionManager;
    private final AtomicBoolean alive = new AtomicBoolean(true);
    private final ILogger logger;
    private final int connectionId;
    private Address endPoint;
    private TcpIpConnectionMonitor monitor;
    private volatile ConnectionType type = ConnectionType.NONE;

    public TcpIpConnection(TcpIpConnectionManager connectionManager, int connectionId, SocketChannelWrapper socketChannel, IOThreadingModel ioThreadingModel) {
        this.connectionId = connectionId;
        this.logger = connectionManager.getIoService().getLogger(TcpIpConnection.class.getName());
        this.connectionManager = connectionManager;
        this.socketChannel = socketChannel;
        this.socketWriter = ioThreadingModel.newSocketWriter(this);
        this.socketReader = ioThreadingModel.newSocketReader(this);
    }

    public SocketReader getSocketReader() {
        return this.socketReader;
    }

    public SocketWriter getSocketWriter() {
        return this.socketWriter;
    }

    @Override
    public ConnectionType getType() {
        return this.type;
    }

    @Override
    public void setType(ConnectionType type) {
        if (this.type == ConnectionType.NONE) {
            this.type = type;
        }
    }

    public TcpIpConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public SocketChannelWrapper getSocketChannelWrapper() {
        return this.socketChannel;
    }

    @Override
    public InetAddress getInetAddress() {
        return this.socketChannel.socket().getInetAddress();
    }

    @Override
    public int getPort() {
        return this.socketChannel.socket().getPort();
    }

    @Override
    public InetSocketAddress getRemoteSocketAddress() {
        return (InetSocketAddress)this.socketChannel.socket().getRemoteSocketAddress();
    }

    @Override
    public boolean isAlive() {
        return this.alive.get();
    }

    @Override
    public long lastWriteTimeMillis() {
        return this.socketWriter.getLastWriteTimeMillis();
    }

    @Override
    public long lastReadTimeMillis() {
        return this.socketReader.getLastReadTimeMillis();
    }

    @Override
    public Address getEndPoint() {
        return this.endPoint;
    }

    public void setEndPoint(Address endPoint) {
        this.endPoint = endPoint;
    }

    public void setMonitor(TcpIpConnectionMonitor monitor) {
        this.monitor = monitor;
    }

    public TcpIpConnectionMonitor getMonitor() {
        return this.monitor;
    }

    public int getConnectionId() {
        return this.connectionId;
    }

    Object getConnectionAddress() {
        return this.endPoint == null ? this.socketChannel.socket().getRemoteSocketAddress() : this.endPoint;
    }

    public Object getMetricsId() {
        Socket socket = this.socketChannel.socket();
        SocketAddress localSocketAddress = socket != null ? socket.getLocalSocketAddress() : null;
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return (Object)((Object)this.getType()) + "#" + localSocketAddress + "->" + remoteSocketAddress;
    }

    public void setSendBufferSize(int size) throws SocketException {
        this.socketChannel.socket().setSendBufferSize(size);
    }

    public void setReceiveBufferSize(int size) throws SocketException {
        this.socketChannel.socket().setReceiveBufferSize(size);
    }

    @Override
    public boolean isClient() {
        ConnectionType t = this.type;
        return t != null && t != ConnectionType.NONE && t.isClient();
    }

    public void start() {
        this.socketWriter.start();
        this.socketReader.init();
    }

    @Override
    public boolean write(OutboundFrame frame) {
        if (!this.alive.get()) {
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Connection is closed, won't write packet -> " + frame);
            }
            return false;
        }
        this.socketWriter.offer(frame);
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof TcpIpConnection)) {
            return false;
        }
        TcpIpConnection that = (TcpIpConnection)o;
        return this.connectionId == that.getConnectionId();
    }

    public int hashCode() {
        return this.connectionId;
    }

    @Override
    public void close() {
        this.close(null);
    }

    public void close(Throwable t) {
        if (!this.alive.compareAndSet(true, false)) {
            return;
        }
        try {
            if (this.socketChannel != null && this.socketChannel.isOpen()) {
                this.socketReader.destroy();
                this.socketWriter.shutdown();
                this.socketChannel.close();
            }
        }
        catch (Exception e) {
            this.logger.warning(e);
        }
        Object connAddress = this.getConnectionAddress();
        String message = "Connection [" + connAddress + "] lost. Reason: ";
        message = t == null ? message + "Socket explicitly closed" : message + t.getClass().getName() + "[" + t.getMessage() + "]";
        this.logger.info(message);
        this.connectionManager.destroyConnection(this);
        this.connectionManager.getIoService().onDisconnect(this.endPoint);
        if (t != null && this.monitor != null) {
            this.monitor.onError(t);
        }
    }

    public String toString() {
        Socket socket = this.socketChannel.socket();
        SocketAddress localSocketAddress = socket != null ? socket.getLocalSocketAddress() : null;
        SocketAddress remoteSocketAddress = socket != null ? socket.getRemoteSocketAddress() : null;
        return "Connection [" + localSocketAddress + " -> " + remoteSocketAddress + "], endpoint=" + this.endPoint + ", alive=" + this.alive + ", type=" + (Object)((Object)this.type);
    }
}

