/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import java.lang.annotation.Annotation;

@BugPattern(name="GetClassOnAnnotation", category=BugPattern.Category.JDK, summary="Calling getClass() on an annotation may return a proxy class", severity=BugPattern.SeverityLevel.ERROR)
public class GetClassOnAnnotation
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> ANNOTATION_CLASS = MethodMatchers.instanceMethod().onDescendantOf(Annotation.class.getName()).named("getClass").withParameters(new String[0]);

    public Description matchMethodInvocation(MethodInvocationTree tree, VisitorState state) {
        if (ANNOTATION_CLASS.matches((Tree)tree, state)) {
            return this.describeMatch(tree, (Fix)SuggestedFix.replace((int)state.getEndPosition((Tree)ASTHelpers.getReceiver((ExpressionTree)tree)), (int)state.getEndPosition((Tree)tree), (String)".annotationType()"));
        }
        return Description.NO_MATCH;
    }
}

