/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Predicate;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.suppliers.Supplier;
import com.google.errorprone.suppliers.Suppliers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Signatures;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Set;

@BugPattern(name="EqualsIncompatibleType", summary="An equality test between objects with incompatible types always returns false", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class EqualsIncompatibleType
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<MethodInvocationTree> STATIC_EQUALS_INVOCATION_MATCHER = Matchers.anyOf((Matcher[])new Matcher[]{Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("java.util.Objects").named("equals").withParameters(new String[]{"java.lang.Object", "java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)}), Matchers.allOf((Matcher[])new Matcher[]{Matchers.staticMethod().onClass("com.google.common.base.Objects").named("equal").withParameters(new String[]{"java.lang.Object", "java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)})});
    private static final Matcher<MethodInvocationTree> INSTANCE_EQUALS_INVOCATION_MATCHER = Matchers.allOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("equals").withParameters(new String[]{"java.lang.Object"}), Matchers.isSameType((Supplier)Suppliers.BOOLEAN_TYPE)});
    private static final Matcher<Tree> ASSERT_FALSE_MATCHER = Matchers.toType(MethodInvocationTree.class, (Matcher)Matchers.anyOf((Matcher[])new Matcher[]{Matchers.instanceMethod().anyClass().named("assertFalse"), Matchers.staticMethod().anyClass().named("assertFalse")}));

    public Description matchMethodInvocation(MethodInvocationTree invocationTree, VisitorState state) {
        Type argumentType;
        Type receiverType;
        if (!STATIC_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state) && !INSTANCE_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state)) {
            return Description.NO_MATCH;
        }
        if (STATIC_EQUALS_INVOCATION_MATCHER.matches((Tree)invocationTree, state)) {
            receiverType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(1));
        } else {
            receiverType = ASTHelpers.getReceiverType((ExpressionTree)invocationTree);
            argumentType = ASTHelpers.getType((Tree)invocationTree.getArguments().get(0));
        }
        if (!EqualsIncompatibleType.incompatibleTypes(receiverType, argumentType, state)) {
            return Description.NO_MATCH;
        }
        if (ASSERT_FALSE_MATCHER.matches(state.getPath().getParentPath().getLeaf(), state)) {
            return Description.NO_MATCH;
        }
        return this.buildDescription(invocationTree).setMessage(EqualsIncompatibleType.getMessage(invocationTree, receiverType, argumentType)).build();
    }

    static boolean incompatibleTypes(Type receiverType, Type argumentType, final VisitorState state) {
        if (receiverType == null || argumentType == null) {
            return false;
        }
        if (ASTHelpers.isCastable((Type)argumentType, (Type)receiverType, (VisitorState)state)) {
            return false;
        }
        final Types types = state.getTypes();
        Predicate<Symbol.MethodSymbol> equalsPredicate = new Predicate<Symbol.MethodSymbol>(){

            public boolean apply(Symbol.MethodSymbol methodSymbol) {
                return !methodSymbol.isStatic() && (methodSymbol.flags() & 0x1000L) == 0L && types.isSameType(methodSymbol.getReturnType(), state.getSymtab().booleanType) && ((List)methodSymbol.getParameters()).size() == 1 && types.isSameType(((Symbol.VarSymbol)((List)methodSymbol.getParameters()).get((int)0)).type, state.getSymtab().objectType);
            }
        };
        Name equalsName = state.getName("equals");
        Set overridesOfEquals = ASTHelpers.findMatchingMethods((Name)equalsName, (Predicate)equalsPredicate, (Type)receiverType, (Types)types);
        Symbol.ClassSymbol argumentClass = (Symbol.ClassSymbol)argumentType.tsym;
        for (Symbol.MethodSymbol method : overridesOfEquals) {
            Symbol.ClassSymbol methodClass = method.enclClass();
            if (!argumentClass.isSubClass(methodClass, types) || methodClass.equals(state.getSymtab().objectType.tsym) || methodClass.equals(state.getSymtab().enumSym)) continue;
            return false;
        }
        return true;
    }

    private static String getMessage(MethodInvocationTree invocationTree, Type receiverType, Type argumentType) {
        String receiverTypeString = Signatures.prettyType((Type)receiverType);
        String argumentTypeString = Signatures.prettyType((Type)argumentType);
        if (argumentTypeString.equals(receiverTypeString)) {
            receiverTypeString = receiverType.toString();
            argumentTypeString = argumentType.toString();
        }
        return "Calling " + ASTHelpers.getSymbol((MethodInvocationTree)invocationTree).getSimpleName() + " on incompatible types " + receiverTypeString + " and " + argumentTypeString;
    }
}

