/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.Matchers;
import com.google.errorprone.util.ASTHelpers;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.util.List;

@BugPattern(name="CollectionToArraySafeParameter", summary="The type of the array parameter of Collection.toArray needs to be compatible with the array type", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.WARNING)
public class CollectionToArraySafeParameter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> TO_ARRAY_MATCHER = Matchers.instanceMethod().onDescendantOf("java.util.Collection").withSignature("<T>toArray(T[])");

    public Description matchMethodInvocation(MethodInvocationTree methodInvocationTree, VisitorState visitorState) {
        if (TO_ARRAY_MATCHER.matches((Tree)methodInvocationTree, visitorState)) {
            Type.ArrayType firstArgType = (Type.ArrayType)ASTHelpers.getType((Tree)methodInvocationTree.getArguments().get(0));
            Type variableType = firstArgType.getComponentType();
            Type.ClassType classTypeSub = (Type.ClassType)ASTHelpers.getReceiverType((ExpressionTree)methodInvocationTree);
            Types types = visitorState.getTypes();
            Type classType = types.asSuper(classTypeSub, visitorState.getSymbolFromString("java.util.Collection"));
            List<Type> typeArguments = classType.getTypeArguments();
            if (!typeArguments.isEmpty() && !types.isCastable(types.erasure(variableType), types.erasure((Type)typeArguments.get(0)))) {
                return this.describeMatch(methodInvocationTree);
            }
        }
        return Description.NO_MATCH;
    }
}

