/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.turbine.binder.bound.BoundClass;
import com.google.turbine.binder.bound.HeaderBoundClass;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.LazyEnv;
import com.google.turbine.binder.lookup.CanonicalSymbolResolver;
import com.google.turbine.binder.lookup.ImportScope;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.model.TurbineVisibility;
import java.util.Objects;

public class Resolve {
    public static ClassSymbol resolve(Env<ClassSymbol, ? extends HeaderBoundClass> env, ClassSymbol origin, ClassSymbol sym, String simpleName) {
        HeaderBoundClass bound = env.get(sym);
        if (bound == null) {
            return null;
        }
        ClassSymbol result = (ClassSymbol)bound.children().get((Object)simpleName);
        if (result != null) {
            return result;
        }
        if (bound.superclass() != null && (result = Resolve.resolve(env, origin, bound.superclass(), simpleName)) != null && Resolve.visible(origin, result, env.get(result))) {
            return result;
        }
        for (ClassSymbol i : bound.interfaces()) {
            result = Resolve.resolve(env, origin, i, simpleName);
            if (result == null || !Resolve.visible(origin, result, env.get(result))) continue;
            return result;
        }
        return null;
    }

    public static ImportScope.ResolveFunction resolveFunction(final Env<ClassSymbol, ? extends HeaderBoundClass> env, final ClassSymbol origin) {
        return new ImportScope.ResolveFunction(){

            @Override
            public ClassSymbol resolveOne(ClassSymbol base, String name) {
                try {
                    return Resolve.resolve(env, origin, base, name);
                }
                catch (LazyEnv.LazyBindingError e) {
                    return null;
                }
            }
        };
    }

    public static TypeBoundClass.FieldInfo resolveField(Env<ClassSymbol, TypeBoundClass> env, ClassSymbol origin, ClassSymbol sym, String name) {
        TypeBoundClass.FieldInfo field;
        TypeBoundClass info = env.get(sym);
        if (info == null) {
            return null;
        }
        for (TypeBoundClass.FieldInfo f : info.fields()) {
            if (!f.name().equals(name)) continue;
            return f;
        }
        if (info.superclass() != null && (field = Resolve.resolveField(env, origin, info.superclass(), name)) != null && Resolve.visible(origin, field)) {
            return field;
        }
        for (ClassSymbol i : info.interfaces()) {
            TypeBoundClass.FieldInfo field2 = Resolve.resolveField(env, origin, i, name);
            if (field2 == null || !Resolve.visible(origin, field2)) continue;
            return field2;
        }
        return null;
    }

    private static boolean visible(ClassSymbol origin, TypeBoundClass.FieldInfo info) {
        return Resolve.visible(origin, info.sym().owner(), info.access());
    }

    private static boolean visible(ClassSymbol origin, ClassSymbol sym, HeaderBoundClass info) {
        return Resolve.visible(origin, sym, info.access());
    }

    private static boolean visible(ClassSymbol origin, ClassSymbol owner, int access) {
        TurbineVisibility visibility = TurbineVisibility.fromAccess(access);
        switch (visibility) {
            case PUBLIC: 
            case PROTECTED: {
                return true;
            }
            case PACKAGE: {
                return Objects.equals(Resolve.packageName(owner), Resolve.packageName(origin));
            }
            case PRIVATE: {
                return owner.equals(origin);
            }
        }
        throw new AssertionError((Object)visibility);
    }

    private static String packageName(ClassSymbol sym) {
        if (sym == null) {
            return null;
        }
        int idx = sym.binaryName().lastIndexOf(47);
        if (idx == -1) {
            return null;
        }
        return sym.binaryName().substring(0, idx);
    }

    static class CanonicalResolver
    implements CanonicalSymbolResolver {
        private final String packagename;
        private final CompoundEnv<ClassSymbol, BoundClass> env;

        public CanonicalResolver(ImmutableList<String> packagename, CompoundEnv<ClassSymbol, BoundClass> env) {
            this.packagename = Joiner.on((char)'/').join(packagename);
            this.env = env;
        }

        @Override
        public ClassSymbol resolve(LookupResult result) {
            ClassSymbol sym = (ClassSymbol)result.sym();
            for (String bit : result.remaining()) {
                if ((sym = this.resolveOne(sym, bit)) != null) continue;
                return null;
            }
            return sym;
        }

        @Override
        public ClassSymbol resolveOne(ClassSymbol sym, String bit) {
            BoundClass ci = this.env.get(sym);
            if (ci == null) {
                return null;
            }
            sym = (ClassSymbol)ci.children().get((Object)bit);
            if (sym == null) {
                return null;
            }
            if (!this.visible(sym)) {
                return null;
            }
            return sym;
        }

        @Override
        public boolean visible(ClassSymbol sym) {
            TurbineVisibility visibility = TurbineVisibility.fromAccess(this.env.get(sym).access());
            switch (visibility) {
                case PUBLIC: {
                    return true;
                }
                case PROTECTED: 
                case PACKAGE: {
                    return Objects.equals(Resolve.packageName(sym), this.packagename);
                }
                case PRIVATE: {
                    return false;
                }
            }
            throw new AssertionError((Object)visibility);
        }
    }
}

