/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.comp;

import com.sun.tools.javac.code.AnnoConstruct;
import com.sun.tools.javac.code.Lint;
import com.sun.tools.javac.code.Source;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Check;
import com.sun.tools.javac.comp.DeferredAttr;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.comp.Resolve;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.GraphUtils;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Name;
import com.sun.tools.javac.util.Options;
import com.sun.tools.javac.util.Pair;
import com.sun.tools.javac.util.Warner;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class Infer {
    protected static final Context.Key<Infer> inferKey = new Context.Key();
    Resolve rs;
    Check chk;
    Symtab syms;
    Types types;
    JCDiagnostic.Factory diags;
    Log log;
    boolean allowGraphInference;
    private final String dependenciesFolder;
    private List<String> pendingGraphs;
    public static final Type anyPoly = new Type.JCNoType();
    protected final InferenceException inferenceException;
    static final int MAX_INCORPORATION_STEPS = 100;
    EnumSet<IncorporationStep> incorporationStepsLegacy = EnumSet.of(IncorporationStep.EQ_CHECK_LEGACY);
    EnumSet<IncorporationStep> incorporationStepsGraph = EnumSet.complementOf(EnumSet.of(IncorporationStep.EQ_CHECK_LEGACY));
    Map<IncorporationBinaryOp, Boolean> incorporationCache = new HashMap<IncorporationBinaryOp, Boolean>();
    final InferenceContext emptyContext = new InferenceContext(List.nil());

    public static Infer instance(Context context) {
        Infer infer = context.get(inferKey);
        if (infer == null) {
            infer = new Infer(context);
        }
        return infer;
    }

    protected Infer(Context context) {
        context.put(inferKey, this);
        this.rs = Resolve.instance(context);
        this.chk = Check.instance(context);
        this.syms = Symtab.instance(context);
        this.types = Types.instance(context);
        this.diags = JCDiagnostic.Factory.instance(context);
        this.log = Log.instance(context);
        this.inferenceException = new InferenceException(this.diags);
        Options options = Options.instance(context);
        this.allowGraphInference = Source.instance(context).allowGraphInference() && options.isUnset("useLegacyInference");
        this.dependenciesFolder = options.get("dumpInferenceGraphsTo");
        this.pendingGraphs = List.nil();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Type instantiateMethod(Env<AttrContext> env, List<Type> list, Type.MethodType methodType, Attr.ResultInfo resultInfo, Symbol.MethodSymbol methodSymbol, List<Type> list2, boolean bl, boolean bl2, Resolve.MethodResolutionContext methodResolutionContext, Warner warner) throws InferenceException {
        InferenceContext inferenceContext = new InferenceContext(list);
        this.inferenceException.clear();
        try {
            Type type;
            DeferredAttr.DeferredAttrContext deferredAttrContext = methodResolutionContext.deferredAttrContext(methodSymbol, inferenceContext, resultInfo, warner);
            methodResolutionContext.methodCheck.argumentsAcceptable(env, deferredAttrContext, list2, (List<Type>)methodType.getParameterTypes(), warner);
            if (this.allowGraphInference && resultInfo != null && !warner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.checkWithinBounds(inferenceContext, warner);
                type = this.generateReturnConstraints(env.tree, resultInfo, methodType, inferenceContext);
                methodType = (Type.MethodType)this.types.createMethodTypeWithReturn(methodType, type);
                if (resultInfo.checkContext.inferenceContext().free(resultInfo.pt)) {
                    inferenceContext.dupTo(resultInfo.checkContext.inferenceContext());
                    deferredAttrContext.complete();
                    Type.MethodType methodType2 = methodType;
                    return methodType2;
                }
            }
            deferredAttrContext.complete();
            if (this.allowGraphInference) {
                inferenceContext.solve(warner);
            } else {
                inferenceContext.solveLegacy(true, warner, LegacyInferenceSteps.EQ_LOWER.steps);
            }
            methodType = (Type.MethodType)inferenceContext.asInstType(methodType);
            if (!this.allowGraphInference && inferenceContext.restvars().nonEmpty() && resultInfo != null && !warner.hasNonSilentLint(Lint.LintCategory.UNCHECKED)) {
                this.generateReturnConstraints(env.tree, resultInfo, methodType, inferenceContext);
                inferenceContext.solveLegacy(false, warner, LegacyInferenceSteps.EQ_UPPER.steps);
                methodType = (Type.MethodType)inferenceContext.asInstType(methodType);
            }
            if (resultInfo != null && this.rs.verboseResolutionMode.contains((Object)Resolve.VerboseResolutionMode.DEFERRED_INST)) {
                this.log.note(env.tree.pos, "deferred.method.inst", methodSymbol, methodType, resultInfo.pt);
            }
            type = methodType;
            return type;
        }
        finally {
            if (resultInfo != null || !this.allowGraphInference) {
                inferenceContext.notifyChange();
            } else {
                inferenceContext.notifyChange(inferenceContext.boundedVars());
            }
            if (resultInfo == null) {
                inferenceContext.captureTypeCache.clear();
            }
            this.dumpGraphsIfNeeded(env.tree, methodSymbol, methodResolutionContext);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dumpGraphsIfNeeded(JCDiagnostic.DiagnosticPosition diagnosticPosition, Symbol symbol, Resolve.MethodResolutionContext methodResolutionContext) {
        int n = 0;
        try {
            for (String string : this.pendingGraphs.reverse()) {
                Assert.checkNonNull(this.dependenciesFolder);
                Name name = symbol.name == symbol.name.table.names.init ? symbol.owner.name : symbol.name;
                String string2 = String.format("%s@%s[mode=%s,step=%s]_%d.dot", new Object[]{name, diagnosticPosition.getStartPosition(), methodResolutionContext.attrMode(), methodResolutionContext.step, n});
                File file = new File(this.dependenciesFolder, string2);
                try (FileWriter fileWriter = new FileWriter(file);){
                    fileWriter.append(string);
                }
                ++n;
            }
        }
        catch (IOException iOException) {
            Assert.error("Error occurred when dumping inference graph: " + iOException.getMessage());
        }
        finally {
            this.pendingGraphs = List.nil();
        }
    }

    Type generateReturnConstraints(JCTree jCTree, Attr.ResultInfo resultInfo, Type.MethodType methodType, InferenceContext inferenceContext) {
        Type type3;
        InferenceContext inferenceContext2 = resultInfo.checkContext.inferenceContext();
        Type type2 = methodType.getReturnType();
        if (methodType.getReturnType().containsAny(inferenceContext.inferencevars) && inferenceContext2 != this.emptyContext) {
            type2 = this.types.capture(type2);
            for (Type type3 : type2.getTypeArguments()) {
                if (!type3.hasTag(TypeTag.TYPEVAR) || !((Type.TypeVar)type3).isCaptured()) continue;
                inferenceContext.addVar((Type.TypeVar)type3);
            }
        }
        Type type4 = inferenceContext.asUndetVar(type2);
        type3 = resultInfo.pt;
        if (type4.hasTag(TypeTag.VOID)) {
            type3 = this.syms.voidType;
        } else if (type3.hasTag(TypeTag.NONE)) {
            type3 = type2.isPrimitive() ? type2 : this.syms.objectType;
        } else if (type4.hasTag(TypeTag.UNDETVAR)) {
            if (resultInfo.pt.isReference()) {
                type3 = this.generateReturnConstraintsUndetVarToReference(jCTree, (Type.UndetVar)type4, type3, resultInfo, inferenceContext);
            } else if (type3.isPrimitive()) {
                type3 = this.generateReturnConstraintsPrimitive(jCTree, (Type.UndetVar)type4, type3, resultInfo, inferenceContext);
            }
        }
        Assert.check(this.allowGraphInference || !inferenceContext2.free(type3), "legacy inference engine cannot handle constraints on both sides of a subtyping assertion");
        Warner warner = new Warner();
        if (!resultInfo.checkContext.compatible(type4, inferenceContext2.asUndetVar(type3), warner) || !this.allowGraphInference && warner.hasLint(Lint.LintCategory.UNCHECKED)) {
            throw this.inferenceException.setMessage("infer.no.conforming.instance.exists", inferenceContext.restvars(), methodType.getReturnType(), type3);
        }
        return type2;
    }

    private Type generateReturnConstraintsPrimitive(JCTree jCTree, Type.UndetVar undetVar, Type type, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        if (!this.allowGraphInference) {
            return this.types.boxedClass((Type)type).type;
        }
        for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER)) {
            Type type3 = this.types.unboxedType(type2);
            if (type3 == null || type3.hasTag(TypeTag.NONE)) continue;
            return this.generateReferenceToTargetConstraint(jCTree, undetVar, type, resultInfo, inferenceContext);
        }
        return this.types.boxedClass((Type)type).type;
    }

    private Type generateReturnConstraintsUndetVarToReference(JCTree jCTree, Type.UndetVar undetVar, Type type, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        Object object;
        Type type2 = this.types.capture(type);
        if (type2 == type) {
            for (Type type3 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                object = this.types.capture(type3);
                if (object == type3) continue;
                return this.generateReferenceToTargetConstraint(jCTree, undetVar, type, resultInfo, inferenceContext);
            }
            for (Type type3 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                for (Type type4 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    if (type3 == type4 || inferenceContext.free(type3) || inferenceContext.free(type4) || !this.commonSuperWithDiffParameterization(type3, type4)) continue;
                    return this.generateReferenceToTargetConstraint(jCTree, undetVar, type, resultInfo, inferenceContext);
                }
            }
        }
        if (type.isParameterized()) {
            for (Type type3 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)) {
                object = this.types.asSuper(type3, type.tsym);
                if (object == null || !((Type)object).isRaw()) continue;
                return this.generateReferenceToTargetConstraint(jCTree, undetVar, type, resultInfo, inferenceContext);
            }
        }
        return type;
    }

    private boolean commonSuperWithDiffParameterization(Type type, Type type2) {
        for (Pair<Type, Type> pair : this.getParameterizedSupers(type, type2)) {
            if (this.types.isSameType((Type)pair.fst, (Type)pair.snd)) continue;
            return true;
        }
        return false;
    }

    private Type generateReferenceToTargetConstraint(JCTree jCTree, Type.UndetVar undetVar, Type type, Attr.ResultInfo resultInfo, InferenceContext inferenceContext) {
        inferenceContext.solve(List.of(undetVar.qtype), new Warner());
        inferenceContext.notifyChange();
        Type type2 = resultInfo.checkContext.inferenceContext().cachedCapture(jCTree, undetVar.inst, false);
        if (this.types.isConvertible(type2, resultInfo.checkContext.inferenceContext().asUndetVar(type))) {
            return this.syms.objectType;
        }
        return type;
    }

    private void instantiateAsUninferredVars(List<Type> list, InferenceContext inferenceContext) {
        AnnoConstruct annoConstruct;
        List<Type> list2;
        ListBuffer<Type> listBuffer = new ListBuffer<Type>();
        for (Type object : list) {
            Type type = (Type.UndetVar)inferenceContext.asUndetVar(object);
            list2 = ((Type.UndetVar)type).getBounds(Type.UndetVar.InferenceBound.UPPER);
            if (Type.containsAny(list2, list)) {
                annoConstruct = new Symbol.TypeVariableSymbol(4096L, ((Type.UndetVar)type).qtype.tsym.name, null, ((Type.UndetVar)type).qtype.tsym.owner);
                ((Symbol.TypeSymbol)annoConstruct).type = new Type.TypeVar((Symbol.TypeSymbol)annoConstruct, this.types.makeCompoundType(((Type.UndetVar)type).getBounds(Type.UndetVar.InferenceBound.UPPER)), null, Type.noAnnotations);
                listBuffer.append(type);
                ((Type.UndetVar)type).inst = ((Symbol.TypeSymbol)annoConstruct).type;
                continue;
            }
            if (list2.nonEmpty()) {
                ((Type.UndetVar)type).inst = this.types.glb(list2);
                continue;
            }
            ((Type.UndetVar)type).inst = this.syms.objectType;
        }
        List list3 = list;
        for (Type type : listBuffer) {
            list2 = type;
            annoConstruct = (Type.TypeVar)((Type.UndetVar)((Object)list2)).inst;
            annoConstruct.bound = this.types.glb(inferenceContext.asInstTypes(this.types.getBounds((Type.TypeVar)annoConstruct)));
            if (annoConstruct.bound.isErroneous()) {
                this.reportBoundError((Type.UndetVar)((Object)list2), BoundErrorKind.BAD_UPPER);
            }
            list3 = list3.tail;
        }
    }

    Type instantiatePolymorphicSignatureInstance(Env<AttrContext> env, Symbol.MethodSymbol methodSymbol, Resolve.MethodResolutionContext methodResolutionContext, List<Type> list) {
        Object object;
        Type type;
        Object object2;
        switch (env.next.tree.getTag()) {
            case TYPECAST: {
                object2 = (JCTree.JCTypeCast)env.next.tree;
                type = TreeInfo.skipParens(((JCTree.JCTypeCast)object2).expr) == env.tree ? ((JCTree.JCTypeCast)object2).clazz.type : this.syms.objectType;
                break;
            }
            case EXEC: {
                object = (JCTree.JCExpressionStatement)env.next.tree;
                type = TreeInfo.skipParens(((JCTree.JCExpressionStatement)object).expr) == env.tree ? this.syms.voidType : this.syms.objectType;
                break;
            }
            default: {
                type = this.syms.objectType;
            }
        }
        object2 = Type.map(list, new ImplicitArgType(methodSymbol, methodResolutionContext.step));
        object = methodSymbol != null ? methodSymbol.getThrownTypes() : List.of(this.syms.throwableType);
        Type.MethodType methodType = new Type.MethodType((List<Type>)object2, type, (List<Type>)object, this.syms.methodClass);
        return methodType;
    }

    public Type instantiateFunctionalInterface(JCDiagnostic.DiagnosticPosition diagnosticPosition, Type type, List<Type> list, Check.CheckContext checkContext) {
        if (this.types.capture(type) == type) {
            return type;
        }
        Type type2 = type.tsym.type;
        InferenceContext inferenceContext = new InferenceContext(type.tsym.type.getTypeArguments());
        Assert.check(list != null);
        List<Type> list2 = this.types.findDescriptorType(type2).getParameterTypes();
        if (list2.size() != list.size()) {
            checkContext.report(diagnosticPosition, this.diags.fragment("incompatible.arg.types.in.lambda", new Object[0]));
            return this.types.createErrorType(type);
        }
        for (Type object2 : list2) {
            if (!this.types.isSameType(inferenceContext.asUndetVar(object2), (Type)list.head)) {
                checkContext.report(diagnosticPosition, this.diags.fragment("no.suitable.functional.intf.inst", type));
                return this.types.createErrorType(type);
            }
            list = list.tail;
        }
        try {
            inferenceContext.solve(inferenceContext.boundedVars(), this.types.noWarnings);
        }
        catch (InferenceException inferenceException) {
            checkContext.report(diagnosticPosition, this.diags.fragment("no.suitable.functional.intf.inst", type));
        }
        List list3 = type.getTypeArguments();
        for (Type type3 : inferenceContext.undetvars) {
            Type.UndetVar undetVar = (Type.UndetVar)type3;
            if (undetVar.inst == null) {
                undetVar.inst = (Type)list3.head;
            }
            list3 = list3.tail;
        }
        Type type4 = inferenceContext.asInstType(type2);
        if (!this.chk.checkValidGenericType(type4)) {
            checkContext.report(diagnosticPosition, this.diags.fragment("no.suitable.functional.intf.inst", type));
        }
        checkContext.compatible(type4, type, this.types.noWarnings);
        return type4;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void checkWithinBounds(InferenceContext inferenceContext, Warner warner) throws InferenceException {
        MultiUndetVarListener multiUndetVarListener = new MultiUndetVarListener(inferenceContext.undetvars);
        List<Type> list = inferenceContext.save();
        try {
            do {
                Type.UndetVar undetVar;
                multiUndetVarListener.reset();
                if (!this.allowGraphInference) {
                    for (Type type : inferenceContext.undetvars) {
                        undetVar = (Type.UndetVar)type;
                        IncorporationStep.CHECK_BOUNDS.apply(undetVar, inferenceContext, warner);
                    }
                }
                for (Type type : inferenceContext.undetvars) {
                    undetVar = (Type.UndetVar)type;
                    EnumSet<IncorporationStep> enumSet = this.allowGraphInference ? this.incorporationStepsGraph : this.incorporationStepsLegacy;
                    for (IncorporationStep incorporationStep : enumSet) {
                        if (!incorporationStep.accepts(undetVar, inferenceContext)) continue;
                        incorporationStep.apply(undetVar, inferenceContext, warner);
                    }
                }
            } while (multiUndetVarListener.changed && this.allowGraphInference);
        }
        finally {
            multiUndetVarListener.detach();
            if (this.incorporationCache.size() == 100) {
                inferenceContext.rollback(list);
            }
            this.incorporationCache.clear();
        }
    }

    private List<Pair<Type, Type>> getParameterizedSupers(Type type, Type type2) {
        Type type3 = this.types.lub(type, type2);
        if (type3 == this.syms.errType || type3 == this.syms.botType) {
            return List.nil();
        }
        List<Type> list = type3.isCompound() ? ((Type.IntersectionClassType)type3).getComponents() : List.of(type3);
        ListBuffer<Pair<Type, Type>> listBuffer = new ListBuffer<Pair<Type, Type>>();
        for (Type type4 : list) {
            if (!type4.isParameterized()) continue;
            Type type5 = this.types.asSuper(type, type4.tsym);
            Type type6 = this.types.asSuper(type2, type4.tsym);
            listBuffer.add(new Pair<Type, Type>(type5, type6));
        }
        return listBuffer.toList();
    }

    void checkCompatibleUpperBounds(Type.UndetVar undetVar, InferenceContext inferenceContext) {
        List<Type> list = Type.filter(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER), new BoundFilter(inferenceContext));
        Type type = null;
        type = list.isEmpty() ? this.syms.objectType : (list.tail.isEmpty() ? (Type)list.head : this.types.glb(list));
        if (type == null || type.isErroneous()) {
            this.reportBoundError(undetVar, BoundErrorKind.BAD_UPPER);
        }
    }

    void reportBoundError(Type.UndetVar undetVar, BoundErrorKind boundErrorKind) {
        throw boundErrorKind.setMessage(this.inferenceException, undetVar);
    }

    class InferenceContext {
        List<Type> undetvars;
        List<Type> inferencevars;
        Map<FreeTypeListener, List<Type>> freeTypeListeners = new HashMap<FreeTypeListener, List<Type>>();
        List<FreeTypeListener> freetypeListeners = List.nil();
        Type.Mapping fromTypeVarFun = new Type.Mapping("fromTypeVarFunWithBounds"){

            @Override
            public Type apply(Type type) {
                if (type.hasTag(TypeTag.TYPEVAR)) {
                    Type.TypeVar typeVar = (Type.TypeVar)type;
                    if (typeVar.isCaptured()) {
                        return new Type.CapturedUndetVar((Type.CapturedType)typeVar, Infer.this.types);
                    }
                    return new Type.UndetVar(typeVar, Infer.this.types);
                }
                return type.map(this);
            }
        };
        Map<JCTree, Type> captureTypeCache = new HashMap<JCTree, Type>();

        public InferenceContext(List<Type> list) {
            this.undetvars = Type.map(list, this.fromTypeVarFun);
            this.inferencevars = list;
        }

        void addVar(Type.TypeVar typeVar) {
            this.undetvars = this.undetvars.prepend(this.fromTypeVarFun.apply(typeVar));
            this.inferencevars = this.inferencevars.prepend(typeVar);
        }

        List<Type> inferenceVars() {
            return this.inferencevars;
        }

        List<Type> restvars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar undetVar) {
                    return undetVar.inst == null;
                }
            });
        }

        List<Type> instvars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar undetVar) {
                    return undetVar.inst != null;
                }
            });
        }

        final List<Type> boundedVars() {
            return this.filterVars(new Filter<Type.UndetVar>(){

                @Override
                public boolean accepts(Type.UndetVar undetVar) {
                    return undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).diff(undetVar.getDeclaredBounds()).appendList(undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER)).nonEmpty();
                }
            });
        }

        private List<Type> filterVars(Filter<Type.UndetVar> filter) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : this.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                if (!filter.accepts(undetVar)) continue;
                listBuffer.append(undetVar.qtype);
            }
            return listBuffer.toList();
        }

        final boolean free(Type type) {
            return type.containsAny(this.inferencevars);
        }

        final boolean free(List<Type> list) {
            for (Type type : list) {
                if (!this.free(type)) continue;
                return true;
            }
            return false;
        }

        final List<Type> freeVarsIn(Type type) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type2 : this.inferenceVars()) {
                if (!type.contains(type2)) continue;
                listBuffer.add(type2);
            }
            return listBuffer.toList();
        }

        final List<Type> freeVarsIn(List<Type> list) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type object : list) {
                listBuffer.appendList(this.freeVarsIn(object));
            }
            ListBuffer listBuffer2 = new ListBuffer();
            for (Type type : listBuffer) {
                if (listBuffer2.contains(type)) continue;
                listBuffer2.add(type);
            }
            return listBuffer2.toList();
        }

        final Type asUndetVar(Type type) {
            return Infer.this.types.subst(type, this.inferencevars, this.undetvars);
        }

        final List<Type> asUndetVars(List<Type> list) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : list) {
                listBuffer.append(this.asUndetVar(type));
            }
            return listBuffer.toList();
        }

        List<Type> instTypes() {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : this.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                listBuffer.append(undetVar.inst != null ? undetVar.inst : undetVar.qtype);
            }
            return listBuffer.toList();
        }

        Type asInstType(Type type) {
            return Infer.this.types.subst(type, this.inferencevars, this.instTypes());
        }

        List<Type> asInstTypes(List<Type> list) {
            ListBuffer<Type> listBuffer = new ListBuffer<Type>();
            for (Type type : list) {
                listBuffer.append(this.asInstType(type));
            }
            return listBuffer.toList();
        }

        void addFreeTypeListener(List<Type> list, FreeTypeListener freeTypeListener) {
            this.freeTypeListeners.put(freeTypeListener, this.freeVarsIn(list));
        }

        void notifyChange() {
            this.notifyChange(this.inferencevars.diff(this.restvars()));
        }

        void notifyChange(List<Type> list) {
            InferenceException inferenceException = null;
            for (Map.Entry<FreeTypeListener, List<Type>> entry : new HashMap<FreeTypeListener, List<Type>>(this.freeTypeListeners).entrySet()) {
                if (Type.containsAny(entry.getValue(), this.inferencevars.diff(list))) continue;
                try {
                    entry.getKey().typesInferred(this);
                    this.freeTypeListeners.remove(entry.getKey());
                }
                catch (InferenceException inferenceException2) {
                    if (inferenceException != null) continue;
                    inferenceException = inferenceException2;
                }
            }
            if (inferenceException != null) {
                throw inferenceException;
            }
        }

        List<Type> save() {
            ListBuffer<Type.UndetVar> listBuffer = new ListBuffer<Type.UndetVar>();
            for (Type type : this.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                Type.UndetVar undetVar2 = new Type.UndetVar((Type.TypeVar)undetVar.qtype, Infer.this.types);
                for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                    for (Type type2 : undetVar.getBounds(inferenceBound)) {
                        undetVar2.addBound(inferenceBound, type2, Infer.this.types);
                    }
                }
                undetVar2.inst = undetVar.inst;
                listBuffer.add(undetVar2);
            }
            return listBuffer.toList();
        }

        void rollback(List<Type> list) {
            Assert.check(list != null && list.length() == this.undetvars.length());
            for (Type type : this.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                Type.UndetVar undetVar2 = (Type.UndetVar)list.head;
                for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                    undetVar.setBounds(inferenceBound, undetVar2.getBounds(inferenceBound));
                }
                undetVar.inst = undetVar2.inst;
                list = list.tail;
            }
        }

        void dupTo(InferenceContext inferenceContext) {
            inferenceContext.inferencevars = inferenceContext.inferencevars.appendList(this.inferencevars.diff(inferenceContext.inferencevars));
            inferenceContext.undetvars = inferenceContext.undetvars.appendList(this.undetvars.diff(inferenceContext.undetvars));
            for (Type type : this.inferencevars) {
                inferenceContext.freeTypeListeners.put(new FreeTypeListener(){

                    @Override
                    public void typesInferred(InferenceContext inferenceContext) {
                        InferenceContext.this.notifyChange();
                    }
                }, List.of(type));
            }
        }

        private void solve(GraphStrategy graphStrategy, Warner warner) {
            this.solve(graphStrategy, new HashMap<Type, Set<Type>>(), warner);
        }

        private void solve(GraphStrategy graphStrategy, Map<Type, Set<Type>> map, Warner warner) {
            GraphSolver graphSolver = new GraphSolver(this, map, warner);
            graphSolver.solve(graphStrategy);
        }

        public void solve(Warner warner) {
            this.solve(new LeafSolver(){

                @Override
                public boolean done() {
                    return InferenceContext.this.restvars().isEmpty();
                }
            }, warner);
        }

        public void solve(final List<Type> list, Warner warner) {
            this.solve(new BestLeafSolver(list){

                @Override
                public boolean done() {
                    return !InferenceContext.this.free(InferenceContext.this.asInstTypes(list));
                }
            }, warner);
        }

        public void solveAny(List<Type> list, Map<Type, Set<Type>> map, Warner warner) {
            this.solve(new BestLeafSolver(list.intersect(this.restvars())){

                @Override
                public boolean done() {
                    return InferenceContext.this.instvars().intersect(this.varsToSolve).nonEmpty();
                }
            }, map, warner);
        }

        private boolean solveBasic(EnumSet<InferenceStep> enumSet) {
            return this.solveBasic(this.inferencevars, enumSet);
        }

        private boolean solveBasic(List<Type> list, EnumSet<InferenceStep> enumSet) {
            boolean bl = false;
            block0: for (Type type : list.intersect(this.restvars())) {
                Type.UndetVar undetVar = (Type.UndetVar)this.asUndetVar(type);
                for (InferenceStep inferenceStep : enumSet) {
                    if (!inferenceStep.accepts(undetVar, this)) continue;
                    undetVar.inst = inferenceStep.solve(undetVar, this);
                    bl = true;
                    continue block0;
                }
            }
            return bl;
        }

        public void solveLegacy(boolean bl, Warner warner, EnumSet<InferenceStep> enumSet) {
            block0: while (true) {
                boolean bl2;
                boolean bl3 = bl2 = !this.solveBasic(enumSet);
                if (this.restvars().isEmpty() || bl) break;
                if (bl2) {
                    Infer.this.instantiateAsUninferredVars(this.restvars(), this);
                    break;
                }
                Iterator<Type> iterator = this.undetvars.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Type type = iterator.next();
                    Type.UndetVar undetVar = (Type.UndetVar)type;
                    undetVar.substBounds(this.inferenceVars(), this.instTypes(), Infer.this.types);
                }
                break;
            }
            Infer.this.checkWithinBounds(this, warner);
        }

        private Infer infer() {
            return Infer.this;
        }

        public String toString() {
            return "Inference vars: " + this.inferencevars + '\n' + "Undet vars: " + this.undetvars;
        }

        Type cachedCapture(JCTree jCTree, Type type, boolean bl) {
            Type type2 = this.captureTypeCache.get(jCTree);
            if (type2 != null) {
                return type2;
            }
            Type type3 = Infer.this.types.capture(type);
            if (type3 != type && !bl) {
                this.captureTypeCache.put(jCTree, type3);
            }
            return type3;
        }
    }

    static interface FreeTypeListener {
        public void typesInferred(InferenceContext var1);
    }

    class GraphSolver {
        InferenceContext inferenceContext;
        Map<Type, Set<Type>> stuckDeps;
        Warner warn;

        GraphSolver(InferenceContext inferenceContext, Map<Type, Set<Type>> map, Warner warner) {
            this.inferenceContext = inferenceContext;
            this.stuckDeps = map;
            this.warn = warner;
        }

        void solve(GraphStrategy graphStrategy) {
            Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
            InferenceGraph inferenceGraph = new InferenceGraph(this.stuckDeps);
            while (!graphStrategy.done()) {
                if (Infer.this.dependenciesFolder != null) {
                    Infer.this.pendingGraphs = Infer.this.pendingGraphs.prepend(inferenceGraph.toDot());
                }
                InferenceGraph.Node node = graphStrategy.pickNode(inferenceGraph);
                List<Type> list = List.from((Iterable)node.data);
                List<Type> list2 = this.inferenceContext.save();
                try {
                    block3: while (Type.containsAny(this.inferenceContext.restvars(), list)) {
                        for (GraphInferenceSteps graphInferenceSteps : GraphInferenceSteps.values()) {
                            if (!this.inferenceContext.solveBasic(list, graphInferenceSteps.steps)) continue;
                            Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
                            continue block3;
                        }
                        throw Infer.this.inferenceException.setMessage();
                    }
                }
                catch (InferenceException inferenceException) {
                    this.inferenceContext.rollback(list2);
                    Infer.this.instantiateAsUninferredVars(list, this.inferenceContext);
                    Infer.this.checkWithinBounds(this.inferenceContext, this.warn);
                }
                inferenceGraph.deleteNode(node);
            }
        }

        class InferenceGraph {
            ArrayList<Node> nodes;

            InferenceGraph(Map<Type, Set<Type>> map) {
                this.initNodes(map);
            }

            public Node findNode(Type type) {
                for (Node node : this.nodes) {
                    if (!((ListBuffer)node.data).contains(type)) continue;
                    return node;
                }
                return null;
            }

            public void deleteNode(Node node) {
                Assert.check(this.nodes.contains(node));
                this.nodes.remove(node);
                this.notifyUpdate(node, null);
            }

            void notifyUpdate(Node node, Node node2) {
                for (Node node3 : this.nodes) {
                    node3.graphChanged(node, node2);
                }
            }

            void initNodes(Map<Type, Set<Type>> map) {
                Object object;
                this.nodes = new ArrayList();
                for (Type iterator : GraphSolver.this.inferenceContext.restvars()) {
                    this.nodes.add(new Node(iterator));
                }
                for (Node node : this.nodes) {
                    List<Node> list = (Type)((ListBuffer)node.data).first();
                    object = map.get(list);
                    for (Node node2 : this.nodes) {
                        Type type = (Type)((ListBuffer)node2.data).first();
                        Type.UndetVar undetVar = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar((Type)((Object)list));
                        if (Type.containsAny(undetVar.getBounds(Type.UndetVar.InferenceBound.values()), List.of(type))) {
                            node.addDependency(DependencyKind.BOUND, node2);
                        }
                        if (object == null || !object.contains(type)) continue;
                        node.addDependency(DependencyKind.STUCK, node2);
                    }
                }
                ArrayList arrayList = new ArrayList();
                for (List<Node> list : GraphUtils.tarjan(this.nodes)) {
                    if (list.length() > 1) {
                        object = (Node)list.head;
                        ((Node)object).mergeWith(list.tail);
                        for (Node node2 : list) {
                            this.notifyUpdate(node2, (Node)object);
                        }
                    }
                    arrayList.add(list.head);
                }
                this.nodes = arrayList;
            }

            String toDot() {
                StringBuilder stringBuilder = new StringBuilder();
                for (Type type : GraphSolver.this.inferenceContext.undetvars) {
                    Type.UndetVar undetVar = (Type.UndetVar)type;
                    stringBuilder.append(String.format("var %s - upper bounds = %s, lower bounds = %s, eq bounds = %s\\n", undetVar.qtype, undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER), undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER), undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)));
                }
                return GraphUtils.toDot(this.nodes, "inferenceGraph" + this.hashCode(), stringBuilder.toString());
            }

            class Node
            extends GraphUtils.TarjanNode<ListBuffer<Type>, Node>
            implements GraphUtils.DottableNode<ListBuffer<Type>, Node> {
                EnumMap<DependencyKind, Set<Node>> deps;

                Node(Type type) {
                    super(ListBuffer.of(type));
                    this.deps = new EnumMap(DependencyKind.class);
                }

                @Override
                public GraphUtils.DependencyKind[] getSupportedDependencyKinds() {
                    return DependencyKind.values();
                }

                @Override
                public Iterable<? extends Node> getAllDependencies() {
                    return this.getDependencies(DependencyKind.values());
                }

                @Override
                public Collection<? extends Node> getDependenciesByKind(GraphUtils.DependencyKind dependencyKind) {
                    return this.getDependencies((DependencyKind)dependencyKind);
                }

                protected Set<Node> getDependencies(DependencyKind ... dependencyKindArray) {
                    LinkedHashSet<Node> linkedHashSet = new LinkedHashSet<Node>();
                    for (DependencyKind dependencyKind : dependencyKindArray) {
                        Set<Node> set = this.deps.get(dependencyKind);
                        if (set == null) continue;
                        linkedHashSet.addAll(set);
                    }
                    return linkedHashSet;
                }

                protected void addDependency(DependencyKind dependencyKind, Node node) {
                    Set<Node> set = this.deps.get(dependencyKind);
                    if (set == null) {
                        set = new LinkedHashSet<Node>();
                        this.deps.put(dependencyKind, set);
                    }
                    set.add(node);
                }

                protected void addDependencies(DependencyKind dependencyKind, Set<Node> set) {
                    for (Node node : set) {
                        this.addDependency(dependencyKind, node);
                    }
                }

                protected Set<DependencyKind> removeDependency(Node node) {
                    HashSet<DependencyKind> hashSet = new HashSet<DependencyKind>();
                    for (DependencyKind dependencyKind : DependencyKind.values()) {
                        Set<Node> set = this.deps.get(dependencyKind);
                        if (set == null || !set.remove(node)) continue;
                        hashSet.add(dependencyKind);
                    }
                    return hashSet;
                }

                protected Set<Node> closure(DependencyKind ... dependencyKindArray) {
                    boolean bl = true;
                    HashSet<Node> hashSet = new HashSet<Node>();
                    hashSet.add(this);
                    while (bl) {
                        bl = false;
                        for (Node node : new HashSet<Node>(hashSet)) {
                            bl = hashSet.addAll(node.getDependencies(dependencyKindArray));
                        }
                    }
                    return hashSet;
                }

                protected boolean isLeaf() {
                    Set<Node> set = this.getDependencies(DependencyKind.BOUND, DependencyKind.STUCK);
                    if (set.isEmpty()) {
                        return true;
                    }
                    for (Node node : set) {
                        if (node == this) continue;
                        return false;
                    }
                    return true;
                }

                protected void mergeWith(List<? extends Node> list) {
                    for (Node dependencyKindArray : list) {
                        Assert.check(((ListBuffer)dependencyKindArray.data).length() == 1, "Attempt to merge a compound node!");
                        ((ListBuffer)this.data).appendList((ListBuffer)dependencyKindArray.data);
                        DependencyKind[] dependencyKindArray2 = DependencyKind.values();
                        int n = dependencyKindArray2.length;
                        for (int i = 0; i < n; ++i) {
                            DependencyKind dependencyKind = dependencyKindArray2[i];
                            this.addDependencies(dependencyKind, dependencyKindArray.getDependencies(dependencyKind));
                        }
                    }
                    EnumMap enumMap = new EnumMap(DependencyKind.class);
                    for (DependencyKind dependencyKind : DependencyKind.values()) {
                        for (Node node : this.getDependencies(dependencyKind)) {
                            LinkedHashSet<Node> linkedHashSet = (LinkedHashSet<Node>)enumMap.get(dependencyKind);
                            if (linkedHashSet == null) {
                                linkedHashSet = new LinkedHashSet<Node>();
                                enumMap.put(dependencyKind, linkedHashSet);
                            }
                            if (((ListBuffer)this.data).contains(((ListBuffer)node.data).first())) {
                                linkedHashSet.add(this);
                                continue;
                            }
                            linkedHashSet.add(node);
                        }
                    }
                    this.deps = enumMap;
                }

                private void graphChanged(Node node, Node node2) {
                    for (DependencyKind dependencyKind : this.removeDependency(node)) {
                        if (node2 == null) continue;
                        this.addDependency(dependencyKind, node2);
                    }
                }

                @Override
                public Properties nodeAttributes() {
                    Properties properties = new Properties();
                    properties.put("label", "\"" + this.toString() + "\"");
                    return properties;
                }

                @Override
                public Properties dependencyAttributes(Node node, GraphUtils.DependencyKind dependencyKind) {
                    Properties properties = new Properties();
                    properties.put("style", ((DependencyKind)dependencyKind).dotSyle);
                    if (dependencyKind == DependencyKind.STUCK) {
                        return properties;
                    }
                    StringBuilder stringBuilder = new StringBuilder();
                    String string = "";
                    for (Type type : (ListBuffer)this.data) {
                        Type.UndetVar undetVar = (Type.UndetVar)GraphSolver.this.inferenceContext.asUndetVar(type);
                        for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.values())) {
                            if (!type2.containsAny(List.from((Iterable)node.data))) continue;
                            stringBuilder.append(string);
                            stringBuilder.append(type2);
                            string = ",";
                        }
                    }
                    properties.put("label", "\"" + stringBuilder.toString() + "\"");
                    return properties;
                }
            }
        }
    }

    static enum DependencyKind implements GraphUtils.DependencyKind
    {
        BOUND("dotted"),
        STUCK("dashed");

        final String dotSyle;

        private DependencyKind(String string2) {
            this.dotSyle = string2;
        }
    }

    static enum GraphInferenceSteps {
        EQ(EnumSet.of(InferenceStep.EQ)),
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_LOWER_THROWS_UPPER_CAPTURED(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER, InferenceStep.UPPER, InferenceStep.THROWS, InferenceStep.CAPTURED));

        final EnumSet<InferenceStep> steps;

        private GraphInferenceSteps(EnumSet<InferenceStep> enumSet) {
            this.steps = enumSet;
        }
    }

    static enum LegacyInferenceSteps {
        EQ_LOWER(EnumSet.of(InferenceStep.EQ, InferenceStep.LOWER)),
        EQ_UPPER(EnumSet.of(InferenceStep.EQ, InferenceStep.UPPER_LEGACY));

        final EnumSet<InferenceStep> steps;

        private LegacyInferenceSteps(EnumSet<InferenceStep> enumSet) {
            this.steps = enumSet;
        }
    }

    static enum InferenceStep {
        EQ(Type.UndetVar.InferenceBound.EQ){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return (Type)this.filterBounds((Type.UndetVar)undetVar, (InferenceContext)inferenceContext).head;
            }
        }
        ,
        LOWER(Type.UndetVar.InferenceBound.LOWER){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Type type;
                Infer infer = inferenceContext.infer();
                List<Type> list = this.filterBounds(undetVar, inferenceContext);
                Type type2 = type = list.tail.tail == null ? (Type)list.head : infer.types.lub(list);
                if (type.isPrimitive() || type.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.minimal.instance.exists", undetVar.qtype, list);
                }
                return type;
            }
        }
        ,
        THROWS(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                if ((undetVar.qtype.tsym.flags() & 0x800000000000L) == 0L) {
                    return false;
                }
                if (undetVar.getBounds(Type.UndetVar.InferenceBound.EQ, Type.UndetVar.InferenceBound.LOWER, Type.UndetVar.InferenceBound.UPPER).diff(undetVar.getDeclaredBounds()).nonEmpty()) {
                    return false;
                }
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getDeclaredBounds()) {
                    if (undetVar.isInterface() || infer.types.asSuper(infer.syms.runtimeExceptionType, type.tsym) == null) continue;
                    return true;
                }
                return false;
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return ((InferenceContext)inferenceContext).infer().syms.runtimeExceptionType;
            }
        }
        ,
        UPPER(Type.UndetVar.InferenceBound.UPPER){

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Type type;
                Infer infer = inferenceContext.infer();
                List<Type> list = this.filterBounds(undetVar, inferenceContext);
                Type type2 = type = list.tail.tail == null ? (Type)list.head : infer.types.glb(list);
                if (type.isPrimitive() || type.hasTag(TypeTag.ERROR)) {
                    throw infer.inferenceException.setMessage("no.unique.maximal.instance.exists", undetVar.qtype, list);
                }
                return type;
            }
        }
        ,
        UPPER_LEGACY(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !inferenceContext.free(undetVar.getBounds(this.ib)) && !undetVar.isCaptured();
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return UPPER.solve(undetVar, inferenceContext);
            }
        }
        ,
        CAPTURED(Type.UndetVar.InferenceBound.UPPER){

            @Override
            public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return undetVar.isCaptured() && !inferenceContext.free(undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER, Type.UndetVar.InferenceBound.LOWER));
            }

            @Override
            Type solve(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                Infer infer = inferenceContext.infer();
                Type type = UPPER.filterBounds(undetVar, inferenceContext).nonEmpty() ? UPPER.solve(undetVar, inferenceContext) : infer.syms.objectType;
                Type type2 = LOWER.filterBounds(undetVar, inferenceContext).nonEmpty() ? LOWER.solve(undetVar, inferenceContext) : infer.syms.botType;
                Type.CapturedType capturedType = (Type.CapturedType)undetVar.qtype;
                return new Type.CapturedType(capturedType.tsym.name, capturedType.tsym.owner, type, type2, capturedType.wildcard, Type.noAnnotations);
            }
        };

        final Type.UndetVar.InferenceBound ib;

        private InferenceStep(Type.UndetVar.InferenceBound inferenceBound) {
            this.ib = inferenceBound;
        }

        abstract Type solve(Type.UndetVar var1, InferenceContext var2);

        public boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            return this.filterBounds(undetVar, inferenceContext).nonEmpty() && !undetVar.isCaptured();
        }

        List<Type> filterBounds(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            return Type.filter(undetVar.getBounds(this.ib), new BoundFilter(inferenceContext));
        }
    }

    abstract class BestLeafSolver
    extends LeafSolver {
        List<Type> varsToSolve;
        final Map<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>> treeCache;
        final Pair<List<GraphSolver.InferenceGraph.Node>, Integer> noPath;

        BestLeafSolver(List<Type> list) {
            this.treeCache = new HashMap<GraphSolver.InferenceGraph.Node, Pair<List<GraphSolver.InferenceGraph.Node>, Integer>>();
            this.noPath = new Pair<Object, Integer>(null, Integer.MAX_VALUE);
            this.varsToSolve = list;
        }

        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> computeTreeToLeafs(GraphSolver.InferenceGraph.Node node) {
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair = this.treeCache.get(node);
            if (pair == null) {
                if (node.isLeaf()) {
                    pair = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(node), ((ListBuffer)node.data).length());
                } else {
                    Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair2 = new Pair<List<GraphSolver.InferenceGraph.Node>, Integer>(List.of(node), ((ListBuffer)node.data).length());
                    for (GraphSolver.InferenceGraph.Node node2 : node.getAllDependencies()) {
                        if (node2 == node) continue;
                        Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair3 = this.computeTreeToLeafs(node2);
                        pair2 = new Pair(((List)pair2.fst).prependList((List)pair3.fst), (Integer)pair2.snd + (Integer)pair3.snd);
                    }
                    pair = pair2;
                }
                this.treeCache.put(node, pair);
            }
            return pair;
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph inferenceGraph) {
            this.treeCache.clear();
            Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair = this.noPath;
            for (GraphSolver.InferenceGraph.Node node : inferenceGraph.nodes) {
                if (Collections.disjoint((Collection)node.data, this.varsToSolve)) continue;
                Pair<List<GraphSolver.InferenceGraph.Node>, Integer> pair2 = this.computeTreeToLeafs(node);
                if ((Integer)pair2.snd >= (Integer)pair.snd) continue;
                pair = pair2;
            }
            if (pair == this.noPath) {
                throw new GraphStrategy.NodeNotFoundException(inferenceGraph);
            }
            return (GraphSolver.InferenceGraph.Node)((List)pair.fst).head;
        }
    }

    abstract class LeafSolver
    implements GraphStrategy {
        LeafSolver() {
        }

        @Override
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph inferenceGraph) {
            if (inferenceGraph.nodes.isEmpty()) {
                throw new GraphStrategy.NodeNotFoundException(inferenceGraph);
            }
            return inferenceGraph.nodes.get(0);
        }

        boolean isSubtype(Type type, Type type2, Warner warner, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, type, type2, warner, infer);
        }

        boolean isSameType(Type type, Type type2, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, type, type2, null, infer);
        }

        void addBound(Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar undetVar, Type type, Infer infer) {
            this.doIncorporationOp(this.opFor(inferenceBound), undetVar, type, null, infer);
        }

        IncorporationBinaryOpKind opFor(Type.UndetVar.InferenceBound inferenceBound) {
            switch (inferenceBound) {
                case EQ: {
                    return IncorporationBinaryOpKind.ADD_EQ_BOUND;
                }
                case LOWER: {
                    return IncorporationBinaryOpKind.ADD_LOWER_BOUND;
                }
                case UPPER: {
                    return IncorporationBinaryOpKind.ADD_UPPER_BOUND;
                }
            }
            Assert.error("Can't get here!");
            return null;
        }

        boolean doIncorporationOp(IncorporationBinaryOpKind incorporationBinaryOpKind, Type type, Type type2, Warner warner, Infer infer) {
            Infer infer2 = infer;
            infer2.getClass();
            IncorporationBinaryOp incorporationBinaryOp = infer2.new IncorporationBinaryOp(incorporationBinaryOpKind, type, type2);
            Boolean bl = infer.incorporationCache.get(incorporationBinaryOp);
            if (bl == null) {
                bl = incorporationBinaryOp.apply(warner);
                infer.incorporationCache.put(incorporationBinaryOp, bl);
            }
            return bl;
        }
    }

    static interface GraphStrategy {
        public GraphSolver.InferenceGraph.Node pickNode(GraphSolver.InferenceGraph var1) throws NodeNotFoundException;

        public boolean done();

        public static class NodeNotFoundException
        extends RuntimeException {
            private static final long serialVersionUID = 0L;
            GraphSolver.InferenceGraph graph;

            public NodeNotFoundException(GraphSolver.InferenceGraph inferenceGraph) {
                this.graph = inferenceGraph;
            }
        }
    }

    static enum BoundErrorKind {
        BAD_UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("incompatible.upper.bounds", undetVar.qtype, undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        BAD_EQ_UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("incompatible.eq.upper.bounds", undetVar.qtype, undetVar.getBounds(Type.UndetVar.InferenceBound.EQ), undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        BAD_EQ_LOWER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("incompatible.eq.lower.bounds", undetVar.qtype, undetVar.getBounds(Type.UndetVar.InferenceBound.EQ), undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER));
            }
        }
        ,
        UPPER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("inferred.do.not.conform.to.upper.bounds", undetVar.inst, undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER));
            }
        }
        ,
        LOWER{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("inferred.do.not.conform.to.lower.bounds", undetVar.inst, undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER));
            }
        }
        ,
        EQ{

            @Override
            Resolve.InapplicableMethodException setMessage(InferenceException inferenceException, Type.UndetVar undetVar) {
                return inferenceException.setMessage("inferred.do.not.conform.to.eq.bounds", undetVar.inst, undetVar.getBounds(Type.UndetVar.InferenceBound.EQ));
            }
        };


        abstract Resolve.InapplicableMethodException setMessage(InferenceException var1, Type.UndetVar var2);
    }

    protected static class BoundFilter
    implements Filter<Type> {
        InferenceContext inferenceContext;

        public BoundFilter(InferenceContext inferenceContext) {
            this.inferenceContext = inferenceContext;
        }

        @Override
        public boolean accepts(Type type) {
            return !type.isErroneous() && !this.inferenceContext.free(type) && !type.hasTag(TypeTag.BOT);
        }
    }

    class IncorporationBinaryOp {
        IncorporationBinaryOpKind opKind;
        Type op1;
        Type op2;

        IncorporationBinaryOp(IncorporationBinaryOpKind incorporationBinaryOpKind, Type type, Type type2) {
            this.opKind = incorporationBinaryOpKind;
            this.op1 = type;
            this.op2 = type2;
        }

        public boolean equals(Object object) {
            if (!(object instanceof IncorporationBinaryOp)) {
                return false;
            }
            IncorporationBinaryOp incorporationBinaryOp = (IncorporationBinaryOp)object;
            return this.opKind == incorporationBinaryOp.opKind && Infer.this.types.isSameType(this.op1, incorporationBinaryOp.op1, true) && Infer.this.types.isSameType(this.op2, incorporationBinaryOp.op2, true);
        }

        public int hashCode() {
            int n = this.opKind.hashCode();
            n *= 127;
            n += Infer.this.types.hashCode(this.op1);
            n *= 127;
            return n += Infer.this.types.hashCode(this.op2);
        }

        boolean apply(Warner warner) {
            return this.opKind.apply(this.op1, this.op2, warner, Infer.this.types);
        }
    }

    static enum IncorporationBinaryOpKind {
        IS_SUBTYPE{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                return types.isSubtypeUnchecked(type, type2, warner);
            }
        }
        ,
        IS_SAME_TYPE{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                return types.isSameType(type, type2);
            }
        }
        ,
        ADD_UPPER_BOUND{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.addBound(Type.UndetVar.InferenceBound.UPPER, type2, types);
                return true;
            }
        }
        ,
        ADD_LOWER_BOUND{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.addBound(Type.UndetVar.InferenceBound.LOWER, type2, types);
                return true;
            }
        }
        ,
        ADD_EQ_BOUND{

            @Override
            boolean apply(Type type, Type type2, Warner warner, Types types) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.addBound(Type.UndetVar.InferenceBound.EQ, type2, types);
                return true;
            }
        };


        abstract boolean apply(Type var1, Type var2, Warner var3, Types var4);
    }

    static enum IncorporationStep {
        CHECK_BOUNDS{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                undetVar.substBounds(inferenceContext.inferenceVars(), inferenceContext.instTypes(), infer.types);
                infer.checkCompatibleUpperBounds(undetVar, inferenceContext);
                if (undetVar.inst != null) {
                    Type type = undetVar.inst;
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (this.isSubtype(type, inferenceContext.asUndetVar(type2), warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.UPPER);
                    }
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        if (this.isSubtype(inferenceContext.asUndetVar(type2), type, warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.LOWER);
                    }
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        if (this.isSameType(type, inferenceContext.asUndetVar(type2), infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.EQ);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return true;
            }
        }
        ,
        EQ_CHECK_LEGACY{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                Type type = null;
                for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    Assert.check(!inferenceContext.free(type2));
                    if (type != null && !this.isSameType(type2, type, infer)) {
                        infer.reportBoundError(undetVar, BoundErrorKind.EQ);
                    }
                    type = type2;
                    for (Type type3 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        Assert.check(!inferenceContext.free(type3));
                        if (this.isSubtype(type3, type2, warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.BAD_EQ_LOWER);
                    }
                    for (Type type3 : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (inferenceContext.free(type3) || this.isSubtype(type2, type3, warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.BAD_EQ_UPPER);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty();
            }
        }
        ,
        EQ_CHECK{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    if (type.containsAny(inferenceContext.inferenceVars())) continue;
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        if (this.isSubtype(type, inferenceContext.asUndetVar(type2), warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.BAD_EQ_UPPER);
                    }
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        if (this.isSubtype(inferenceContext.asUndetVar(type2), type, warner, infer)) continue;
                        infer.reportBoundError(undetVar, BoundErrorKind.BAD_EQ_LOWER);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty();
            }
        }
        ,
        CROSS_UPPER_LOWER{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.isSubtype(inferenceContext.asUndetVar(type2), inferenceContext.asUndetVar(type), warner, infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).nonEmpty() && undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER).nonEmpty();
            }
        }
        ,
        CROSS_UPPER_EQ{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        this.isSubtype(inferenceContext.asUndetVar(type2), inferenceContext.asUndetVar(type), warner, infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty() && undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).nonEmpty();
            }
        }
        ,
        CROSS_EQ_LOWER{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.isSubtype(inferenceContext.asUndetVar(type2), inferenceContext.asUndetVar(type), warner, infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty() && undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER).nonEmpty();
            }
        }
        ,
        CROSS_UPPER_UPPER{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                List<Type> list = undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER);
                List list2 = list.tail;
                while (list.nonEmpty()) {
                    List list3 = list2;
                    while (list3.nonEmpty()) {
                        Type type = (Type)list.head;
                        Type type2 = (Type)list3.head;
                        if (type != type2) {
                            for (Pair pair : infer.getParameterizedSupers(type, type2)) {
                                List<Type> list4 = ((Type)pair.fst).allparams();
                                List<Type> list5 = ((Type)pair.snd).allparams();
                                while (list4.nonEmpty() && list5.nonEmpty()) {
                                    if (!(((Type)list4.head).hasTag(TypeTag.WILDCARD) || ((Type)list5.head).hasTag(TypeTag.WILDCARD) || this.isSameType(inferenceContext.asUndetVar((Type)list4.head), inferenceContext.asUndetVar((Type)list5.head), infer))) {
                                        infer.reportBoundError(undetVar, BoundErrorKind.BAD_UPPER);
                                    }
                                    list4 = list4.tail;
                                    list5 = list5.tail;
                                }
                                Assert.check(list4.isEmpty() && list5.isEmpty());
                            }
                        }
                        list3 = list3.tail;
                    }
                    list = list.tail;
                    list2 = list.tail;
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).nonEmpty();
            }
        }
        ,
        CROSS_EQ_EQ{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                        if (type == type2) continue;
                        this.isSameType(inferenceContext.asUndetVar(type2), inferenceContext.asUndetVar(type), infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty();
            }
        }
        ,
        PROP_UPPER{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                    Type.UndetVar undetVar2;
                    if (!inferenceContext.inferenceVars().contains(type) || (undetVar2 = (Type.UndetVar)inferenceContext.asUndetVar(type)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.LOWER, undetVar2, inferenceContext.asInstType(undetVar.qtype), infer);
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.addBound(Type.UndetVar.InferenceBound.LOWER, undetVar2, inferenceContext.asInstType(type2), infer);
                    }
                    for (Type type2 : undetVar2.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        this.addBound(Type.UndetVar.InferenceBound.UPPER, undetVar, inferenceContext.asInstType(type2), infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER).nonEmpty();
            }
        }
        ,
        PROP_LOWER{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                    Type.UndetVar undetVar2;
                    if (!inferenceContext.inferenceVars().contains(type) || (undetVar2 = (Type.UndetVar)inferenceContext.asUndetVar(type)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.UPPER, undetVar2, inferenceContext.asInstType(undetVar.qtype), infer);
                    for (Type type2 : undetVar.getBounds(Type.UndetVar.InferenceBound.UPPER)) {
                        this.addBound(Type.UndetVar.InferenceBound.UPPER, undetVar2, inferenceContext.asInstType(type2), infer);
                    }
                    for (Type type2 : undetVar2.getBounds(Type.UndetVar.InferenceBound.LOWER)) {
                        this.addBound(Type.UndetVar.InferenceBound.LOWER, undetVar, inferenceContext.asInstType(type2), infer);
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.LOWER).nonEmpty();
            }
        }
        ,
        PROP_EQ{

            @Override
            public void apply(Type.UndetVar undetVar, InferenceContext inferenceContext, Warner warner) {
                Infer infer = inferenceContext.infer();
                for (Type type : undetVar.getBounds(Type.UndetVar.InferenceBound.EQ)) {
                    Type.UndetVar undetVar2;
                    if (!inferenceContext.inferenceVars().contains(type) || (undetVar2 = (Type.UndetVar)inferenceContext.asUndetVar(type)).isCaptured()) continue;
                    this.addBound(Type.UndetVar.InferenceBound.EQ, undetVar2, inferenceContext.asInstType(undetVar.qtype), infer);
                    for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                        for (Type type2 : undetVar.getBounds(inferenceBound)) {
                            if (type2 == undetVar2) continue;
                            this.addBound(inferenceBound, undetVar2, inferenceContext.asInstType(type2), infer);
                        }
                    }
                    for (Type.UndetVar.InferenceBound inferenceBound : Type.UndetVar.InferenceBound.values()) {
                        for (Type type2 : undetVar2.getBounds(inferenceBound)) {
                            if (type2 == undetVar) continue;
                            this.addBound(inferenceBound, undetVar, inferenceContext.asInstType(type2), infer);
                        }
                    }
                }
            }

            @Override
            boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
                return !undetVar.isCaptured() && undetVar.getBounds(Type.UndetVar.InferenceBound.EQ).nonEmpty();
            }
        };


        abstract void apply(Type.UndetVar var1, InferenceContext var2, Warner var3);

        boolean accepts(Type.UndetVar undetVar, InferenceContext inferenceContext) {
            return !undetVar.isCaptured();
        }

        boolean isSubtype(Type type, Type type2, Warner warner, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SUBTYPE, type, type2, warner, infer);
        }

        boolean isSameType(Type type, Type type2, Infer infer) {
            return this.doIncorporationOp(IncorporationBinaryOpKind.IS_SAME_TYPE, type, type2, null, infer);
        }

        void addBound(Type.UndetVar.InferenceBound inferenceBound, Type.UndetVar undetVar, Type type, Infer infer) {
            this.doIncorporationOp(this.opFor(inferenceBound), undetVar, type, null, infer);
        }

        IncorporationBinaryOpKind opFor(Type.UndetVar.InferenceBound inferenceBound) {
            switch (inferenceBound) {
                case EQ: {
                    return IncorporationBinaryOpKind.ADD_EQ_BOUND;
                }
                case LOWER: {
                    return IncorporationBinaryOpKind.ADD_LOWER_BOUND;
                }
                case UPPER: {
                    return IncorporationBinaryOpKind.ADD_UPPER_BOUND;
                }
            }
            Assert.error("Can't get here!");
            return null;
        }

        boolean doIncorporationOp(IncorporationBinaryOpKind incorporationBinaryOpKind, Type type, Type type2, Warner warner, Infer infer) {
            Infer infer2 = infer;
            infer2.getClass();
            IncorporationBinaryOp incorporationBinaryOp = infer2.new IncorporationBinaryOp(incorporationBinaryOpKind, type, type2);
            Boolean bl = infer.incorporationCache.get(incorporationBinaryOp);
            if (bl == null) {
                bl = incorporationBinaryOp.apply(warner);
                infer.incorporationCache.put(incorporationBinaryOp, bl);
            }
            return bl;
        }
    }

    class MultiUndetVarListener
    implements Type.UndetVar.UndetVarListener {
        boolean changed;
        List<Type> undetvars;

        public MultiUndetVarListener(List<Type> list) {
            this.undetvars = list;
            for (Type type : list) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.listener = this;
            }
        }

        @Override
        public void varChanged(Type.UndetVar undetVar, Set<Type.UndetVar.InferenceBound> set) {
            if (Infer.this.incorporationCache.size() < 100) {
                this.changed = true;
            }
        }

        void reset() {
            this.changed = false;
        }

        void detach() {
            for (Type type : this.undetvars) {
                Type.UndetVar undetVar = (Type.UndetVar)type;
                undetVar.listener = null;
            }
        }
    }

    class ImplicitArgType
    extends DeferredAttr.DeferredTypeMap {
        public ImplicitArgType(Symbol symbol, Resolve.MethodResolutionPhase methodResolutionPhase) {
            DeferredAttr deferredAttr = Infer.this.rs.deferredAttr;
            deferredAttr.getClass();
            super(DeferredAttr.AttrMode.SPECULATIVE, symbol, methodResolutionPhase);
        }

        @Override
        public Type apply(Type type) {
            if ((type = Infer.this.types.erasure(super.apply(type))).hasTag(TypeTag.BOT)) {
                type = Infer.this.types.boxedClass((Type)Infer.this.syms.voidType).type;
            }
            return type;
        }
    }

    public static class InferenceException
    extends Resolve.InapplicableMethodException {
        private static final long serialVersionUID = 0L;
        List<JCDiagnostic> messages = List.nil();

        InferenceException(JCDiagnostic.Factory factory) {
            super(factory);
        }

        @Override
        Resolve.InapplicableMethodException setMessage() {
            return this;
        }

        @Override
        Resolve.InapplicableMethodException setMessage(JCDiagnostic jCDiagnostic) {
            this.messages = this.messages.append(jCDiagnostic);
            return this;
        }

        @Override
        public JCDiagnostic getDiagnostic() {
            return (JCDiagnostic)this.messages.head;
        }

        void clear() {
            this.messages = List.nil();
        }
    }
}

