/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.source.tree.Tree;
import com.sun.tools.javac.code.Attribute;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Symtab;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeAnnotationPosition;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.comp.Annotate;
import com.sun.tools.javac.comp.Attr;
import com.sun.tools.javac.comp.AttrContext;
import com.sun.tools.javac.comp.Env;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeInfo;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.ListBuffer;
import com.sun.tools.javac.util.Log;
import com.sun.tools.javac.util.Names;
import com.sun.tools.javac.util.Options;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.type.TypeKind;
import javax.tools.JavaFileObject;

public class TypeAnnotations {
    protected static final Context.Key<TypeAnnotations> typeAnnosKey = new Context.Key();
    final Log log;
    final Names names;
    final Symtab syms;
    final Annotate annotate;
    final Attr attr;

    public static TypeAnnotations instance(Context context) {
        TypeAnnotations typeAnnotations = context.get(typeAnnosKey);
        if (typeAnnotations == null) {
            typeAnnotations = new TypeAnnotations(context);
        }
        return typeAnnotations;
    }

    protected TypeAnnotations(Context context) {
        context.put(typeAnnosKey, this);
        this.names = Names.instance(context);
        this.log = Log.instance(context);
        this.syms = Symtab.instance(context);
        this.annotate = Annotate.instance(context);
        this.attr = Attr.instance(context);
        Options options = Options.instance(context);
    }

    public void organizeTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl jCClassDecl) {
        this.annotate.afterRepeated(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject javaFileObject = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    new TypeAnnotationPositions(true).scan(jCClassDecl);
                }
                finally {
                    TypeAnnotations.this.log.useSource(javaFileObject);
                }
            }
        });
    }

    public void validateTypeAnnotationsSignatures(final Env<AttrContext> env, final JCTree.JCClassDecl jCClassDecl) {
        this.annotate.validate(new Annotate.Worker(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                JavaFileObject javaFileObject = TypeAnnotations.this.log.useSource(env.toplevel.sourcefile);
                try {
                    TypeAnnotations.this.attr.validateTypeAnnotations(jCClassDecl, true);
                }
                finally {
                    TypeAnnotations.this.log.useSource(javaFileObject);
                }
            }
        });
    }

    public void organizeTypeAnnotationsBodies(JCTree.JCClassDecl jCClassDecl) {
        new TypeAnnotationPositions(false).scan(jCClassDecl);
    }

    public AnnotationType annotationType(Attribute.Compound compound, Symbol symbol) {
        Attribute.Compound compound2 = compound.type.tsym.attribute(this.syms.annotationTargetType.tsym);
        if (compound2 == null) {
            return TypeAnnotations.inferTargetMetaInfo(compound, symbol);
        }
        Attribute attribute = compound2.member(this.names.value);
        if (!(attribute instanceof Attribute.Array)) {
            Assert.error("annotationType(): bad @Target argument " + attribute + " (" + attribute.getClass() + ")");
            return AnnotationType.DECLARATION;
        }
        Attribute.Array array = (Attribute.Array)attribute;
        boolean bl = false;
        boolean bl2 = false;
        for (Attribute attribute2 : array.values) {
            if (!(attribute2 instanceof Attribute.Enum)) {
                Assert.error("annotationType(): unrecognized Attribute kind " + attribute2 + " (" + attribute2.getClass() + ")");
                bl = true;
                continue;
            }
            Attribute.Enum enum_ = (Attribute.Enum)attribute2;
            if (enum_.value.name == this.names.TYPE) {
                if (symbol.kind != 2) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.FIELD) {
                if (symbol.kind != 4 || symbol.owner.kind == 16) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.METHOD) {
                if (symbol.kind != 16 || symbol.isConstructor()) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.PARAMETER) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) == 0L) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.CONSTRUCTOR) {
                if (symbol.kind != 16 || !symbol.isConstructor()) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.LOCAL_VARIABLE) {
                if (symbol.kind != 4 || symbol.owner.kind != 16 || (symbol.flags() & 0x200000000L) != 0L) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.ANNOTATION_TYPE) {
                if (symbol.kind != 2 || (symbol.flags() & 0x2000L) == 0L) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.PACKAGE) {
                if (symbol.kind != 1) continue;
                bl = true;
                continue;
            }
            if (enum_.value.name == this.names.TYPE_USE) {
                if (symbol.kind != 2 && symbol.kind != 4 && (symbol.kind != 16 || symbol.isConstructor() || symbol.type.getReturnType().hasTag(TypeTag.VOID)) && (symbol.kind != 16 || !symbol.isConstructor())) continue;
                bl2 = true;
                continue;
            }
            if (enum_.value.name == this.names.TYPE_PARAMETER) continue;
            Assert.error("annotationType(): unrecognized Attribute name " + enum_.value.name + " (" + enum_.value.name.getClass() + ")");
            bl = true;
        }
        if (bl && bl2) {
            return AnnotationType.BOTH;
        }
        if (bl2) {
            return AnnotationType.TYPE;
        }
        return AnnotationType.DECLARATION;
    }

    private static AnnotationType inferTargetMetaInfo(Attribute.Compound compound, Symbol symbol) {
        return AnnotationType.DECLARATION;
    }

    private class TypeAnnotationPositions
    extends TreeScanner {
        private final boolean sigOnly;
        private ListBuffer<JCTree> frames = new ListBuffer();
        private boolean isInClass = false;
        private JCTree.JCLambda currentLambda = null;

        TypeAnnotationPositions(boolean bl) {
            this.sigOnly = bl;
        }

        protected void push(JCTree jCTree) {
            this.frames = this.frames.prepend(jCTree);
        }

        protected JCTree pop() {
            return this.frames.next();
        }

        private JCTree peek2() {
            return (JCTree)this.frames.toList().tail.head;
        }

        @Override
        public void scan(JCTree jCTree) {
            this.push(jCTree);
            super.scan(jCTree);
            this.pop();
        }

        private void separateAnnotationsKinds(JCTree jCTree, Type type, Symbol symbol, TypeAnnotationPosition typeAnnotationPosition) {
            List list;
            List<Attribute.Compound> list2 = symbol.getRawAttributes();
            ListBuffer<Attribute.Compound> listBuffer = new ListBuffer<Attribute.Compound>();
            ListBuffer<Attribute.TypeCompound> listBuffer2 = new ListBuffer<Attribute.TypeCompound>();
            ListBuffer<Attribute.TypeCompound> listBuffer3 = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.Compound object : list2) {
                switch (TypeAnnotations.this.annotationType(object, symbol)) {
                    case DECLARATION: {
                        listBuffer.append(object);
                        break;
                    }
                    case BOTH: {
                        listBuffer.append(object);
                        list = this.toTypeCompound(object, typeAnnotationPosition);
                        listBuffer2.append((Attribute.TypeCompound)((Object)list));
                        break;
                    }
                    case TYPE: {
                        list = this.toTypeCompound(object, typeAnnotationPosition);
                        listBuffer2.append((Attribute.TypeCompound)((Object)list));
                        listBuffer3.append((Attribute.TypeCompound)((Object)list));
                        break;
                    }
                }
            }
            symbol.resetAnnotations();
            symbol.setDeclarationAttributes(listBuffer.toList());
            if (listBuffer2.isEmpty()) {
                return;
            }
            List list3 = listBuffer2.toList();
            if (type == null) {
                type = symbol.getEnclosingElement().asType();
                type = this.typeWithAnnotations(jCTree, type, list3, list3);
                symbol.appendUniqueTypeAttributes(list3);
                return;
            }
            type = this.typeWithAnnotations(jCTree, type, list3, listBuffer3.toList());
            if (symbol.getKind() == ElementKind.METHOD) {
                symbol.type.asMethodType().restype = type;
            } else if (symbol.getKind() == ElementKind.PARAMETER) {
                symbol.type = type;
                if (symbol.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                    symbol.owner.type.asMethodType().recvtype = type;
                } else {
                    Type.MethodType methodType = symbol.owner.type.asMethodType();
                    list = ((Symbol.MethodSymbol)symbol.owner).params;
                    List<Type> list4 = methodType.argtypes;
                    ListBuffer<Type> listBuffer4 = new ListBuffer<Type>();
                    while (list.nonEmpty()) {
                        if (list.head == symbol) {
                            listBuffer4.add(type);
                        } else {
                            listBuffer4.add((Type)list4.head);
                        }
                        list4 = list4.tail;
                        list = list.tail;
                    }
                    methodType.argtypes = listBuffer4.toList();
                }
            } else {
                symbol.type = type;
            }
            symbol.appendUniqueTypeAttributes(list3);
            if (symbol.getKind() == ElementKind.PARAMETER || symbol.getKind() == ElementKind.LOCAL_VARIABLE || symbol.getKind() == ElementKind.RESOURCE_VARIABLE || symbol.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                symbol.owner.appendUniqueTypeAttributes(symbol.getRawTypeAttributes());
            }
        }

        private Type typeWithAnnotations(JCTree jCTree, Type type, List<Attribute.TypeCompound> list, List<Attribute.TypeCompound> list2) {
            Object object;
            if (list.isEmpty()) {
                return type;
            }
            if (type.hasTag(TypeTag.ARRAY)) {
                Object object2;
                Type type2;
                Type.ArrayType arrayType = (Type.ArrayType)type;
                Type.ArrayType arrayType2 = new Type.ArrayType(null, arrayType.tsym, Type.noAnnotations);
                Type type3 = type.isAnnotated() ? arrayType2.annotatedType((List)type.getAnnotationMirrors()) : arrayType2;
                JCTree.JCArrayTypeTree jCArrayTypeTree = this.arrayTypeTree(jCTree);
                ListBuffer<Object> listBuffer = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
                listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                while (arrayType.elemtype.hasTag(TypeTag.ARRAY)) {
                    if (arrayType.elemtype.isAnnotated()) {
                        type2 = arrayType.elemtype;
                        arrayType = (Type.ArrayType)type2;
                        object2 = arrayType2;
                        arrayType2 = new Type.ArrayType(null, arrayType.tsym, Type.noAnnotations);
                        ((Type.ArrayType)object2).elemtype = arrayType2.annotatedType((List)arrayType.elemtype.getAnnotationMirrors());
                    } else {
                        arrayType = (Type.ArrayType)arrayType.elemtype;
                        arrayType2.elemtype = new Type.ArrayType(null, arrayType.tsym, Type.noAnnotations);
                        arrayType2 = (Type.ArrayType)arrayType2.elemtype;
                    }
                    jCArrayTypeTree = this.arrayTypeTree(jCArrayTypeTree.elemtype);
                    listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                }
                arrayType2.elemtype = type2 = this.typeWithAnnotations(jCArrayTypeTree.elemtype, arrayType.elemtype, list, list2);
                object2 = list.get(0);
                TypeAnnotationPosition typeAnnotationPosition = ((Attribute.TypeCompound)object2).position;
                typeAnnotationPosition.location = typeAnnotationPosition.location.prependList(listBuffer.toList());
                jCTree.type = type3;
                return type3;
            }
            if (type.hasTag(TypeTag.TYPEVAR)) {
                return type;
            }
            if (type.getKind() == TypeKind.UNION) {
                Type type4;
                JCTree.JCTypeUnion jCTypeUnion = (JCTree.JCTypeUnion)jCTree;
                JCTree.JCExpression jCExpression = jCTypeUnion.alternatives.get(0);
                jCExpression.type = type4 = this.typeWithAnnotations(jCExpression, jCExpression.type, list, list2);
                return type;
            }
            Type type5 = type;
            Element element = type.asElement();
            JCTree jCTree2 = jCTree;
            while (element != null && element.getKind() != ElementKind.PACKAGE && type5 != null && type5.getKind() != TypeKind.NONE && type5.getKind() != TypeKind.ERROR && (jCTree2.getKind() == Tree.Kind.MEMBER_SELECT || jCTree2.getKind() == Tree.Kind.PARAMETERIZED_TYPE || jCTree2.getKind() == Tree.Kind.ANNOTATED_TYPE)) {
                if (jCTree2.getKind() == Tree.Kind.MEMBER_SELECT) {
                    type5 = type5.getEnclosingType();
                    element = element.getEnclosingElement();
                    jCTree2 = ((JCTree.JCFieldAccess)jCTree2).getExpression();
                    continue;
                }
                if (jCTree2.getKind() == Tree.Kind.PARAMETERIZED_TYPE) {
                    jCTree2 = ((JCTree.JCTypeApply)jCTree2).getType();
                    continue;
                }
                jCTree2 = ((JCTree.JCAnnotatedType)jCTree2).getUnderlyingType();
            }
            if (type5 != null && type5.hasTag(TypeTag.NONE)) {
                switch (list2.size()) {
                    case 0: {
                        break;
                    }
                    case 1: {
                        TypeAnnotations.this.log.error(jCTree.pos(), "cant.type.annotate.scoping.1", list2);
                        break;
                    }
                    default: {
                        TypeAnnotations.this.log.error(jCTree.pos(), "cant.type.annotate.scoping", list2);
                    }
                }
                return type;
            }
            ListBuffer<TypeAnnotationPosition.TypePathEntry> listBuffer = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (Type type6 = type5; element != null && element.getKind() != ElementKind.PACKAGE && type6 != null && type6.getKind() != TypeKind.NONE && type6.getKind() != TypeKind.ERROR; type6 = type6.getEnclosingType(), element = element.getEnclosingElement()) {
                if (type6 == null || type6.getKind() == TypeKind.NONE) continue;
                listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            if (listBuffer.nonEmpty()) {
                object = list.get(0);
                TypeAnnotationPosition typeAnnotationPosition = ((Attribute.TypeCompound)object).position;
                typeAnnotationPosition.location = typeAnnotationPosition.location.appendList(listBuffer.toList());
            }
            jCTree.type = object = this.typeWithAnnotations(type, type5, list);
            return object;
        }

        private JCTree.JCArrayTypeTree arrayTypeTree(JCTree jCTree) {
            if (jCTree.getKind() == Tree.Kind.ARRAY_TYPE) {
                return (JCTree.JCArrayTypeTree)jCTree;
            }
            if (jCTree.getKind() == Tree.Kind.ANNOTATED_TYPE) {
                return (JCTree.JCArrayTypeTree)((JCTree.JCAnnotatedType)jCTree).underlyingType;
            }
            Assert.error("Could not determine array type from type tree: " + jCTree);
            return null;
        }

        private Type typeWithAnnotations(Type type, final Type type2, List<Attribute.TypeCompound> list) {
            Type.Visitor<Type, List<Attribute.TypeCompound>> visitor = new Type.Visitor<Type, List<Attribute.TypeCompound>>(){

                @Override
                public Type visitClassType(Type.ClassType classType, List<Attribute.TypeCompound> list) {
                    if (classType == type2 || classType.getEnclosingType() == Type.noType) {
                        return classType.annotatedType((List)list);
                    }
                    Type.ClassType classType2 = new Type.ClassType(classType.getEnclosingType().accept(this, list), classType.typarams_field, classType.tsym, (List<Attribute.TypeCompound>)classType.getAnnotationMirrors());
                    classType2.all_interfaces_field = classType.all_interfaces_field;
                    classType2.allparams_field = classType.allparams_field;
                    classType2.interfaces_field = classType.interfaces_field;
                    classType2.rank_field = classType.rank_field;
                    classType2.supertype_field = classType.supertype_field;
                    return classType2;
                }

                @Override
                public Type visitWildcardType(Type.WildcardType wildcardType, List<Attribute.TypeCompound> list) {
                    return wildcardType.annotatedType((List)list);
                }

                @Override
                public Type visitArrayType(Type.ArrayType arrayType, List<Attribute.TypeCompound> list) {
                    Type.ArrayType arrayType2 = new Type.ArrayType(arrayType.elemtype.accept(this, list), arrayType.tsym, (List<Attribute.TypeCompound>)arrayType.getAnnotationMirrors());
                    return arrayType2;
                }

                @Override
                public Type visitMethodType(Type.MethodType methodType, List<Attribute.TypeCompound> list) {
                    return methodType;
                }

                @Override
                public Type visitPackageType(Type.PackageType packageType, List<Attribute.TypeCompound> list) {
                    return packageType;
                }

                @Override
                public Type visitTypeVar(Type.TypeVar typeVar, List<Attribute.TypeCompound> list) {
                    return typeVar.annotatedType((List)list);
                }

                @Override
                public Type visitCapturedType(Type.CapturedType capturedType, List<Attribute.TypeCompound> list) {
                    return capturedType.annotatedType((List)list);
                }

                @Override
                public Type visitForAll(Type.ForAll forAll, List<Attribute.TypeCompound> list) {
                    return forAll;
                }

                @Override
                public Type visitUndetVar(Type.UndetVar undetVar, List<Attribute.TypeCompound> list) {
                    return undetVar;
                }

                @Override
                public Type visitErrorType(Type.ErrorType errorType, List<Attribute.TypeCompound> list) {
                    return errorType.annotatedType((List)list);
                }

                @Override
                public Type visitType(Type type, List<Attribute.TypeCompound> list) {
                    return type.annotatedType(list);
                }
            };
            return type.accept(visitor, list);
        }

        private Attribute.TypeCompound toTypeCompound(Attribute.Compound compound, TypeAnnotationPosition typeAnnotationPosition) {
            return new Attribute.TypeCompound(compound, typeAnnotationPosition);
        }

        private TypeAnnotationPosition resolveFrame(JCTree jCTree, JCTree jCTree2, List<JCTree> list, JCTree.JCLambda jCLambda, int n, ListBuffer<TypeAnnotationPosition.TypePathEntry> listBuffer) {
            switch (jCTree2.getKind()) {
                case TYPE_CAST: {
                    return TypeAnnotationPosition.typeCast(listBuffer.toList(), jCLambda, n, jCTree2.pos);
                }
                case INSTANCE_OF: {
                    return TypeAnnotationPosition.instanceOf(listBuffer.toList(), jCLambda, jCTree2.pos);
                }
                case NEW_CLASS: {
                    JCTree.JCNewClass jCNewClass = (JCTree.JCNewClass)jCTree2;
                    if (jCNewClass.def != null) {
                        JCTree.JCClassDecl jCClassDecl = jCNewClass.def;
                        if (jCClassDecl.extending == jCTree) {
                            return TypeAnnotationPosition.classExtends(listBuffer.toList(), jCLambda, jCTree2.pos);
                        }
                        if (jCClassDecl.implementing.contains(jCTree)) {
                            int n2 = jCClassDecl.implementing.indexOf(jCTree);
                            return TypeAnnotationPosition.classExtends(listBuffer.toList(), jCLambda, n2, jCTree2.pos);
                        }
                        throw new AssertionError((Object)("Could not determine position of tree " + jCTree + " within frame " + jCTree2));
                    }
                    if (jCNewClass.typeargs.contains(jCTree)) {
                        int n3 = jCNewClass.typeargs.indexOf(jCTree);
                        return TypeAnnotationPosition.constructorInvocationTypeArg(listBuffer.toList(), jCLambda, n3, jCTree2.pos);
                    }
                    return TypeAnnotationPosition.newObj(listBuffer.toList(), jCLambda, jCTree2.pos);
                }
                case NEW_ARRAY: {
                    return TypeAnnotationPosition.newObj(listBuffer.toList(), jCLambda, jCTree2.pos);
                }
                case ANNOTATION_TYPE: 
                case CLASS: 
                case ENUM: 
                case INTERFACE: {
                    if (((JCTree.JCClassDecl)jCTree2).extending == jCTree) {
                        return TypeAnnotationPosition.classExtends(listBuffer.toList(), jCLambda, jCTree2.pos);
                    }
                    if (((JCTree.JCClassDecl)jCTree2).implementing.contains(jCTree)) {
                        int n4 = ((JCTree.JCClassDecl)jCTree2).implementing.indexOf(jCTree);
                        return TypeAnnotationPosition.classExtends(listBuffer.toList(), jCLambda, n4, jCTree2.pos);
                    }
                    if (((JCTree.JCClassDecl)jCTree2).typarams.contains(jCTree)) {
                        int n5 = ((JCTree.JCClassDecl)jCTree2).typarams.indexOf(jCTree);
                        return TypeAnnotationPosition.typeParameter(listBuffer.toList(), jCLambda, n5, jCTree2.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + jCTree + " within frame " + jCTree2));
                }
                case METHOD: {
                    JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)jCTree2;
                    if (jCMethodDecl.thrown.contains(jCTree)) {
                        int n6 = jCMethodDecl.thrown.indexOf(jCTree);
                        return TypeAnnotationPosition.methodThrows(listBuffer.toList(), jCLambda, n6, jCTree2.pos);
                    }
                    if (jCMethodDecl.restype == jCTree) {
                        return TypeAnnotationPosition.methodReturn(listBuffer.toList(), jCLambda, jCTree2.pos);
                    }
                    if (jCMethodDecl.typarams.contains(jCTree)) {
                        int n7 = jCMethodDecl.typarams.indexOf(jCTree);
                        return TypeAnnotationPosition.methodTypeParameter(listBuffer.toList(), jCLambda, n7, jCTree2.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + jCTree + " within frame " + jCTree2));
                }
                case PARAMETERIZED_TYPE: {
                    List<JCTree> list2 = list.tail;
                    if (((JCTree.JCTypeApply)jCTree2).clazz != jCTree) {
                        if (((JCTree.JCTypeApply)jCTree2).arguments.contains(jCTree)) {
                            JCTree.JCTypeApply jCTypeApply = (JCTree.JCTypeApply)jCTree2;
                            int n8 = jCTypeApply.arguments.indexOf(jCTree);
                            listBuffer = listBuffer.prepend(new TypeAnnotationPosition.TypePathEntry(TypeAnnotationPosition.TypePathEntryKind.TYPE_ARGUMENT, n8));
                            Type type = list2.tail != null && ((JCTree)list2.tail.head).hasTag(JCTree.Tag.NEWCLASS) ? ((JCTree)list2.tail.head).type : jCTypeApply.type;
                            listBuffer = this.locateNestedTypes(type, listBuffer);
                        } else {
                            throw new AssertionError((Object)("Could not determine type argument position of tree " + jCTree + " within frame " + jCTree2));
                        }
                    }
                    return this.resolveFrame((JCTree)list2.head, (JCTree)list2.tail.head, list2, jCLambda, n, listBuffer);
                }
                case MEMBER_REFERENCE: {
                    JCTree.JCMemberReference jCMemberReference = (JCTree.JCMemberReference)jCTree2;
                    if (jCMemberReference.expr == jCTree) {
                        switch (jCMemberReference.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRef(listBuffer.toList(), jCLambda, jCTree2.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRef(listBuffer.toList(), jCLambda, jCTree2.pos);
                            }
                        }
                        throw new AssertionError((Object)("Unknown method reference mode " + (Object)((Object)jCMemberReference.mode) + " for tree " + jCTree + " within frame " + jCTree2));
                    }
                    if (jCMemberReference.typeargs != null && jCMemberReference.typeargs.contains(jCTree)) {
                        int n9 = jCMemberReference.typeargs.indexOf(jCTree);
                        switch (jCMemberReference.mode) {
                            case INVOKE: {
                                return TypeAnnotationPosition.methodRefTypeArg(listBuffer.toList(), jCLambda, n9, jCTree2.pos);
                            }
                            case NEW: {
                                return TypeAnnotationPosition.constructorRefTypeArg(listBuffer.toList(), jCLambda, n9, jCTree2.pos);
                            }
                        }
                        throw new AssertionError((Object)("Unknown method reference mode " + (Object)((Object)jCMemberReference.mode) + " for tree " + jCTree + " within frame " + jCTree2));
                    }
                    throw new AssertionError((Object)("Could not determine type argument position of tree " + jCTree + " within frame " + jCTree2));
                }
                case ARRAY_TYPE: {
                    listBuffer = listBuffer.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    List<JCTree> list3 = list.tail;
                    while (true) {
                        JCTree jCTree3;
                        if ((jCTree3 = (JCTree)list3.tail.head).hasTag(JCTree.Tag.TYPEARRAY)) {
                            list3 = list3.tail;
                            listBuffer = listBuffer.prepend(TypeAnnotationPosition.TypePathEntry.ARRAY);
                            continue;
                        }
                        if (!jCTree3.hasTag(JCTree.Tag.ANNOTATED_TYPE)) break;
                        list3 = list3.tail;
                    }
                    return this.resolveFrame((JCTree)list3.head, (JCTree)list3.tail.head, list3, jCLambda, n, listBuffer);
                }
                case TYPE_PARAMETER: {
                    if (((JCTree)list.tail.tail.head).hasTag(JCTree.Tag.CLASSDEF)) {
                        JCTree.JCClassDecl jCClassDecl = (JCTree.JCClassDecl)list.tail.tail.head;
                        int n10 = jCClassDecl.typarams.indexOf(list.tail.head);
                        int n11 = ((JCTree.JCTypeParameter)jCTree2).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)jCTree2).bounds.indexOf(jCTree) + 1 : ((JCTree.JCTypeParameter)jCTree2).bounds.indexOf(jCTree);
                        return TypeAnnotationPosition.typeParameterBound(listBuffer.toList(), jCLambda, n10, n11, jCTree2.pos);
                    }
                    if (((JCTree)list.tail.tail.head).hasTag(JCTree.Tag.METHODDEF)) {
                        JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)list.tail.tail.head;
                        int n12 = jCMethodDecl.typarams.indexOf(list.tail.head);
                        int n13 = ((JCTree.JCTypeParameter)jCTree2).bounds.get((int)0).type.isInterface() ? ((JCTree.JCTypeParameter)jCTree2).bounds.indexOf(jCTree) + 1 : ((JCTree.JCTypeParameter)jCTree2).bounds.indexOf(jCTree);
                        return TypeAnnotationPosition.methodTypeParameterBound(listBuffer.toList(), jCLambda, n12, n13, jCTree2.pos);
                    }
                    throw new AssertionError((Object)("Could not determine position of tree " + jCTree + " within frame " + jCTree2));
                }
                case VARIABLE: {
                    Symbol.VarSymbol varSymbol = ((JCTree.JCVariableDecl)jCTree2).sym;
                    if (varSymbol.getKind() != ElementKind.FIELD) {
                        varSymbol.owner.appendUniqueTypeAttributes(varSymbol.getRawTypeAttributes());
                    }
                    switch (varSymbol.getKind()) {
                        case LOCAL_VARIABLE: {
                            return TypeAnnotationPosition.localVariable(listBuffer.toList(), jCLambda, jCTree2.pos);
                        }
                        case FIELD: {
                            return TypeAnnotationPosition.field(listBuffer.toList(), jCLambda, jCTree2.pos);
                        }
                        case PARAMETER: {
                            if (varSymbol.getQualifiedName().equals(TypeAnnotations.this.names._this)) {
                                return TypeAnnotationPosition.methodReceiver(listBuffer.toList(), jCLambda, jCTree2.pos);
                            }
                            int n14 = this.methodParamIndex(list, jCTree2);
                            return TypeAnnotationPosition.methodParameter(listBuffer.toList(), jCLambda, n14, jCTree2.pos);
                        }
                        case EXCEPTION_PARAMETER: {
                            return TypeAnnotationPosition.exceptionParameter(listBuffer.toList(), jCLambda, jCTree2.pos);
                        }
                        case RESOURCE_VARIABLE: {
                            return TypeAnnotationPosition.resourceVariable(listBuffer.toList(), jCLambda, jCTree2.pos);
                        }
                    }
                    throw new AssertionError((Object)("Found unexpected type annotation for variable: " + varSymbol + " with kind: " + (Object)((Object)varSymbol.getKind())));
                }
                case ANNOTATED_TYPE: {
                    Object object;
                    if (jCTree2 == jCTree) {
                        object = (JCTree.JCAnnotatedType)jCTree2;
                        Type type = ((JCTree.JCAnnotatedType)object).underlyingType.type;
                        Assert.checkNonNull(type);
                        Symbol.TypeSymbol typeSymbol = type.tsym;
                        if (!(typeSymbol.getKind().equals((Object)ElementKind.TYPE_PARAMETER) || type.getKind().equals((Object)TypeKind.WILDCARD) || type.getKind().equals((Object)TypeKind.ARRAY))) {
                            listBuffer = this.locateNestedTypes(type, listBuffer);
                        }
                    }
                    object = list.tail;
                    return this.resolveFrame((JCTree)((List)object).head, (JCTree)((List)object).tail.head, (List<JCTree>)object, jCLambda, n, listBuffer);
                }
                case UNION_TYPE: {
                    List<JCTree> list4 = list.tail;
                    return this.resolveFrame((JCTree)list4.head, (JCTree)list4.tail.head, list4, jCLambda, n, listBuffer);
                }
                case INTERSECTION_TYPE: {
                    JCTree.JCTypeIntersection jCTypeIntersection = (JCTree.JCTypeIntersection)jCTree2;
                    List<JCTree> list5 = list.tail;
                    return this.resolveFrame((JCTree)list5.head, (JCTree)list5.tail.head, list5, jCLambda, jCTypeIntersection.bounds.indexOf(jCTree), listBuffer);
                }
                case METHOD_INVOCATION: {
                    JCTree.JCMethodInvocation jCMethodInvocation = (JCTree.JCMethodInvocation)jCTree2;
                    if (!jCMethodInvocation.typeargs.contains(jCTree)) {
                        throw new AssertionError((Object)("{" + jCTree + "} is not an argument in the invocation: " + jCMethodInvocation));
                    }
                    Symbol.MethodSymbol methodSymbol = (Symbol.MethodSymbol)TreeInfo.symbol(jCMethodInvocation.getMethodSelect());
                    int n15 = jCMethodInvocation.typeargs.indexOf(jCTree);
                    if (methodSymbol == null) {
                        throw new AssertionError((Object)("could not determine symbol for {" + jCMethodInvocation + "}"));
                    }
                    if (methodSymbol.isConstructor()) {
                        return TypeAnnotationPosition.constructorInvocationTypeArg(listBuffer.toList(), jCLambda, n15, jCMethodInvocation.pos);
                    }
                    return TypeAnnotationPosition.methodInvocationTypeArg(listBuffer.toList(), jCLambda, n15, jCMethodInvocation.pos);
                }
                case EXTENDS_WILDCARD: 
                case SUPER_WILDCARD: {
                    List<JCTree> list6 = list.tail;
                    return this.resolveFrame((JCTree)list6.head, (JCTree)list6.tail.head, list6, jCLambda, n, listBuffer.prepend(TypeAnnotationPosition.TypePathEntry.WILDCARD));
                }
                case MEMBER_SELECT: {
                    List<JCTree> list7 = list.tail;
                    return this.resolveFrame((JCTree)list7.head, (JCTree)list7.tail.head, list7, jCLambda, n, listBuffer);
                }
            }
            throw new AssertionError((Object)("Unresolved frame: " + jCTree2 + " of kind: " + (Object)((Object)jCTree2.getKind()) + "\n    Looking for tree: " + jCTree));
        }

        private ListBuffer<TypeAnnotationPosition.TypePathEntry> locateNestedTypes(Type type, ListBuffer<TypeAnnotationPosition.TypePathEntry> listBuffer) {
            for (Type type2 = type.getEnclosingType(); type2 != null && type2.getKind() != TypeKind.NONE && type2.getKind() != TypeKind.ERROR; type2 = type2.getEnclosingType()) {
                listBuffer = listBuffer.prepend(TypeAnnotationPosition.TypePathEntry.INNER_TYPE);
            }
            return listBuffer;
        }

        private int methodParamIndex(List<JCTree> list, JCTree jCTree) {
            List<JCTree> list2 = list;
            while (((JCTree)list2.head).getTag() != JCTree.Tag.METHODDEF && ((JCTree)list2.head).getTag() != JCTree.Tag.LAMBDA) {
                list2 = list2.tail;
            }
            if (((JCTree)list2.head).getTag() == JCTree.Tag.METHODDEF) {
                JCTree.JCMethodDecl jCMethodDecl = (JCTree.JCMethodDecl)list2.head;
                return jCMethodDecl.params.indexOf(jCTree);
            }
            if (((JCTree)list2.head).getTag() == JCTree.Tag.LAMBDA) {
                JCTree.JCLambda jCLambda = (JCTree.JCLambda)list2.head;
                return jCLambda.params.indexOf(jCTree);
            }
            Assert.error("methodParamIndex expected to find method or lambda for param: " + jCTree);
            return -1;
        }

        @Override
        public void visitClassDef(JCTree.JCClassDecl jCClassDecl) {
            if (this.isInClass) {
                return;
            }
            this.isInClass = true;
            if (this.sigOnly) {
                this.scan(jCClassDecl.mods);
                this.scan(jCClassDecl.typarams);
                this.scan(jCClassDecl.extending);
                this.scan(jCClassDecl.implementing);
            }
            this.scan(jCClassDecl.defs);
        }

        @Override
        public void visitMethodDef(JCTree.JCMethodDecl jCMethodDecl) {
            if (jCMethodDecl.sym == null) {
                Assert.error("Visiting tree node before memberEnter");
            }
            if (this.sigOnly) {
                TypeAnnotationPosition typeAnnotationPosition;
                if (!jCMethodDecl.mods.annotations.isEmpty()) {
                    if (jCMethodDecl.sym.isConstructor()) {
                        typeAnnotationPosition = TypeAnnotationPosition.methodReturn(jCMethodDecl.pos);
                        this.separateAnnotationsKinds(jCMethodDecl, null, jCMethodDecl.sym, typeAnnotationPosition);
                    } else {
                        typeAnnotationPosition = TypeAnnotationPosition.methodReturn(jCMethodDecl.restype.pos);
                        this.separateAnnotationsKinds(jCMethodDecl.restype, jCMethodDecl.sym.type.getReturnType(), jCMethodDecl.sym, typeAnnotationPosition);
                    }
                }
                if (jCMethodDecl.recvparam != null && jCMethodDecl.recvparam.sym != null && !jCMethodDecl.recvparam.mods.annotations.isEmpty()) {
                    typeAnnotationPosition = TypeAnnotationPosition.methodReceiver(jCMethodDecl.recvparam.vartype.pos);
                    this.separateAnnotationsKinds(jCMethodDecl.recvparam.vartype, jCMethodDecl.recvparam.sym.type, jCMethodDecl.recvparam.sym, typeAnnotationPosition);
                }
                int n = 0;
                for (JCTree.JCVariableDecl jCVariableDecl : jCMethodDecl.params) {
                    if (!jCVariableDecl.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition typeAnnotationPosition2 = TypeAnnotationPosition.methodParameter(n, jCVariableDecl.vartype.pos);
                        this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition2);
                    }
                    ++n;
                }
            }
            this.push(jCMethodDecl);
            if (this.sigOnly) {
                this.scan(jCMethodDecl.mods);
                this.scan(jCMethodDecl.restype);
                this.scan(jCMethodDecl.typarams);
                this.scan(jCMethodDecl.recvparam);
                this.scan(jCMethodDecl.params);
                this.scan(jCMethodDecl.thrown);
            } else {
                this.scan(jCMethodDecl.defaultValue);
                this.scan(jCMethodDecl.body);
            }
            this.pop();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitLambda(JCTree.JCLambda jCLambda) {
            JCTree.JCLambda jCLambda2 = this.currentLambda;
            try {
                this.currentLambda = jCLambda;
                int n = 0;
                for (JCTree.JCVariableDecl jCVariableDecl : jCLambda.params) {
                    if (!jCVariableDecl.mods.annotations.isEmpty()) {
                        TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.methodParameter(jCLambda, n, jCVariableDecl.vartype.pos);
                        this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition);
                    }
                    ++n;
                }
                this.push(jCLambda);
                this.scan(jCLambda.body);
                this.scan(jCLambda.params);
                this.pop();
            }
            finally {
                this.currentLambda = jCLambda2;
            }
        }

        @Override
        public void visitVarDef(JCTree.JCVariableDecl jCVariableDecl) {
            if (!jCVariableDecl.mods.annotations.isEmpty()) {
                if (jCVariableDecl.sym == null) {
                    Assert.error("Visiting tree node before memberEnter");
                } else if (jCVariableDecl.sym.getKind() != ElementKind.PARAMETER) {
                    if (jCVariableDecl.sym.getKind() == ElementKind.FIELD) {
                        if (this.sigOnly) {
                            TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.field(jCVariableDecl.pos);
                            this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition);
                        }
                    } else if (jCVariableDecl.sym.getKind() == ElementKind.LOCAL_VARIABLE) {
                        TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.localVariable(this.currentLambda, jCVariableDecl.pos);
                        this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition);
                    } else if (jCVariableDecl.sym.getKind() == ElementKind.EXCEPTION_PARAMETER) {
                        TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.exceptionParameter(this.currentLambda, jCVariableDecl.pos);
                        this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition);
                    } else if (jCVariableDecl.sym.getKind() == ElementKind.RESOURCE_VARIABLE) {
                        TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.resourceVariable(this.currentLambda, jCVariableDecl.pos);
                        this.separateAnnotationsKinds(jCVariableDecl.vartype, jCVariableDecl.sym.type, jCVariableDecl.sym, typeAnnotationPosition);
                    } else if (jCVariableDecl.sym.getKind() != ElementKind.ENUM_CONSTANT) {
                        Assert.error("Unhandled variable kind: " + jCVariableDecl + " of kind: " + (Object)((Object)jCVariableDecl.sym.getKind()));
                    }
                }
            }
            this.push(jCVariableDecl);
            this.scan(jCVariableDecl.mods);
            this.scan(jCVariableDecl.vartype);
            if (!this.sigOnly) {
                this.scan(jCVariableDecl.init);
            }
            this.pop();
        }

        @Override
        public void visitBlock(JCTree.JCBlock jCBlock) {
            if (!this.sigOnly) {
                this.scan(jCBlock.stats);
            }
        }

        @Override
        public void visitAnnotatedType(JCTree.JCAnnotatedType jCAnnotatedType) {
            this.push(jCAnnotatedType);
            this.findPosition(jCAnnotatedType, jCAnnotatedType, jCAnnotatedType.annotations);
            this.pop();
            super.visitAnnotatedType(jCAnnotatedType);
        }

        @Override
        public void visitTypeParameter(JCTree.JCTypeParameter jCTypeParameter) {
            this.findPosition(jCTypeParameter, this.peek2(), jCTypeParameter.annotations);
            super.visitTypeParameter(jCTypeParameter);
        }

        private void copyNewClassAnnotationsToOwner(JCTree.JCNewClass jCNewClass) {
            Symbol.ClassSymbol classSymbol = jCNewClass.def.sym;
            TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.newObj(jCNewClass.pos);
            ListBuffer<Attribute.TypeCompound> listBuffer = new ListBuffer<Attribute.TypeCompound>();
            for (Attribute.TypeCompound typeCompound : ((Symbol)classSymbol).getRawTypeAttributes()) {
                listBuffer.append(new Attribute.TypeCompound(typeCompound.type, typeCompound.values, typeAnnotationPosition));
            }
            classSymbol.owner.appendUniqueTypeAttributes(listBuffer.toList());
        }

        @Override
        public void visitNewClass(JCTree.JCNewClass jCNewClass) {
            if (jCNewClass.def != null && !jCNewClass.def.mods.annotations.isEmpty()) {
                TypeAnnotationPosition typeAnnotationPosition;
                JCTree.JCClassDecl jCClassDecl = jCNewClass.def;
                if (jCClassDecl.extending == jCNewClass.clazz) {
                    typeAnnotationPosition = TypeAnnotationPosition.classExtends(jCNewClass.pos);
                } else if (jCClassDecl.implementing.contains(jCNewClass.clazz)) {
                    int n = jCClassDecl.implementing.indexOf(jCNewClass.clazz);
                    typeAnnotationPosition = TypeAnnotationPosition.classExtends(n, jCNewClass.pos);
                } else {
                    throw new AssertionError((Object)("Could not determine position of tree " + jCNewClass));
                }
                Type type = jCClassDecl.sym.type;
                this.separateAnnotationsKinds(jCClassDecl, jCNewClass.clazz.type, jCClassDecl.sym, typeAnnotationPosition);
                this.copyNewClassAnnotationsToOwner(jCNewClass);
                jCClassDecl.sym.type = type;
            }
            this.scan(jCNewClass.encl);
            this.scan(jCNewClass.typeargs);
            this.scan(jCNewClass.clazz);
            this.scan(jCNewClass.args);
        }

        @Override
        public void visitNewArray(JCTree.JCNewArray jCNewArray) {
            Object object;
            Object object2;
            this.findPosition(jCNewArray, jCNewArray, jCNewArray.annotations);
            int n = jCNewArray.dimAnnotations.size();
            ListBuffer<Object> listBuffer = new ListBuffer<TypeAnnotationPosition.TypePathEntry>();
            for (int i = 0; i < n; ++i) {
                object2 = new ListBuffer<Object>();
                if (i != 0) {
                    listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    object2 = ((ListBuffer)object2).appendList(listBuffer.toList());
                }
                object = TypeAnnotationPosition.newObj(((ListBuffer)object2).toList(), this.currentLambda, jCNewArray.pos);
                this.setTypeAnnotationPos(jCNewArray.dimAnnotations.get(i), (TypeAnnotationPosition)object);
            }
            JCTree.JCExpression jCExpression = jCNewArray.elemtype;
            listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
            while (jCExpression != null) {
                if (jCExpression.hasTag(JCTree.Tag.ANNOTATED_TYPE)) {
                    object2 = (JCTree.JCAnnotatedType)jCExpression;
                    object = this.locateNestedTypes(jCExpression.type, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                    List<Object> list = ((ListBuffer)object).toList().prependList(listBuffer.toList());
                    TypeAnnotationPosition typeAnnotationPosition = TypeAnnotationPosition.newObj(list, this.currentLambda, jCNewArray.pos);
                    this.setTypeAnnotationPos(((JCTree.JCAnnotatedType)object2).annotations, typeAnnotationPosition);
                    jCExpression = ((JCTree.JCAnnotatedType)object2).underlyingType;
                    continue;
                }
                if (jCExpression.hasTag(JCTree.Tag.TYPEARRAY)) {
                    listBuffer = listBuffer.append(TypeAnnotationPosition.TypePathEntry.ARRAY);
                    jCExpression = ((JCTree.JCArrayTypeTree)jCExpression).elemtype;
                    continue;
                }
                if (!jCExpression.hasTag(JCTree.Tag.SELECT)) break;
                jCExpression = ((JCTree.JCFieldAccess)jCExpression).selected;
            }
            this.scan(jCNewArray.elems);
        }

        private void findPosition(JCTree jCTree, JCTree jCTree2, List<JCTree.JCAnnotation> list) {
            if (!list.isEmpty()) {
                TypeAnnotationPosition typeAnnotationPosition = this.resolveFrame(jCTree, jCTree2, this.frames.toList(), this.currentLambda, 0, new ListBuffer<TypeAnnotationPosition.TypePathEntry>());
                this.setTypeAnnotationPos(list, typeAnnotationPosition);
            }
        }

        private void setTypeAnnotationPos(List<JCTree.JCAnnotation> list, TypeAnnotationPosition typeAnnotationPosition) {
            for (JCTree.JCAnnotation jCAnnotation : list) {
                if (jCAnnotation.attribute == null) continue;
                ((Attribute.TypeCompound)jCAnnotation.attribute).position = typeAnnotationPosition;
            }
        }

        public String toString() {
            return super.toString() + ": sigOnly: " + this.sigOnly;
        }
    }

    public static enum AnnotationType {
        DECLARATION,
        TYPE,
        BOTH;

    }
}

