/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.code;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.util.Assert;
import com.sun.tools.javac.util.Filter;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Name;
import java.util.Collections;
import java.util.Iterator;

public abstract class Scope {
    public final Symbol owner;
    private static final Filter<Symbol> noFilter = null;
    List<ScopeListener> listeners = List.nil();

    protected Scope(Symbol symbol) {
        this.owner = symbol;
    }

    public final Iterable<Symbol> getSymbols() {
        return this.getSymbols(noFilter);
    }

    public final Iterable<Symbol> getSymbols(Filter<Symbol> filter) {
        return this.getSymbols(filter, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbols(LookupKind lookupKind) {
        return this.getSymbols(noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbols(Filter<Symbol> var1, LookupKind var2);

    public final Iterable<Symbol> getSymbolsByName(Name name) {
        return this.getSymbolsByName(name, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter) {
        return this.getSymbolsByName(name, filter, LookupKind.RECURSIVE);
    }

    public final Iterable<Symbol> getSymbolsByName(Name name, LookupKind lookupKind) {
        return this.getSymbolsByName(name, noFilter, lookupKind);
    }

    public abstract Iterable<Symbol> getSymbolsByName(Name var1, Filter<Symbol> var2, LookupKind var3);

    public final Symbol findFirst(Name name) {
        return this.findFirst(name, noFilter);
    }

    public Symbol findFirst(Name name, Filter<Symbol> filter) {
        Iterator<Symbol> iterator = this.getSymbolsByName(name, filter).iterator();
        return iterator.hasNext() ? iterator.next() : null;
    }

    public boolean anyMatch(Filter<Symbol> filter) {
        return this.getSymbols(filter, LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public boolean includes(final Symbol symbol) {
        return this.getSymbolsByName(symbol.name, new Filter<Symbol>(){

            @Override
            public boolean accepts(Symbol symbol2) {
                return symbol2 == symbol;
            }
        }).iterator().hasNext();
    }

    public boolean isEmpty() {
        return !this.getSymbols(LookupKind.NON_RECURSIVE).iterator().hasNext();
    }

    public abstract Scope getOrigin(Symbol var1);

    public abstract boolean isStaticallyImported(Symbol var1);

    public void addScopeListener(ScopeListener scopeListener) {
        this.listeners = this.listeners.prepend(scopeListener);
    }

    public static class ErrorScope
    extends ScopeImpl {
        ErrorScope(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray) {
            super(scopeImpl, symbol, entryArray);
        }

        public ErrorScope(Symbol symbol) {
            super(symbol);
        }

        @Override
        public WriteableScope dup(Symbol symbol) {
            return new ErrorScope(this, symbol, this.table);
        }

        @Override
        public WriteableScope dupUnshared(Symbol symbol) {
            return new ErrorScope(this, symbol, (Entry[])this.table.clone());
        }

        @Override
        public Entry lookup(Name name) {
            Entry entry = super.lookup(name);
            if (entry.scope == null) {
                return new Entry(this.owner, null, null, null);
            }
            return entry;
        }
    }

    public static class CompoundScope
    extends Scope
    implements ScopeListener {
        List<Scope> subScopes = List.nil();
        private int mark = 0;

        public CompoundScope(Symbol symbol) {
            super(symbol);
        }

        public void prependSubScope(Scope scope) {
            if (scope != null) {
                this.subScopes = this.subScopes.prepend(scope);
                scope.addScopeListener(this);
                ++this.mark;
                for (ScopeListener scopeListener : this.listeners) {
                    scopeListener.symbolAdded(null, this);
                }
            }
        }

        @Override
        public void symbolAdded(Symbol symbol, Scope scope) {
            ++this.mark;
            for (ScopeListener scopeListener : this.listeners) {
                scopeListener.symbolAdded(symbol, scope);
            }
        }

        @Override
        public void symbolRemoved(Symbol symbol, Scope scope) {
            ++this.mark;
            for (ScopeListener scopeListener : this.listeners) {
                scopeListener.symbolRemoved(symbol, scope);
            }
        }

        public int getMark() {
            return this.mark;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("CompoundScope{");
            String string = "";
            for (Scope scope : this.subScopes) {
                stringBuilder.append(string);
                stringBuilder.append(scope);
                string = ",";
            }
            stringBuilder.append("}");
            return stringBuilder.toString();
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> filter, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(CompoundScope.this.subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope scope) {
                            return scope.getSymbols(filter, lookupKind).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> filter, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new CompoundScopeIterator(CompoundScope.this.subScopes){

                        @Override
                        Iterator<Symbol> nextIterator(Scope scope) {
                            return scope.getSymbolsByName(name, filter, lookupKind).iterator();
                        }
                    };
                }
            };
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            for (Scope scope : this.subScopes) {
                if (!scope.includes(symbol)) continue;
                return scope.getOrigin(symbol);
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            for (Scope scope : this.subScopes) {
                if (!scope.includes(symbol)) continue;
                return scope.isStaticallyImported(symbol);
            }
            return false;
        }

        abstract class CompoundScopeIterator
        implements Iterator<Symbol> {
            private Iterator<Symbol> currentIterator;
            private List<Scope> scopesToScan;

            public CompoundScopeIterator(List<Scope> list) {
                this.scopesToScan = list;
                this.update();
            }

            abstract Iterator<Symbol> nextIterator(Scope var1);

            @Override
            public boolean hasNext() {
                return this.currentIterator != null;
            }

            @Override
            public Symbol next() {
                Symbol symbol = this.currentIterator.next();
                if (!this.currentIterator.hasNext()) {
                    this.update();
                }
                return symbol;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            private void update() {
                while (this.scopesToScan.nonEmpty()) {
                    this.currentIterator = this.nextIterator((Scope)this.scopesToScan.head);
                    this.scopesToScan = this.scopesToScan.tail;
                    if (!this.currentIterator.hasNext()) continue;
                    return;
                }
                this.currentIterator = null;
            }
        }
    }

    private static class FilterImportScope
    extends Scope {
        private final Scope delegate;
        private final Scope origin;
        private final Name filterName;
        private final ImportFilter filter;
        private final boolean staticImport;

        public FilterImportScope(Scope scope, Scope scope2, Name name, ImportFilter importFilter, boolean bl) {
            super(scope.owner);
            this.delegate = scope;
            this.origin = scope2;
            this.filterName = name;
            this.filter = importFilter;
            this.staticImport = bl;
        }

        @Override
        public Iterable<Symbol> getSymbols(Filter<Symbol> filter, LookupKind lookupKind) {
            if (this.filterName != null) {
                return this.getSymbolsByName(this.filterName, filter, lookupKind);
            }
            return new FilteredIterable(this.delegate.getSymbols(filter, lookupKind));
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter, LookupKind lookupKind) {
            if (this.filterName != null && this.filterName != name) {
                return Collections.emptyList();
            }
            return new FilteredIterable(this.delegate.getSymbolsByName(name, filter, lookupKind));
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            return this.origin;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            return this.staticImport;
        }

        private class FilteredIterable
        implements Iterable<Symbol> {
            private final Iterable<Symbol> unfiltered;

            public FilteredIterable(Iterable<Symbol> iterable) {
                this.unfiltered = iterable;
            }

            @Override
            public Iterator<Symbol> iterator() {
                return new FilteredIterator(this.unfiltered.iterator());
            }
        }

        private class FilteredIterator
        implements Iterator<Symbol> {
            private final Iterator<Symbol> delegate;
            private Symbol next;

            public FilteredIterator(Iterator<Symbol> iterator) {
                this.delegate = iterator;
                this.update();
            }

            void update() {
                while (this.delegate.hasNext()) {
                    this.next = this.delegate.next();
                    if (!FilterImportScope.this.filter.accepts(FilterImportScope.this.origin, this.next)) continue;
                    return;
                }
                this.next = null;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public Symbol next() {
                Symbol symbol = this.next;
                this.update();
                return symbol;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported.");
            }
        }
    }

    public static interface ImportFilter {
        public boolean accepts(Scope var1, Symbol var2);
    }

    public static class StarImportScope
    extends CompoundScope {
        public StarImportScope(Symbol symbol) {
            super(symbol);
        }

        public void importAll(Scope scope, Scope scope2, ImportFilter importFilter, boolean bl) {
            for (Scope scope3 : this.subScopes) {
                Assert.check(scope3 instanceof FilterImportScope);
                FilterImportScope filterImportScope = (FilterImportScope)scope3;
                if (filterImportScope.delegate != scope || filterImportScope.origin != scope2 || filterImportScope.filter != importFilter || filterImportScope.staticImport != bl) continue;
                return;
            }
            this.prependSubScope(new FilterImportScope(scope, scope2, null, importFilter, bl));
        }
    }

    public static class NamedImportScope
    extends CompoundScope {
        public NamedImportScope(Symbol symbol, Scope scope) {
            super(symbol);
            this.prependSubScope(scope);
        }

        public void importByName(Scope scope, Scope scope2, Name name, ImportFilter importFilter) {
            this.appendScope(new FilterImportScope(scope, scope2, name, importFilter, true));
        }

        public void importType(Scope scope, Scope scope2, Symbol symbol) {
            this.appendScope(new SingleEntryScope(scope.owner, symbol, scope2));
        }

        private void appendScope(Scope scope) {
            List list = this.subScopes.reverse();
            this.subScopes = List.of(list.head);
            this.subScopes = this.subScopes.prepend(scope);
            for (Scope scope2 : list.tail) {
                this.subScopes = this.subScopes.prepend(scope2);
            }
        }

        private static class SingleEntryScope
        extends Scope {
            private final Symbol sym;
            private final List<Symbol> content;
            private final Scope origin;

            public SingleEntryScope(Symbol symbol, Symbol symbol2, Scope scope) {
                super(symbol);
                this.sym = symbol2;
                this.content = List.of(symbol2);
                this.origin = scope;
            }

            @Override
            public Iterable<Symbol> getSymbols(Filter<Symbol> filter, LookupKind lookupKind) {
                return filter == null || filter.accepts(this.sym) ? this.content : Collections.emptyList();
            }

            @Override
            public Iterable<Symbol> getSymbolsByName(Name name, Filter<Symbol> filter, LookupKind lookupKind) {
                return this.sym.name == name && (filter == null || filter.accepts(this.sym)) ? this.content : Collections.emptyList();
            }

            @Override
            public Scope getOrigin(Symbol symbol) {
                return this.sym == symbol ? this.origin : null;
            }

            @Override
            public boolean isStaticallyImported(Symbol symbol) {
                return false;
            }
        }
    }

    private static class Entry {
        public Symbol sym;
        private Entry shadowed;
        public Entry sibling;
        public Scope scope;

        public Entry(Symbol symbol, Entry entry, Entry entry2, Scope scope) {
            this.sym = symbol;
            this.shadowed = entry;
            this.sibling = entry2;
            this.scope = scope;
        }

        public Entry next() {
            return this.shadowed;
        }

        public Entry next(Filter<Symbol> filter) {
            if (this.shadowed.sym == null || filter == null || filter.accepts(this.shadowed.sym)) {
                return this.shadowed;
            }
            return this.shadowed.next(filter);
        }
    }

    private static class ScopeImpl
    extends WriteableScope {
        private int shared;
        public ScopeImpl next;
        Entry[] table;
        int hashMask;
        public Entry elems;
        int nelems = 0;
        private static final Entry sentinel = new Entry(null, null, null, null);
        private static final int INITIAL_SIZE = 16;

        private ScopeImpl(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray) {
            super(symbol);
            this.next = scopeImpl;
            Assert.check(symbol != null);
            this.table = entryArray;
            this.hashMask = entryArray.length - 1;
        }

        private ScopeImpl(ScopeImpl scopeImpl, Symbol symbol, Entry[] entryArray, int n) {
            this(scopeImpl, symbol, entryArray);
            this.nelems = n;
        }

        public ScopeImpl(Symbol symbol) {
            this(null, symbol, new Entry[16]);
        }

        @Override
        public WriteableScope dup(Symbol symbol) {
            ScopeImpl scopeImpl = new ScopeImpl(this, symbol, this.table, this.nelems);
            ++this.shared;
            return scopeImpl;
        }

        @Override
        public WriteableScope dupUnshared(Symbol symbol) {
            return new ScopeImpl(this, symbol, (Entry[])this.table.clone(), this.nelems);
        }

        @Override
        public WriteableScope leave() {
            Assert.check(this.shared == 0);
            if (this.table != this.next.table) {
                return this.next;
            }
            while (this.elems != null) {
                int n = this.getIndex(this.elems.sym.name);
                Entry entry = this.table[n];
                Assert.check(entry == this.elems, this.elems.sym);
                this.table[n] = this.elems.shadowed;
                this.elems = this.elems.sibling;
            }
            Assert.check(this.next.shared > 0);
            --this.next.shared;
            this.next.nelems = this.nelems;
            return this.next;
        }

        private void dble() {
            Assert.check(this.shared == 0);
            Entry[] entryArray = this.table;
            Entry[] entryArray2 = new Entry[entryArray.length * 2];
            ScopeImpl scopeImpl = this;
            while (scopeImpl != null) {
                if (scopeImpl.table == entryArray) {
                    Assert.check(scopeImpl == this || scopeImpl.shared != 0);
                    scopeImpl.table = entryArray2;
                    scopeImpl.hashMask = entryArray2.length - 1;
                }
                scopeImpl = scopeImpl.next;
            }
            int n = 0;
            int n2 = entryArray.length;
            while (--n2 >= 0) {
                Entry entry = entryArray[n2];
                if (entry == null || entry == sentinel) continue;
                this.table[this.getIndex((Name)entry.sym.name)] = entry;
                ++n;
            }
            this.nelems = n;
        }

        @Override
        public void enter(Symbol symbol) {
            Entry entry;
            int n;
            Entry entry2;
            Assert.check(this.shared == 0);
            if (this.nelems * 3 >= this.hashMask * 2) {
                this.dble();
            }
            if ((entry2 = this.table[n = this.getIndex(symbol.name)]) == null) {
                entry2 = sentinel;
                ++this.nelems;
            }
            this.table[n] = entry = new Entry(symbol, entry2, this.elems, this);
            this.elems = entry;
            List list = this.listeners;
            while (list.nonEmpty()) {
                ((ScopeListener)list.head).symbolAdded(symbol, this);
                list = list.tail;
            }
        }

        @Override
        public void remove(Symbol symbol) {
            Assert.check(this.shared == 0);
            Entry entry = this.lookup(symbol.name);
            if (entry.scope == null) {
                return;
            }
            int n = this.getIndex(symbol.name);
            Entry entry2 = this.table[n];
            if (entry2 == entry) {
                this.table[n] = entry.shadowed;
            } else {
                while (true) {
                    if (entry2.shadowed == entry) {
                        entry2.shadowed = entry.shadowed;
                        break;
                    }
                    entry2 = entry2.shadowed;
                }
            }
            entry2 = this.elems;
            if (entry2 == entry) {
                this.elems = entry.sibling;
            } else {
                while (true) {
                    if (entry2.sibling == entry) {
                        entry2.sibling = entry.sibling;
                        break;
                    }
                    entry2 = entry2.sibling;
                }
            }
            List list = this.listeners;
            while (list.nonEmpty()) {
                ((ScopeListener)list.head).symbolRemoved(symbol, this);
                list = list.tail;
            }
        }

        @Override
        public void enterIfAbsent(Symbol symbol) {
            Assert.check(this.shared == 0);
            Entry entry = this.lookup(symbol.name);
            while (entry.scope == this && entry.sym.kind != symbol.kind) {
                entry = entry.next();
            }
            if (entry.scope != this) {
                this.enter(symbol);
            }
        }

        @Override
        public boolean includes(Symbol symbol) {
            Entry entry = this.lookup(symbol.name);
            while (entry.scope == this) {
                if (entry.sym == symbol) {
                    return true;
                }
                entry = entry.next();
            }
            return false;
        }

        protected Entry lookup(Name name) {
            return this.lookup(name, noFilter);
        }

        protected Entry lookup(Name name, Filter<Symbol> filter) {
            Entry entry = this.table[this.getIndex(name)];
            if (entry == null || entry == sentinel) {
                return sentinel;
            }
            while (entry.scope != null && (entry.sym.name != name || filter != null && !filter.accepts(entry.sym))) {
                entry = entry.shadowed;
            }
            return entry;
        }

        @Override
        public Symbol findFirst(Name name, Filter<Symbol> filter) {
            return this.lookup((Name)name, filter).sym;
        }

        int getIndex(Name name) {
            int n = name.hashCode();
            int n2 = n & this.hashMask;
            int n3 = this.hashMask - (n + (n >> 16) << 1);
            int n4 = -1;
            Entry entry;
            while ((entry = this.table[n2]) != null) {
                if (entry == sentinel) {
                    if (n4 < 0) {
                        n4 = n2;
                    }
                } else if (entry.sym.name == name) {
                    return n2;
                }
                n2 = n2 + n3 & this.hashMask;
            }
            return n4 >= 0 ? n4 : n2;
        }

        @Override
        public boolean anyMatch(Filter<Symbol> filter) {
            return this.getSymbols(filter, LookupKind.NON_RECURSIVE).iterator().hasNext();
        }

        @Override
        public Iterable<Symbol> getSymbols(final Filter<Symbol> filter, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new Iterator<Symbol>(){
                        private ScopeImpl currScope;
                        private Entry currEntry;
                        {
                            this.currScope = ScopeImpl.this;
                            this.currEntry = ScopeImpl.this.elems;
                            this.update();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currEntry != null;
                        }

                        @Override
                        public Symbol next() {
                            Symbol symbol;
                            Symbol symbol2 = symbol = this.currEntry == null ? null : this.currEntry.sym;
                            if (this.currEntry != null) {
                                this.currEntry = this.currEntry.sibling;
                            }
                            this.update();
                            return symbol;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }

                        private void update() {
                            this.skipToNextMatchingEntry();
                            if (lookupKind == LookupKind.RECURSIVE) {
                                while (this.currEntry == null && this.currScope.next != null) {
                                    this.currScope = this.currScope.next;
                                    this.currEntry = this.currScope.elems;
                                    this.skipToNextMatchingEntry();
                                }
                            }
                        }

                        void skipToNextMatchingEntry() {
                            while (this.currEntry != null && filter != null && !filter.accepts(this.currEntry.sym)) {
                                this.currEntry = this.currEntry.sibling;
                            }
                        }
                    };
                }
            };
        }

        @Override
        public Iterable<Symbol> getSymbolsByName(final Name name, final Filter<Symbol> filter, final LookupKind lookupKind) {
            return new Iterable<Symbol>(){

                @Override
                public Iterator<Symbol> iterator() {
                    return new Iterator<Symbol>(){
                        Entry currentEntry;
                        {
                            this.currentEntry = ScopeImpl.this.lookup(name, filter);
                        }

                        @Override
                        public boolean hasNext() {
                            return this.currentEntry.scope != null && (lookupKind == LookupKind.RECURSIVE || this.currentEntry.scope == ScopeImpl.this);
                        }

                        @Override
                        public Symbol next() {
                            Entry entry = this.currentEntry;
                            this.currentEntry = this.currentEntry.next(filter);
                            return entry.sym;
                        }

                        @Override
                        public void remove() {
                            throw new UnsupportedOperationException();
                        }
                    };
                }
            };
        }

        @Override
        public Scope getOrigin(Symbol symbol) {
            Entry entry = this.lookup(symbol.name);
            while (entry.scope != null) {
                if (entry.sym == symbol) {
                    return this;
                }
                entry = entry.next();
            }
            return null;
        }

        @Override
        public boolean isStaticallyImported(Symbol symbol) {
            return false;
        }

        public String toString() {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("Scope[");
            ScopeImpl scopeImpl = this;
            while (scopeImpl != null) {
                if (scopeImpl != this) {
                    stringBuilder.append(" | ");
                }
                Entry entry = scopeImpl.elems;
                while (entry != null) {
                    if (entry != scopeImpl.elems) {
                        stringBuilder.append(", ");
                    }
                    stringBuilder.append(entry.sym);
                    entry = entry.sibling;
                }
                scopeImpl = scopeImpl.next;
            }
            stringBuilder.append("]");
            return stringBuilder.toString();
        }
    }

    public static abstract class WriteableScope
    extends Scope {
        public WriteableScope(Symbol symbol) {
            super(symbol);
        }

        public abstract void enter(Symbol var1);

        public abstract void enterIfAbsent(Symbol var1);

        public abstract void remove(Symbol var1);

        public final WriteableScope dup() {
            return this.dup(this.owner);
        }

        public abstract WriteableScope dup(Symbol var1);

        public abstract WriteableScope leave();

        public final WriteableScope dupUnshared() {
            return this.dupUnshared(this.owner);
        }

        public abstract WriteableScope dupUnshared(Symbol var1);

        public static WriteableScope create(Symbol symbol) {
            return new ScopeImpl(symbol);
        }
    }

    public static enum LookupKind {
        RECURSIVE,
        NON_RECURSIVE;

    }

    public static interface ScopeListener {
        public void symbolAdded(Symbol var1, Scope var2);

        public void symbolRemoved(Symbol var1, Scope var2);
    }
}

