/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.stats;

import com.google.instrumentation.common.Duration;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class IntervalAggregationDescriptor {
    private final int numSubIntervals;
    private final List<Duration> intervalSizes;

    public static IntervalAggregationDescriptor create(int n, List<Duration> list) {
        if (n < 2 || n > 20) {
            throw new IllegalArgumentException("The number of subintervals must be in the range [2, 20].");
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("There must be at least one interval size.");
        }
        return new IntervalAggregationDescriptor(n, Collections.unmodifiableList(new ArrayList<Duration>(list)));
    }

    public static IntervalAggregationDescriptor create(List<Duration> list) {
        return IntervalAggregationDescriptor.create(5, list);
    }

    public int getNumSubIntervals() {
        return this.numSubIntervals;
    }

    public List<Duration> getIntervalSizes() {
        return this.intervalSizes;
    }

    private IntervalAggregationDescriptor(int n, List<Duration> list) {
        this.numSubIntervals = n;
        this.intervalSizes = list;
    }
}

