/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client.spi.impl;

import com.hazelcast.cache.impl.JCacheDetector;
import com.hazelcast.client.HazelcastClientNotActiveException;
import com.hazelcast.client.config.ClientProperty;
import com.hazelcast.client.connection.ClientConnectionManager;
import com.hazelcast.client.connection.nio.ClientConnection;
import com.hazelcast.client.impl.HazelcastClientInstanceImpl;
import com.hazelcast.client.impl.protocol.ClientExceptionFactory;
import com.hazelcast.client.impl.protocol.ClientMessage;
import com.hazelcast.client.spi.ClientExecutionService;
import com.hazelcast.client.spi.ClientInvocationService;
import com.hazelcast.client.spi.ClientPartitionService;
import com.hazelcast.client.spi.EventHandler;
import com.hazelcast.client.spi.impl.CallIdSequence;
import com.hazelcast.client.spi.impl.ClientInvocation;
import com.hazelcast.client.spi.impl.listener.ClientListenerServiceImpl;
import com.hazelcast.instance.OutOfMemoryErrorDispatcher;
import com.hazelcast.logging.ILogger;
import com.hazelcast.logging.Logger;
import com.hazelcast.nio.Connection;
import com.hazelcast.nio.OutboundFrame;
import com.hazelcast.spi.exception.TargetDisconnectedException;
import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;

abstract class ClientInvocationServiceSupport
implements ClientInvocationService {
    private static final int WAIT_TIME_FOR_PACKETS_TO_BE_CONSUMED_THRESHOLD = 5000;
    protected final HazelcastClientInstanceImpl client;
    protected ClientConnectionManager connectionManager;
    protected ClientPartitionService partitionService;
    protected ClientExecutionService executionService;
    protected ClientListenerServiceImpl clientListenerService;
    private ILogger logger = Logger.getLogger(ClientInvocationService.class);
    private ResponseThread responseThread;
    private ConcurrentMap<Long, ClientInvocation> callIdMap = new ConcurrentHashMap<Long, ClientInvocation>();
    private final CallIdSequence callIdSequence;
    private ClientExceptionFactory clientExceptionFactory;
    private volatile boolean isShutdown;

    public ClientInvocationServiceSupport(HazelcastClientInstanceImpl client) {
        this.client = client;
        int maxAllowedConcurrentInvocations = client.getClientProperties().getInteger(ClientProperty.MAX_CONCURRENT_INVOCATIONS);
        this.callIdSequence = new CallIdSequence.CallIdSequenceFailFast(maxAllowedConcurrentInvocations);
    }

    @Override
    public void start() {
        this.connectionManager = this.client.getConnectionManager();
        this.executionService = this.client.getClientExecutionService();
        this.clientListenerService = (ClientListenerServiceImpl)this.client.getListenerService();
        this.partitionService = this.client.getClientPartitionService();
        this.clientExceptionFactory = this.initClientExceptionFactory();
        this.responseThread = new ResponseThread(this.client.getThreadGroup(), this.client.getName() + ".response-", this.client.getClientConfig().getClassLoader());
        this.responseThread.start();
        this.executionService.scheduleWithFixedDelay(new CleanResourcesTask(), 1L, 1L, TimeUnit.SECONDS);
    }

    private ClientExceptionFactory initClientExceptionFactory() {
        boolean jcacheAvailable = JCacheDetector.isJcacheAvailable((ClassLoader)this.client.getClientConfig().getClassLoader());
        return new ClientExceptionFactory(jcacheAvailable);
    }

    @Override
    public boolean isRedoOperation() {
        return this.client.getClientConfig().getNetworkConfig().isRedoOperation();
    }

    protected void send(ClientInvocation invocation, ClientConnection connection) throws IOException {
        if (this.isShutdown) {
            throw new HazelcastClientNotActiveException("Client is shut down");
        }
        this.registerInvocation(invocation);
        ClientMessage clientMessage = invocation.getClientMessage();
        if (!this.isAllowedToSendRequest(connection, invocation) || !this.writeToConnection(connection, clientMessage)) {
            long callId = clientMessage.getCorrelationId();
            ClientInvocation clientInvocation = this.deRegisterCallId(callId);
            if (clientInvocation != null) {
                this.callIdSequence.complete();
                throw new IOException("Packet not send to " + connection.getRemoteEndpoint());
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.finest("Invocation not found to deregister for call id " + callId);
            }
        }
        invocation.setSendConnection(connection);
    }

    private boolean writeToConnection(ClientConnection connection, ClientMessage clientMessage) {
        clientMessage.addFlag((short)192);
        return connection.write((OutboundFrame)clientMessage);
    }

    private boolean isAllowedToSendRequest(ClientConnection connection, ClientInvocation invocation) {
        if (!connection.isHeartBeating()) {
            if (invocation.shouldBypassHeartbeatCheck()) {
                return true;
            }
            if (this.logger.isFinestEnabled()) {
                this.logger.warning("Connection is not heart-beating, won't write client message -> " + invocation.getClientMessage());
            }
            return false;
        }
        return true;
    }

    private void registerInvocation(ClientInvocation clientInvocation) {
        short protocolVersion = this.client.getProtocolVersion();
        long correlationId = clientInvocation.isUrgent() ? this.callIdSequence.renew() : this.callIdSequence.next();
        clientInvocation.getClientMessage().setCorrelationId(correlationId).setVersion(protocolVersion);
        this.callIdMap.put(correlationId, clientInvocation);
        EventHandler handler = clientInvocation.getEventHandler();
        if (handler != null) {
            this.clientListenerService.addEventHandler(correlationId, handler);
        }
    }

    private ClientInvocation deRegisterCallId(long callId) {
        return (ClientInvocation)this.callIdMap.remove(callId);
    }

    public boolean isShutdown() {
        return this.isShutdown;
    }

    @Override
    public void shutdown() {
        this.isShutdown = true;
        this.responseThread.interrupt();
        Iterator iterator = this.callIdMap.values().iterator();
        while (iterator.hasNext()) {
            ClientInvocation invocation = (ClientInvocation)iterator.next();
            iterator.remove();
            invocation.notifyException(new HazelcastClientNotActiveException("Client is shutting down"));
        }
        assert (this.callIdMap.isEmpty());
    }

    @Override
    public void handleClientMessage(ClientMessage message, Connection connection) {
        this.responseThread.workQueue.add(new ClientPacket((ClientConnection)connection, message));
    }

    private class ResponseThread
    extends Thread {
        private final BlockingQueue<ClientPacket> workQueue;

        public ResponseThread(ThreadGroup threadGroup, String name, ClassLoader classLoader) {
            super(threadGroup, name);
            this.workQueue = new LinkedBlockingQueue<ClientPacket>();
            this.setContextClassLoader(classLoader);
        }

        @Override
        public void run() {
            try {
                this.doRun();
            }
            catch (OutOfMemoryError e) {
                OutOfMemoryErrorDispatcher.onOutOfMemory((OutOfMemoryError)e);
            }
            catch (Throwable t) {
                ClientInvocationServiceSupport.this.logger.severe(t);
            }
        }

        private void doRun() {
            while (true) {
                ClientPacket task;
                try {
                    task = this.workQueue.take();
                }
                catch (InterruptedException e) {
                    if (!ClientInvocationServiceSupport.this.isShutdown) continue;
                    return;
                }
                if (ClientInvocationServiceSupport.this.isShutdown) {
                    return;
                }
                this.process(task);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void process(ClientPacket packet) {
            ClientConnection conn = packet.getClientConnection();
            try {
                this.handleClientMessage(packet.getClientMessage());
            }
            catch (Exception e) {
                ClientInvocationServiceSupport.this.logger.severe("Failed to process task: " + packet + " on responseThread :" + this.getName(), (Throwable)e);
            }
            finally {
                conn.decrementPendingPacketCount();
            }
        }

        private void handleClientMessage(ClientMessage clientMessage) {
            long correlationId = clientMessage.getCorrelationId();
            ClientInvocation future = ClientInvocationServiceSupport.this.deRegisterCallId(correlationId);
            if (future == null) {
                ClientInvocationServiceSupport.this.logger.warning("No call for callId: " + correlationId + ", response: " + clientMessage);
                return;
            }
            ClientInvocationServiceSupport.this.callIdSequence.complete();
            if (109 == clientMessage.getMessageType()) {
                Throwable exception = ClientInvocationServiceSupport.this.clientExceptionFactory.createException(clientMessage);
                future.notifyException(exception);
            } else {
                future.notify(clientMessage);
            }
        }
    }

    private static class ClientPacket {
        private final ClientConnection clientConnection;
        private final ClientMessage clientMessage;

        public ClientPacket(ClientConnection clientConnection, ClientMessage clientMessage) {
            this.clientConnection = clientConnection;
            this.clientMessage = clientMessage;
        }

        public ClientConnection getClientConnection() {
            return this.clientConnection;
        }

        public ClientMessage getClientMessage() {
            return this.clientMessage;
        }
    }

    private class CleanResourcesTask
    implements Runnable {
        private CleanResourcesTask() {
        }

        @Override
        public void run() {
            Iterator iter = ClientInvocationServiceSupport.this.callIdMap.entrySet().iterator();
            LinkedList expiredConnections = null;
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                ClientInvocation invocation = (ClientInvocation)entry.getValue();
                ClientConnection connection = invocation.getSendConnection();
                if (connection == null || connection.isHeartBeating()) continue;
                if (connection.getPendingPacketCount() != 0) {
                    long closedTime = connection.getClosedTime();
                    long elapsed = System.currentTimeMillis() - closedTime;
                    if (elapsed < 5000L) continue;
                    if (expiredConnections == null) {
                        expiredConnections = new LinkedList();
                    }
                }
                iter.remove();
                invocation.notifyException((Throwable)new TargetDisconnectedException(connection.getRemoteEndpoint()));
            }
            if (expiredConnections != null) {
                this.logExpiredConnections(expiredConnections);
            }
        }

        private void logExpiredConnections(Collection<ClientConnection> expiredConnections) {
            for (ClientConnection expiredConnection : expiredConnections) {
                int pendingPacketCount = expiredConnection.getPendingPacketCount();
                if (pendingPacketCount == 0) continue;
                ClientInvocationServiceSupport.this.logger.warning("There are " + pendingPacketCount + " packets which are not processed " + " on " + expiredConnection.getRemoteEndpoint());
            }
        }
    }
}

