/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javah;

import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.main.CommandLine;
import com.sun.tools.javah.Gen;
import com.sun.tools.javah.InternalError;
import com.sun.tools.javah.JNI;
import com.sun.tools.javah.JavahFileManager;
import com.sun.tools.javah.LLNI;
import com.sun.tools.javah.NativeHeaderTool;
import com.sun.tools.javah.Util;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.nio.file.NoSuchFileException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.type.TypeVisitor;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.SimpleTypeVisitor9;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;

public class JavahTask
implements NativeHeaderTool.NativeHeaderTask {
    static final Option[] recognizedOptions = new Option[]{new Option(true, new String[]{"-o"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.ofile = new File(arg);
        }
    }, new Option(true, new String[]{"-d"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.odir = new File(arg);
        }
    }, new HiddenOption(true, new String[]{"-td"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
        }
    }, new HiddenOption(false, new String[]{"-stubs"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
        }
    }, new Option(false, new String[]{"-v", "-verbose"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.verbose = true;
        }
    }, new Option(false, new String[]{"-h", "-help", "--help", "-?"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.help = true;
        }
    }, new HiddenOption(false, new String[]{"-trace"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.trace = true;
        }
    }, new Option(false, new String[]{"-version"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.version = true;
        }
    }, new HiddenOption(false, new String[]{"-fullversion"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.fullVersion = true;
        }
    }, new Option(false, new String[]{"-jni"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.jni = true;
        }
    }, new Option(false, new String[]{"-force"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.force = true;
        }
    }, new HiddenOption(false, new String[]{"-Xnew"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
        }
    }, new HiddenOption(false, new String[]{"-llni", "-Xllni"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.llni = true;
        }
    }, new HiddenOption(false, new String[]{"-llnidouble"}){

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.llni = true;
            task.doubleAlign = true;
        }
    }, new HiddenOption(false, new String[0]){

        @Override
        boolean matches(String opt) {
            return opt.startsWith("-XD");
        }

        @Override
        void process(JavahTask task, String opt, String arg) {
            task.javac_extras.add(opt);
        }
    }};
    private static final String versionRBName = "com.sun.tools.javah.resources.version";
    private static ResourceBundle versionRB;
    File ofile;
    File odir;
    String bootcp;
    String usercp;
    List<String> classes;
    boolean verbose;
    boolean noArgs;
    boolean help;
    boolean trace;
    boolean version;
    boolean fullVersion;
    boolean jni;
    boolean llni;
    boolean doubleAlign;
    boolean force;
    Set<String> javac_extras = new LinkedHashSet<String>();
    PrintWriter log;
    JavaFileManager fileManager;
    DiagnosticListener<? super JavaFileObject> diagnosticListener;
    Locale task_locale;
    Map<Locale, ResourceBundle> bundles;
    private static final String progname = "javah";

    JavahTask() {
    }

    JavahTask(Writer out, JavaFileManager fileManager, DiagnosticListener<? super JavaFileObject> diagnosticListener, Iterable<String> options, Iterable<String> classes) {
        this();
        this.log = JavahTask.getPrintWriterForWriter(out);
        this.fileManager = fileManager;
        this.diagnosticListener = diagnosticListener;
        try {
            this.handleOptions(options, false);
        }
        catch (BadArgs e) {
            throw new IllegalArgumentException(e.getMessage());
        }
        this.classes = new ArrayList<String>();
        if (classes != null) {
            for (String classname : classes) {
                Objects.requireNonNull(classname);
                this.classes.add(classname);
            }
        }
    }

    @Override
    public void setLocale(Locale locale) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.task_locale = locale;
    }

    public void setLog(PrintWriter log) {
        this.log = log;
    }

    public void setLog(OutputStream s) {
        this.setLog(JavahTask.getPrintWriterForStream(s));
    }

    static PrintWriter getPrintWriterForStream(OutputStream s) {
        return new PrintWriter(s, true);
    }

    static PrintWriter getPrintWriterForWriter(Writer w) {
        if (w == null) {
            return JavahTask.getPrintWriterForStream(null);
        }
        if (w instanceof PrintWriter) {
            return (PrintWriter)w;
        }
        return new PrintWriter(w, true);
    }

    public void setDiagnosticListener(DiagnosticListener<? super JavaFileObject> dl) {
        this.diagnosticListener = dl;
    }

    public void setDiagnosticListener(OutputStream s) {
        this.setDiagnosticListener(this.getDiagnosticListenerForStream(s));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForStream(OutputStream s) {
        return this.getDiagnosticListenerForWriter(JavahTask.getPrintWriterForStream(s));
    }

    private DiagnosticListener<JavaFileObject> getDiagnosticListenerForWriter(Writer w) {
        final PrintWriter pw = JavahTask.getPrintWriterForWriter(w);
        return new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                if (diagnostic.getKind() == Diagnostic.Kind.ERROR) {
                    pw.print(JavahTask.this.getMessage("err.prefix", new Object[0]));
                    pw.print(" ");
                }
                pw.println(diagnostic.getMessage(null));
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int run(String[] args) {
        try {
            this.handleOptions(args);
            boolean ok = this.run();
            int n = ok ? 0 : 1;
            return n;
        }
        catch (BadArgs e) {
            this.diagnosticListener.report(this.createDiagnostic(e.key, e.args));
            int n = 1;
            return n;
        }
        catch (InternalError e) {
            this.diagnosticListener.report(this.createDiagnostic("err.internal.error", e.getMessage()));
            int n = 1;
            return n;
        }
        catch (Util.Exit e) {
            int n = e.exitValue;
            return n;
        }
        finally {
            this.log.flush();
        }
    }

    public void handleOptions(String[] args) throws BadArgs {
        this.handleOptions(Arrays.asList(args), true);
    }

    private void handleOptions(Iterable<String> args, boolean allowClasses) throws BadArgs {
        Iterator<String> iter;
        if (this.log == null) {
            this.log = JavahTask.getPrintWriterForStream(System.out);
            if (this.diagnosticListener == null) {
                this.diagnosticListener = this.getDiagnosticListenerForStream(System.err);
            }
        } else if (this.diagnosticListener == null) {
            this.diagnosticListener = this.getDiagnosticListenerForWriter(this.log);
        }
        if (this.fileManager == null) {
            this.fileManager = JavahTask.getDefaultFileManager(this.diagnosticListener, this.log);
        }
        boolean bl = this.noArgs = !(iter = this.expandAtArgs(args).iterator()).hasNext();
        while (iter.hasNext()) {
            String arg = iter.next();
            if (arg.startsWith("-")) {
                this.handleOption(arg, iter);
                continue;
            }
            if (allowClasses) {
                if (this.classes == null) {
                    this.classes = new ArrayList<String>();
                }
                this.classes.add(arg);
                while (iter.hasNext()) {
                    this.classes.add(iter.next());
                }
                continue;
            }
            throw new BadArgs("err.unknown.option", arg).showUsage(true);
        }
        if (!(this.classes != null && this.classes.size() != 0 || this.noArgs || this.help || this.version || this.fullVersion)) {
            throw new BadArgs("err.no.classes.specified", new Object[0]);
        }
        if (this.jni && this.llni) {
            throw new BadArgs("jni.llni.mixed", new Object[0]);
        }
        if (this.odir != null && this.ofile != null) {
            throw new BadArgs("dir.file.mixed", new Object[0]);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void handleOption(String name, Iterator<String> rest) throws BadArgs {
        for (Option o : recognizedOptions) {
            if (!o.matches(name)) continue;
            if (o.hasArg) {
                if (!rest.hasNext()) throw new BadArgs("err.missing.arg", name).showUsage(true);
                o.process(this, name, rest.next());
            } else {
                o.process(this, name, null);
            }
            if (!o.ignoreRest()) return;
            while (rest.hasNext()) {
                rest.next();
            }
            return;
        }
        if (!this.fileManager.handleOption(name, rest)) throw new BadArgs("err.unknown.option", name).showUsage(true);
    }

    private Iterable<String> expandAtArgs(Iterable<String> args) throws BadArgs {
        try {
            ArrayList<String> l = new ArrayList<String>();
            for (String arg : args) {
                l.add(arg);
            }
            return Arrays.asList(CommandLine.parse(l.toArray(new String[l.size()])));
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            throw new BadArgs("at.args.file.not.found", e.getLocalizedMessage());
        }
        catch (IOException e) {
            throw new BadArgs("at.args.io.exception", e.getLocalizedMessage());
        }
    }

    @Override
    public Boolean call() {
        return this.run();
    }

    public boolean run() throws Util.Exit {
        Util util = new Util(this.log, this.diagnosticListener);
        if (this.noArgs || this.help) {
            this.showHelp();
            return this.help;
        }
        if (this.version || this.fullVersion) {
            this.showVersion(this.fullVersion);
            return true;
        }
        util.verbose = this.verbose;
        Gen g = this.llni ? new LLNI(this.doubleAlign, util) : new JNI(util);
        if (this.ofile != null) {
            if (!(this.fileManager instanceof StandardJavaFileManager)) {
                this.diagnosticListener.report(this.createDiagnostic("err.cant.use.option.for.fm", "-o"));
                return false;
            }
            Iterable<? extends JavaFileObject> iter = ((StandardJavaFileManager)this.fileManager).getJavaFileObjectsFromFiles(Collections.singleton(this.ofile));
            JavaFileObject fo = iter.iterator().next();
            g.setOutFile(fo);
        } else {
            if (this.odir != null) {
                if (!(this.fileManager instanceof StandardJavaFileManager)) {
                    this.diagnosticListener.report(this.createDiagnostic("err.cant.use.option.for.fm", "-d"));
                    return false;
                }
                if (!this.odir.exists() && !this.odir.mkdirs()) {
                    util.error("cant.create.dir", this.odir.toString());
                }
                try {
                    ((StandardJavaFileManager)this.fileManager).setLocation(StandardLocation.CLASS_OUTPUT, Collections.singleton(this.odir));
                }
                catch (IOException e) {
                    Object msg = e.getLocalizedMessage();
                    if (msg == null) {
                        msg = e;
                    }
                    this.diagnosticListener.report(this.createDiagnostic("err.ioerror", this.odir, msg));
                    return false;
                }
            }
            g.setFileManager(this.fileManager);
        }
        g.setForce(this.force);
        if (this.fileManager instanceof JavahFileManager) {
            ((JavahFileManager)this.fileManager).setSymbolFileEnabled(false);
        }
        JavaCompiler c = ToolProvider.getSystemJavaCompiler();
        ArrayList<String> opts = new ArrayList<String>();
        opts.add("-proc:only");
        opts.addAll(this.javac_extras);
        JavaCompiler.CompilationTask t = c.getTask(this.log, this.fileManager, this.diagnosticListener, opts, this.classes, null);
        JavahProcessor p = new JavahProcessor(g);
        t.setProcessors(Collections.singleton(p));
        boolean ok = t.call();
        if (p.exit != null) {
            throw new Util.Exit(p.exit);
        }
        return ok;
    }

    private List<File> pathToFiles(String path) {
        ArrayList<File> files = new ArrayList<File>();
        for (String f : path.split(File.pathSeparator)) {
            if (f.length() <= 0) continue;
            files.add(new File(f));
        }
        return files;
    }

    static StandardJavaFileManager getDefaultFileManager(DiagnosticListener<? super JavaFileObject> dl, PrintWriter log) {
        return JavahFileManager.create(dl, log);
    }

    private void showHelp() {
        String[] fmOptions;
        this.log.println(this.getMessage("main.usage", progname));
        for (Option o : recognizedOptions) {
            if (o.isHidden()) continue;
            String name = o.aliases[0].substring(1);
            this.log.println(this.getMessage("main.opt." + name, new Object[0]));
        }
        for (String o : fmOptions = new String[]{"-classpath", "-cp", "-bootclasspath"}) {
            if (this.fileManager.isSupportedOption(o) == -1) continue;
            String name = o.substring(1);
            this.log.println(this.getMessage("main.opt." + name, new Object[0]));
        }
        this.log.println(this.getMessage("main.usage.foot", new Object[0]));
    }

    private void showVersion(boolean full) {
        this.log.println(this.version(full));
    }

    private String version(boolean full) {
        String versionKey;
        String msgKey = full ? "javah.fullVersion" : "javah.version";
        String string = versionKey = full ? "full" : "release";
        if (versionRB == null) {
            try {
                versionRB = ResourceBundle.getBundle(versionRBName);
            }
            catch (MissingResourceException e) {
                return this.getMessage("version.resource.missing", System.getProperty("java.version"));
            }
        }
        try {
            return this.getMessage(msgKey, progname, versionRB.getString(versionKey));
        }
        catch (MissingResourceException e) {
            return this.getMessage("version.unknown", System.getProperty("java.version"));
        }
    }

    private Diagnostic<JavaFileObject> createDiagnostic(final String key, final Object ... args) {
        return new Diagnostic<JavaFileObject>(){

            @Override
            public Diagnostic.Kind getKind() {
                return Diagnostic.Kind.ERROR;
            }

            @Override
            public JavaFileObject getSource() {
                return null;
            }

            @Override
            public long getPosition() {
                return -1L;
            }

            @Override
            public long getStartPosition() {
                return -1L;
            }

            @Override
            public long getEndPosition() {
                return -1L;
            }

            @Override
            public long getLineNumber() {
                return -1L;
            }

            @Override
            public long getColumnNumber() {
                return -1L;
            }

            @Override
            public String getCode() {
                return key;
            }

            @Override
            public String getMessage(Locale locale) {
                return JavahTask.this.getMessage(locale, key, args);
            }
        };
    }

    private String getMessage(String key, Object ... args) {
        return this.getMessage(this.task_locale, key, args);
    }

    private String getMessage(Locale locale, String key, Object ... args) {
        ResourceBundle b;
        if (this.bundles == null) {
            this.bundles = new HashMap<Locale, ResourceBundle>();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        if ((b = this.bundles.get(locale)) == null) {
            try {
                b = ResourceBundle.getBundle("com.sun.tools.javah.resources.l10n", locale);
                this.bundles.put(locale, b);
            }
            catch (MissingResourceException e) {
                throw new InternalError("Cannot find javah resource bundle for locale " + locale, e);
            }
        }
        try {
            return MessageFormat.format(b.getString(key), args);
        }
        catch (MissingResourceException e) {
            return key;
        }
    }

    @SupportedAnnotationTypes(value={"*"})
    class JavahProcessor
    extends AbstractProcessor {
        private Messager messager;
        private TypeVisitor<Void, Types> checkMethodParametersVisitor = new SimpleTypeVisitor9<Void, Types>(){

            @Override
            public Void visitArray(ArrayType t, Types types) {
                this.visit(t.getComponentType(), types);
                return null;
            }

            @Override
            public Void visitDeclared(DeclaredType t, Types types) {
                t.asElement().getKind();
                for (TypeMirror typeMirror : types.directSupertypes(t)) {
                    this.visit(typeMirror, types);
                }
                return null;
            }
        };
        private Gen g;
        private Util.Exit exit;

        JavahProcessor(Gen g) {
            this.g = g;
        }

        @Override
        public SourceVersion getSupportedSourceVersion() {
            return SourceVersion.latest();
        }

        @Override
        public void init(ProcessingEnvironment pEnv) {
            super.init(pEnv);
            this.messager = this.processingEnv.getMessager();
        }

        @Override
        public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
            try {
                Set<TypeElement> classes = this.getAllClasses(ElementFilter.typesIn(roundEnv.getRootElements()));
                if (classes.size() > 0) {
                    this.checkMethodParameters(classes);
                    this.g.setProcessingEnvironment(this.processingEnv);
                    this.g.setClasses(classes);
                    this.g.run();
                }
            }
            catch (Symbol.CompletionFailure cf) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("class.not.found", new Object[]{cf.sym.getQualifiedName().toString()}));
            }
            catch (ClassNotFoundException cnfe) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("class.not.found", new Object[]{cnfe.getMessage()}));
            }
            catch (IOException ioe) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, JavahTask.this.getMessage("io.exception", new Object[]{ioe.getMessage()}));
            }
            catch (Util.Exit e) {
                this.exit = e;
            }
            return true;
        }

        private Set<TypeElement> getAllClasses(Set<? extends TypeElement> classes) {
            LinkedHashSet<TypeElement> allClasses = new LinkedHashSet<TypeElement>();
            this.getAllClasses0(classes, allClasses);
            return allClasses;
        }

        private void getAllClasses0(Iterable<? extends TypeElement> classes, Set<TypeElement> allClasses) {
            for (TypeElement typeElement : classes) {
                allClasses.add(typeElement);
                this.getAllClasses0(ElementFilter.typesIn(typeElement.getEnclosedElements()), allClasses);
            }
        }

        private void checkMethodParameters(Set<TypeElement> classes) {
            Types types = this.processingEnv.getTypeUtils();
            for (TypeElement te : classes) {
                for (ExecutableElement ee : ElementFilter.methodsIn(te.getEnclosedElements())) {
                    for (VariableElement variableElement : ee.getParameters()) {
                        TypeMirror tm = variableElement.asType();
                        this.checkMethodParametersVisitor.visit(tm, types);
                    }
                }
            }
        }
    }

    static abstract class HiddenOption
    extends Option {
        HiddenOption(boolean hasArg, String ... aliases) {
            super(hasArg, aliases);
        }

        @Override
        boolean isHidden() {
            return true;
        }
    }

    static abstract class Option {
        final boolean hasArg;
        final String[] aliases;

        Option(boolean hasArg, String ... aliases) {
            this.hasArg = hasArg;
            this.aliases = aliases;
        }

        boolean isHidden() {
            return false;
        }

        boolean matches(String opt) {
            for (String a : this.aliases) {
                if (!a.equals(opt)) continue;
                return true;
            }
            return false;
        }

        boolean ignoreRest() {
            return false;
        }

        abstract void process(JavahTask var1, String var2, String var3) throws BadArgs;
    }

    public class BadArgs
    extends Exception {
        private static final long serialVersionUID = 1479361270874789045L;
        final String key;
        final Object[] args;
        boolean showUsage;

        BadArgs(String key, Object ... args) {
            super(JavahTask.this.getMessage(key, args));
            this.key = key;
            this.args = args;
        }

        BadArgs showUsage(boolean b) {
            this.showUsage = b;
            return this;
        }
    }
}

