/*
 * Decompiled with CFR 0.152.
 */
package com.sun.source.util;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.util.DocTreePathScanner;
import com.sun.source.util.TreePath;
import java.util.Iterator;
import java.util.Objects;
import jdk.Exported;

@Exported
public class DocTreePath
implements Iterable<DocTree> {
    private final TreePath treePath;
    private final DocCommentTree docComment;
    private final DocTree leaf;
    private final DocTreePath parent;

    public static DocTreePath getPath(TreePath treePath, DocCommentTree doc, DocTree target) {
        return DocTreePath.getPath(new DocTreePath(treePath, doc), target);
    }

    public static DocTreePath getPath(DocTreePath path, DocTree target) {
        class Result
        extends Error {
            static final long serialVersionUID = -5942088234594905625L;
            DocTreePath path;

            Result(DocTreePath path) {
                this.path = path;
            }
        }
        Objects.requireNonNull(path);
        Objects.requireNonNull(target);
        if (path.getLeaf() == target) {
            return path;
        }
        try {
            class PathFinder
            extends DocTreePathScanner<DocTreePath, DocTree> {
                PathFinder() {
                }

                @Override
                public DocTreePath scan(DocTree tree, DocTree target) {
                    if (tree == target) {
                        throw new Result(new DocTreePath(this.getCurrentPath(), target));
                    }
                    return (DocTreePath)super.scan(tree, target);
                }
            }
            new PathFinder().scan(path, target);
        }
        catch (Result result) {
            return result.path;
        }
        return null;
    }

    public DocTreePath(TreePath treePath, DocCommentTree t) {
        this.treePath = Objects.requireNonNull(treePath);
        this.docComment = Objects.requireNonNull(t);
        this.parent = null;
        this.leaf = t;
    }

    public DocTreePath(DocTreePath p, DocTree t) {
        if (t.getKind() == DocTree.Kind.DOC_COMMENT) {
            throw new IllegalArgumentException("Use DocTreePath(TreePath, DocCommentTree) to construct DocTreePath for a DocCommentTree.");
        }
        this.treePath = p.treePath;
        this.docComment = p.docComment;
        this.parent = p;
        this.leaf = t;
    }

    public TreePath getTreePath() {
        return this.treePath;
    }

    public DocCommentTree getDocComment() {
        return this.docComment;
    }

    public DocTree getLeaf() {
        return this.leaf;
    }

    public DocTreePath getParentPath() {
        return this.parent;
    }

    @Override
    public Iterator<DocTree> iterator() {
        return new Iterator<DocTree>(){
            private DocTreePath next;
            {
                this.next = DocTreePath.this;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }

            @Override
            public DocTree next() {
                DocTree t = this.next.leaf;
                this.next = this.next.parent;
                return t;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }
}

