/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.util;

import com.hazelcast.util.MutableLong;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class ItemCounter<T> {
    private final Map<T, MutableLong> map = new HashMap<T, MutableLong>();

    public Set<T> keySet() {
        return this.map.keySet();
    }

    public long get(T item) {
        MutableLong count = this.map.get(item);
        return count == null ? 0L : count.value;
    }

    public void set(T item, long value) {
        MutableLong entry = this.map.get(item);
        if (entry == null) {
            entry = MutableLong.valueOf(value);
            this.map.put(item, entry);
        } else {
            entry.value = value;
        }
    }

    public void add(T item, long delta) {
        MutableLong entry = this.map.get(item);
        if (entry == null) {
            entry = MutableLong.valueOf(delta);
            this.map.put(item, entry);
        } else {
            entry.value += delta;
        }
    }

    public void reset() {
        for (MutableLong entry : this.map.values()) {
            entry.value = 0L;
        }
    }

    public long getAndSet(T item, long value) {
        MutableLong entry = this.map.get(item);
        if (entry == null) {
            entry = MutableLong.valueOf(value);
            this.map.put(item, entry);
            return 0L;
        }
        long oldValue = entry.value;
        entry.value = value;
        return oldValue;
    }

    public void remove(T item) {
        this.map.remove(item);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemCounter that = (ItemCounter)o;
        return this.map.equals(that.map);
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return this.map.toString();
    }
}

