/*
 * Decompiled with CFR 0.152.
 */
package com.google.instrumentation.trace;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.instrumentation.common.Timestamp;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class NetworkEvent {
    private final Timestamp kernelTimestamp;
    private final Type type;
    private final long messageId;
    private final long messageSize;

    private NetworkEvent(@Nullable Timestamp kernelTimestamp, Type type, long messageId, long messageSize) {
        this.kernelTimestamp = kernelTimestamp;
        this.type = type;
        this.messageId = messageId;
        this.messageSize = messageSize;
    }

    public static Builder builder(Type type, long messageId) {
        return new Builder(type, messageId);
    }

    @Nullable
    public Timestamp getKernelTimestamp() {
        return this.kernelTimestamp;
    }

    public Type getType() {
        return this.type;
    }

    public long getMessageId() {
        return this.messageId;
    }

    public long getMessageSize() {
        return this.messageSize;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("kernelTimestamp", (Object)this.kernelTimestamp).add("type", (Object)this.type).add("messageId", this.messageId).add("messageSize", this.messageSize).toString();
    }

    public static final class Builder {
        private final Type type;
        private final long messageId;
        private Timestamp kernelTimestamp;
        private long messageSize;

        private Builder(Type type, long messageId) {
            this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type), (Object)"type"));
            this.messageId = messageId;
        }

        public Builder setKernelTimestamp(@Nullable Timestamp kernelTimestamp) {
            this.kernelTimestamp = kernelTimestamp;
            return this;
        }

        public Builder setMessageSize(long messageSize) {
            this.messageSize = messageSize;
            return this;
        }

        public NetworkEvent build() {
            return new NetworkEvent(this.kernelTimestamp, this.type, this.messageId, this.messageSize);
        }
    }

    public static enum Type {
        SENT,
        RECV;

    }
}

