/*
 * Decompiled with CFR 0.152.
 */
package lombok.ast.printer;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.List;
import java.util.Stack;
import lombok.ast.Node;
import lombok.ast.printer.SourceFormatter;

public class TextFormatter
implements SourceFormatter {
    private static final String INDENT = "    ";
    private String newlineText = "\n";
    private final StringBuilder sb = new StringBuilder();
    private final List<String> errors = Lists.newArrayList();
    private int indent;
    private boolean suppress;
    private boolean newline;
    private Stack<Integer> blockSuppressedStack = new Stack();

    protected void setNewlineText(String newlineText) {
        this.newlineText = newlineText;
    }

    private TextFormatter a(String text) {
        if (text == null || text.length() == 0) {
            return this;
        }
        if (this.newline) {
            this.printIndent();
        }
        this.newline = false;
        this.sb.append(text);
        return this;
    }

    protected int getCurrentPosition(boolean accountForNewline) {
        int len = this.sb.length();
        if (accountForNewline && this.newline) {
            if (len > 0) {
                len += this.newlineText.length();
            }
            len += INDENT.length() * this.indent;
        }
        return len;
    }

    @Override
    public void fail(String fail) {
        this.a("?!?").a(fail).a("?!?");
    }

    @Override
    public void property(String name, Object value) {
    }

    @Override
    public void keyword(String text) {
        this.a(text);
    }

    @Override
    public void operator(String text) {
        this.a(text);
    }

    @Override
    public void verticalSpace() {
        this.printIndent();
    }

    @Override
    public void space() {
        this.a(" ");
    }

    @Override
    public void append(String text) {
        this.a(text);
    }

    @Override
    public void buildInline(Node node) {
    }

    @Override
    public void closeInline() {
    }

    @Override
    public void startSuppressBlock() {
        this.suppress = true;
    }

    @Override
    public void endSuppressBlock() {
        this.suppress = false;
    }

    @Override
    public void startSuppressIndent() {
        --this.indent;
    }

    @Override
    public void endSuppressIndent() {
        ++this.indent;
    }

    private void printIndent() {
        if (this.sb.length() > 0) {
            this.sb.append(this.newlineText);
        }
        for (int i = 0; i < this.indent; ++i) {
            this.sb.append(INDENT);
        }
    }

    @Override
    public void buildBlock(Node node) {
        this.blockSuppressedStack.push((this.suppress ? 1 : 0) | (node == null ? 2 : 0));
        if (!this.suppress) {
            this.newline = true;
            if (node == null) {
                ++this.indent;
            }
        }
        this.suppress = false;
    }

    @Override
    public void closeBlock() {
        int code = this.blockSuppressedStack.pop();
        if ((code & 2) > 0) {
            --this.indent;
        }
        if ((code & 1) == 0) {
            this.newline = true;
        }
    }

    @Override
    public void addError(int errorStart, int errorEnd, String errorMessage) {
        this.errors.add(String.format("%d-%d: %s", errorStart, errorEnd, errorMessage));
    }

    @Override
    public String finish() {
        if (!this.errors.isEmpty()) {
            this.a(this.newlineText).a(this.newlineText).a(this.newlineText).a("ERRORS: ").a(this.newlineText);
            this.a(Joiner.on((String)this.newlineText).join(this.errors));
            this.errors.clear();
        }
        return this.sb.toString();
    }

    @Override
    public void setTimeTaken(long taken) {
    }

    @Override
    public void nameNextElement(String name) {
    }
}

