/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.names;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class NamingConventions {
    private static final Pattern ONLY_UNDERSCORES = Pattern.compile("^_+$");
    private static final String UNDERSCORE = "_";
    private static final String CASE_TRANSITION = "(?<=[a-z0-9])(?=[A-Z])";
    private static final String TRAILING_DIGITS = "(?<![0-9_])(?=[0-9]+$)";
    private static final Pattern TERM_SPLITTER = Pattern.compile(String.format("%s|%s|%s", "_", "(?<=[a-z0-9])(?=[A-Z])", "(?<![0-9_])(?=[0-9]+$)"));

    public static ImmutableList<String> splitToLowercaseTerms(String identifierName) {
        if (ONLY_UNDERSCORES.matcher(identifierName).matches()) {
            return ImmutableList.of((Object)identifierName);
        }
        return (ImmutableList)Arrays.stream(TERM_SPLITTER.split(identifierName)).map(String::toLowerCase).collect(ImmutableList.toImmutableList());
    }

    public static String convertToLowerUnderscore(String identifierName) {
        return NamingConventions.splitToLowercaseTerms(identifierName).stream().collect(Collectors.joining(UNDERSCORE));
    }
}

