/*
 * Decompiled with CFR 0.152.
 */
package com.google.monitoring.runtime.instrumentation;

import com.google.monitoring.runtime.instrumentation.AllocationClassAdapter;
import com.google.monitoring.runtime.instrumentation.AllocationRecorder;
import com.google.monitoring.runtime.instrumentation.ConstructorInstrumenter;
import com.google.monitoring.runtime.instrumentation.StaticClassWriter;
import com.google.monitoring.runtime.instrumentation.VerifyingClassAdapter;
import com.google.monitoring.runtime.instrumentation.asm.ClassReader;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;

public class AllocationInstrumenter
implements ClassFileTransformer {
    static final Logger logger = Logger.getLogger(AllocationInstrumenter.class.getName());
    private static volatile boolean canRewriteBootstrap;

    static boolean canRewriteClass(String className, ClassLoader loader) {
        if (loader == null && !canRewriteBootstrap || className.startsWith("java/lang/ThreadLocal")) {
            return false;
        }
        return !className.startsWith("ognl/");
    }

    AllocationInstrumenter() {
    }

    public static void premain(String agentArgs, Instrumentation inst) {
        AllocationRecorder.setInstrumentation(inst);
        try {
            Class.forName("sun.security.provider.PolicyFile");
            Class.forName("java.util.ResourceBundle");
            Class.forName("java.util.Date");
        }
        catch (Throwable t) {
            // empty catch block
        }
        if (!inst.isRetransformClassesSupported()) {
            System.err.println("Some JDK classes are already loaded and will not be instrumented.");
        }
        if (AllocationRecorder.class.getClassLoader() != null) {
            canRewriteBootstrap = false;
            System.err.println("Class loading breakage: Will not be able to instrument JDK classes");
            return;
        }
        canRewriteBootstrap = true;
        List<String> args = Arrays.asList(agentArgs == null ? new String[]{} : agentArgs.split(","));
        ConstructorInstrumenter.subclassesAlso = args.contains("subclassesAlso");
        inst.addTransformer(new ConstructorInstrumenter(), inst.isRetransformClassesSupported());
        if (!args.contains("manualOnly")) {
            AllocationInstrumenter.bootstrap(inst);
        }
    }

    private static void bootstrap(Instrumentation inst) {
        inst.addTransformer(new AllocationInstrumenter(), inst.isRetransformClassesSupported());
        if (!canRewriteBootstrap) {
            return;
        }
        Class[] classes = inst.getAllLoadedClasses();
        ArrayList<Class> classList = new ArrayList<Class>();
        for (int i = 0; i < classes.length; ++i) {
            if (!inst.isModifiableClass(classes[i])) continue;
            classList.add(classes[i]);
        }
        Class[] workaround = new Class[classList.size()];
        try {
            inst.retransformClasses(classList.toArray(workaround));
        }
        catch (UnmodifiableClassException e) {
            System.err.println("AllocationInstrumenter was unable to retransform early loaded classes.");
        }
    }

    @Override
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] origBytes) {
        if (!AllocationInstrumenter.canRewriteClass(className, loader)) {
            return null;
        }
        return AllocationInstrumenter.instrument(origBytes, loader);
    }

    public static byte[] instrument(byte[] originalBytes, String recorderClass, String recorderMethod, ClassLoader loader) {
        try {
            ClassReader cr = new ClassReader(originalBytes);
            StaticClassWriter cw = new StaticClassWriter(cr, 2, loader);
            VerifyingClassAdapter vcw = new VerifyingClassAdapter(cw, originalBytes, cr.getClassName());
            AllocationClassAdapter adapter = new AllocationClassAdapter(vcw, recorderClass, recorderMethod);
            cr.accept(adapter, 4);
            return vcw.toByteArray();
        }
        catch (RuntimeException e) {
            logger.log(Level.WARNING, "Failed to instrument class.", e);
            throw e;
        }
        catch (Error e) {
            logger.log(Level.WARNING, "Failed to instrument class.", e);
            throw e;
        }
    }

    public static byte[] instrument(byte[] originalBytes, ClassLoader loader) {
        return AllocationInstrumenter.instrument(originalBytes, "com/google/monitoring/runtime/instrumentation/AllocationRecorder", "recordAllocation", loader);
    }
}

