/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.binder;

import com.google.common.base.Joiner;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.ConstEvaluator;
import com.google.turbine.binder.Resolve;
import com.google.turbine.binder.bound.ModuleInfo;
import com.google.turbine.binder.bound.PackageSourceBoundModule;
import com.google.turbine.binder.bound.SourceModuleInfo;
import com.google.turbine.binder.bound.TypeBoundClass;
import com.google.turbine.binder.env.CompoundEnv;
import com.google.turbine.binder.env.Env;
import com.google.turbine.binder.env.SimpleEnv;
import com.google.turbine.binder.lookup.CompoundScope;
import com.google.turbine.binder.lookup.LookupKey;
import com.google.turbine.binder.lookup.LookupResult;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.binder.sym.FieldSymbol;
import com.google.turbine.binder.sym.ModuleSymbol;
import com.google.turbine.diag.TurbineError;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import com.google.turbine.tree.TurbineModifier;
import com.google.turbine.type.AnnoInfo;
import java.util.Optional;

public class ModuleBinder {
    private final PackageSourceBoundModule module;
    private final CompoundEnv<ClassSymbol, TypeBoundClass> env;
    private final Env<ModuleSymbol, ModuleInfo> moduleEnv;
    private final Optional<String> moduleVersion;
    private final CompoundScope scope;

    public static SourceModuleInfo bind(PackageSourceBoundModule module, CompoundEnv<ClassSymbol, TypeBoundClass> env, Env<ModuleSymbol, ModuleInfo> moduleEnv, Optional<String> moduleVersion) {
        return new ModuleBinder(module, env, moduleEnv, moduleVersion).bind();
    }

    public ModuleBinder(PackageSourceBoundModule module, CompoundEnv<ClassSymbol, TypeBoundClass> env, Env<ModuleSymbol, ModuleInfo> moduleEnv, Optional<String> moduleVersion) {
        this.module = module;
        this.env = env;
        this.moduleEnv = moduleEnv;
        this.moduleVersion = moduleVersion;
        this.scope = module.scope().toScope(Resolve.resolveFunction(env, null));
    }

    private SourceModuleInfo bind() {
        ConstEvaluator constEvaluator = new ConstEvaluator(null, null, this.module.memberImports(), this.module.source(), this.scope, new SimpleEnv<FieldSymbol, Const.Value>(ImmutableMap.of()), this.env);
        ImmutableList.Builder annoInfos = ImmutableList.builder();
        for (Tree.Anno annoTree : this.module.module().annos()) {
            ClassSymbol sym = this.resolve(annoTree.position(), annoTree.name());
            annoInfos.add((Object)new AnnoInfo(this.module.source(), sym, annoTree, null));
        }
        ImmutableList<AnnoInfo> annos = constEvaluator.evaluateAnnotations((ImmutableList<AnnoInfo>)annoInfos.build());
        int flags = this.module.module().open() ? 32 : 0;
        ImmutableList.Builder requires = ImmutableList.builder();
        ImmutableList.Builder exports = ImmutableList.builder();
        ImmutableList.Builder opens = ImmutableList.builder();
        ImmutableList.Builder uses = ImmutableList.builder();
        ImmutableList.Builder provides = ImmutableList.builder();
        boolean requiresJavaBase = false;
        block8: for (Tree.ModDirective directive : this.module.module().directives()) {
            switch (directive.directiveKind()) {
                case REQUIRES: {
                    Tree.ModRequires require = (Tree.ModRequires)directive;
                    requiresJavaBase |= require.moduleName().equals(ModuleSymbol.JAVA_BASE.name());
                    requires.add((Object)this.bindRequires(require));
                    continue block8;
                }
                case EXPORTS: {
                    exports.add((Object)this.bindExports((Tree.ModExports)directive));
                    continue block8;
                }
                case OPENS: {
                    opens.add((Object)this.bindOpens((Tree.ModOpens)directive));
                    continue block8;
                }
                case USES: {
                    uses.add((Object)this.bindUses((Tree.ModUses)directive));
                    continue block8;
                }
                case PROVIDES: {
                    provides.add((Object)this.bindProvides((Tree.ModProvides)directive));
                    continue block8;
                }
            }
            throw new AssertionError((Object)directive.kind());
        }
        if (!requiresJavaBase) {
            ModuleInfo javaBaseModule = this.moduleEnv.get(ModuleSymbol.JAVA_BASE);
            Verify.verifyNotNull((Object)javaBaseModule, (String)ModuleSymbol.JAVA_BASE.name(), (Object[])new Object[0]);
            requires = ImmutableList.builder().add((Object)new ModuleInfo.RequireInfo(ModuleSymbol.JAVA_BASE.name(), 32768, javaBaseModule.version())).addAll((Iterable)requires.build());
        }
        return new SourceModuleInfo(this.module.module().moduleName(), this.moduleVersion.orElse(null), flags, annos, (ImmutableList<ModuleInfo.RequireInfo>)requires.build(), (ImmutableList<ModuleInfo.ExportInfo>)exports.build(), (ImmutableList<ModuleInfo.OpenInfo>)opens.build(), (ImmutableList<ModuleInfo.UseInfo>)uses.build(), (ImmutableList<ModuleInfo.ProvideInfo>)provides.build(), this.module.source());
    }

    private ModuleInfo.RequireInfo bindRequires(Tree.ModRequires directive) {
        String moduleName = directive.moduleName();
        int flags = 0;
        block4: for (TurbineModifier mod : directive.mods()) {
            switch (mod) {
                case TRANSITIVE: {
                    flags |= mod.flag();
                    continue block4;
                }
                case STATIC: {
                    flags |= 0x40;
                    continue block4;
                }
            }
            throw new AssertionError((Object)mod);
        }
        ModuleInfo requires = this.moduleEnv.get(new ModuleSymbol(moduleName));
        return new ModuleInfo.RequireInfo(moduleName, flags, requires != null ? requires.version() : null);
    }

    private ModuleInfo.ExportInfo bindExports(Tree.ModExports directive) {
        return new ModuleInfo.ExportInfo(directive.packageName(), directive.moduleNames());
    }

    private ModuleInfo.OpenInfo bindOpens(Tree.ModOpens directive) {
        return new ModuleInfo.OpenInfo(directive.packageName(), directive.moduleNames());
    }

    private ModuleInfo.UseInfo bindUses(Tree.ModUses directive) {
        return new ModuleInfo.UseInfo(this.resolve(directive.position(), directive.typeName()));
    }

    private ModuleInfo.ProvideInfo bindProvides(Tree.ModProvides directive) {
        ClassSymbol sym = this.resolve(directive.position(), directive.typeName());
        ImmutableList.Builder impls = ImmutableList.builder();
        for (ImmutableList impl : directive.implNames()) {
            impls.add((Object)this.resolve(directive.position(), (ImmutableList<Tree.Ident>)impl));
        }
        return new ModuleInfo.ProvideInfo(sym, (ImmutableList<ClassSymbol>)impls.build());
    }

    private ClassSymbol resolve(int pos, ImmutableList<Tree.Ident> simpleNames) {
        LookupKey key = new LookupKey(simpleNames);
        LookupResult result = this.scope.lookup(key);
        if (result == null) {
            throw this.error(TurbineError.ErrorKind.SYMBOL_NOT_FOUND, pos, new ClassSymbol(Joiner.on((char)'/').join(simpleNames)));
        }
        ClassSymbol sym = (ClassSymbol)result.sym();
        for (Tree.Ident name : result.remaining()) {
            if ((sym = Resolve.resolve(this.env, null, sym, name)) != null) continue;
            throw this.error(TurbineError.ErrorKind.SYMBOL_NOT_FOUND, pos, new ClassSymbol(sym.binaryName() + '$' + name));
        }
        return sym;
    }

    private TurbineError error(TurbineError.ErrorKind kind, int pos, Object ... args) {
        return TurbineError.format(this.module.source(), pos, kind, args);
    }
}

