/*
 * Decompiled with CFR 0.152.
 */
package javax.tools;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ServiceConfigurationError;
import java.util.ServiceLoader;
import javax.tools.DocumentationTool;
import javax.tools.JavaCompiler;

public class ToolProvider {
    private static final String systemJavaCompilerModule = "jdk.compiler";
    private static final String systemJavaCompilerName = "com.sun.tools.javac.api.JavacTool";
    private static final String systemDocumentationToolModule = "jdk.javadoc";
    private static final String systemDocumentationToolName = "jdk.javadoc.internal.api.JavadocTool";
    private static final boolean useLegacy;

    public static JavaCompiler getSystemJavaCompiler() {
        return ToolProvider.getSystemTool(JavaCompiler.class, systemJavaCompilerModule, systemJavaCompilerName);
    }

    public static DocumentationTool getSystemDocumentationTool() {
        return ToolProvider.getSystemTool(DocumentationTool.class, systemDocumentationToolModule, systemDocumentationToolName);
    }

    @Deprecated
    public static ClassLoader getSystemToolClassLoader() {
        return null;
    }

    private static <T> T getSystemTool(Class<T> clazz, String moduleName, String className) {
        if (useLegacy) {
            try {
                return Class.forName(className, true, ClassLoader.getSystemClassLoader()).asSubclass(clazz).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException e) {
                throw new Error(e);
            }
        }
        try {
            ServiceLoader<T> sl = ServiceLoader.load(clazz, ClassLoader.getSystemClassLoader());
            for (T tool : sl) {
                if (!ToolProvider.matches(tool, moduleName)) continue;
                return tool;
            }
        }
        catch (ServiceConfigurationError e) {
            throw new Error(e);
        }
        return null;
    }

    private static <T> boolean matches(T tool, String moduleName) {
        PrivilegedAction<Boolean> pa = () -> {
            try {
                Method getModuleMethod = Class.class.getDeclaredMethod("getModule", new Class[0]);
                Object toolModule = getModuleMethod.invoke(tool.getClass(), new Object[0]);
                Method getNameMethod = toolModule.getClass().getDeclaredMethod("getName", new Class[0]);
                String toolModuleName = (String)getNameMethod.invoke(toolModule, new Object[0]);
                return moduleName.equals(toolModuleName);
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                return false;
            }
        };
        return AccessController.doPrivileged(pa);
    }

    static {
        Class<?> c = null;
        try {
            c = Class.forName("java.lang.Module");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        useLegacy = c == null;
    }
}

