/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.LineMap;
import com.google.turbine.diag.SourceFile;

public class TurbineError
extends Error {
    private final ErrorKind kind;
    private final ImmutableList<Object> args;

    public static TurbineError format(SourceFile source, ErrorKind kind, Object ... args) {
        String path = (String)MoreObjects.firstNonNull((Object)source.path(), (Object)"<>");
        String message = kind.format(args);
        String diagnostic = path + ": error: " + message.trim() + System.lineSeparator();
        return new TurbineError(kind, diagnostic, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args));
    }

    public static TurbineError format(SourceFile source, int position, ErrorKind kind, Object ... args) {
        String path = (String)MoreObjects.firstNonNull((Object)source.path(), (Object)"<>");
        LineMap lineMap = LineMap.create(source.source());
        int lineNumber = lineMap.lineNumber(position);
        int column = lineMap.column(position);
        String message = kind.format(args);
        StringBuilder sb = new StringBuilder(path).append(":");
        sb.append(lineNumber).append(": error: ");
        sb.append(message.trim()).append(System.lineSeparator());
        sb.append(CharMatcher.breakingWhitespace().trimTrailingFrom((CharSequence)lineMap.line(position))).append(System.lineSeparator());
        sb.append(Strings.repeat((String)" ", (int)column)).append('^');
        String diagnostic = sb.toString();
        return new TurbineError(kind, diagnostic, (ImmutableList<Object>)ImmutableList.copyOf((Object[])args));
    }

    private TurbineError(ErrorKind kind, String diagnostic, ImmutableList<Object> args) {
        super(diagnostic);
        switch (kind) {
            case SYMBOL_NOT_FOUND: {
                Preconditions.checkArgument((args.size() == 1 && Iterables.getOnlyElement(args) instanceof ClassSymbol ? 1 : 0) != 0, (String)"diagnostic (%s) has invalid argument args %s", (Object)diagnostic, args);
                break;
            }
        }
        this.kind = kind;
        this.args = args;
    }

    public ErrorKind kind() {
        return this.kind;
    }

    public ImmutableList<Object> args() {
        return this.args;
    }

    public static enum ErrorKind {
        UNEXPECTED_INPUT("unexpected input: %c"),
        UNEXPECTED_IDENTIFIER("unexpected identifier '%s'"),
        UNEXPECTED_EOF("unexpected end of input"),
        EXPECTED_TOKEN("expected token %s"),
        INVALID_LITERAL("invalid literal: %s"),
        UNEXPECTED_TYPE_PARAMETER("unexpected type parameter %s"),
        SYMBOL_NOT_FOUND("symbol not found %s"),
        CLASS_FILE_NOT_FOUND("could not locate class file for %s"),
        TYPE_PARAMETER_QUALIFIER("type parameter used as type qualifier"),
        UNEXPECTED_TOKEN("unexpected token: %s"),
        INVALID_ANNOTATION_ARGUMENT("invalid annotation argument"),
        CANNOT_RESOLVE("could not resolve %s"),
        EXPRESSION_ERROR("could not evaluate constant expression"),
        CYCLIC_HIERARCHY("cycle in class hierarchy: %s"),
        NOT_AN_ANNOTATION("%s is not an annotation"),
        NONREPEATABLE_ANNOTATION("%s is not @Repeatable"),
        DUPLICATE_DECLARATION("duplicate declaration of %s"),
        BAD_MODULE_INFO("unexpected declaration found in module-info");

        private final String message;

        private ErrorKind(String message) {
            this.message = message;
        }

        String format(Object ... args) {
            return String.format(this.message, args);
        }
    }
}

