/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.Joiner;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.matchers.Description;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.Tree;
import java.util.ArrayList;

@BugPattern(name="MultipleTopLevelClasses", altNames={"TopLevel"}, summary="Source files should not contain multiple top-level class declarations", category=BugPattern.Category.JDK, severity=BugPattern.SeverityLevel.SUGGESTION, documentSuppression=false, linkType=BugPattern.LinkType.CUSTOM, tags={"Style"}, link="https://google.github.io/styleguide/javaguide.html#s3.4.1-one-top-level-class")
public class MultipleTopLevelClasses
extends BugChecker
implements BugChecker.CompilationUnitTreeMatcher {
    public Description matchCompilationUnit(CompilationUnitTree tree, VisitorState state) {
        if (tree.getTypeDecls().size() <= 1) {
            return Description.NO_MATCH;
        }
        if (tree.getPackageName() == null) {
            return Description.NO_MATCH;
        }
        ArrayList<String> names = new ArrayList<String>();
        for (Tree tree2 : tree.getTypeDecls()) {
            if (!(tree2 instanceof ClassTree)) continue;
            ClassTree classMember = (ClassTree)tree2;
            switch (classMember.getKind()) {
                case CLASS: 
                case INTERFACE: 
                case ANNOTATION_TYPE: 
                case ENUM: {
                    if (this.isSuppressed(classMember)) {
                        return Description.NO_MATCH;
                    }
                    names.add(classMember.getSimpleName().toString());
                    break;
                }
            }
        }
        if (names.size() <= 1) {
            return Description.NO_MATCH;
        }
        String message = String.format("Expected at most one top-level class declaration, instead found: %s", Joiner.on((String)", ").join(names));
        return this.buildDescription(tree.getPackageName()).setMessage(message).build();
    }
}

