/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect.testing.testers;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.testing.AbstractMapTester;
import com.google.common.collect.testing.Helpers;
import com.google.common.collect.testing.OneSizeTestContainerGenerator;
import com.google.common.collect.testing.features.CollectionSize;
import com.google.common.collect.testing.features.MapFeature;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;

@GwtIncompatible
public class NavigableMapNavigationTester<K, V>
extends AbstractMapTester<K, V> {
    private NavigableMap<K, V> navigableMap;
    private List<Map.Entry<K, V>> entries;
    private Map.Entry<K, V> a;
    private Map.Entry<K, V> b;
    private Map.Entry<K, V> c;

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.navigableMap = (NavigableMap)this.getMap();
        this.entries = Helpers.copyToList(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getSampleElements(((OneSizeTestContainerGenerator)this.getSubjectGenerator()).getCollectionSize().getNumElements()));
        Collections.sort(this.entries, Helpers.entryComparator(this.navigableMap.comparator()));
        if (this.entries.size() >= 1) {
            this.a = this.entries.get(0);
            if (this.entries.size() >= 3) {
                this.b = this.entries.get(1);
                this.c = this.entries.get(2);
            }
        }
    }

    private void resetWithHole() {
        Map.Entry[] entries = new Map.Entry[]{this.a, this.c};
        super.resetMap(entries);
        this.navigableMap = (NavigableMap)this.getMap();
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapFirst() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.firstEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapPollFirst() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.pollFirstEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapNearby() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.lowerEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.lowerKey(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.floorEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.floorKey(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.ceilingEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.ceilingKey(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.higherEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.higherKey(this.k0()));
    }

    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapLast() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.lastEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ZERO})
    public void testEmptyMapPollLast() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.pollLastEntry());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapFirst() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.firstEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapPollFirst() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.pollFirstEntry());
        NavigableMapNavigationTester.assertTrue((boolean)this.navigableMap.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapNearby() {
        NavigableMapNavigationTester.assertNull(this.navigableMap.lowerEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.lowerKey(this.k0()));
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(this.k0()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(this.k0()));
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.ceilingEntry(this.k0()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.ceilingKey(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.higherEntry(this.k0()));
        NavigableMapNavigationTester.assertNull(this.navigableMap.higherKey(this.k0()));
    }

    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapLast() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.lastEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.ONE})
    public void testSingletonMapPollLast() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.pollLastEntry());
        NavigableMapNavigationTester.assertTrue((boolean)this.navigableMap.isEmpty());
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFirst() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.firstEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollFirst() {
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.pollFirstEntry());
        NavigableMapNavigationTester.assertEquals(this.entries.subList(1, this.entries.size()), Helpers.copyToList(this.navigableMap.entrySet()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    public void testPollFirstUnsupported() {
        try {
            this.navigableMap.pollFirstEntry();
            NavigableMapNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLower() {
        this.resetWithHole();
        NavigableMapNavigationTester.assertEquals(null, this.navigableMap.lowerEntry(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(null, this.navigableMap.lowerKey(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.lowerEntry(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lowerKey(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.lowerEntry(this.c.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.lowerKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testFloor() {
        this.resetWithHole();
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.floorEntry(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.floorKey(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.floorEntry(this.c.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.floorKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testCeiling() {
        this.resetWithHole();
        NavigableMapNavigationTester.assertEquals(this.a, this.navigableMap.ceilingEntry(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.a.getKey(), this.navigableMap.ceilingKey(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.ceilingEntry(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.ceilingKey(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.ceilingEntry(this.c.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.ceilingKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testHigher() {
        this.resetWithHole();
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.higherEntry(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.higherKey(this.a.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.higherEntry(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(this.c.getKey(), this.navigableMap.higherKey(this.b.getKey()));
        NavigableMapNavigationTester.assertEquals(null, this.navigableMap.higherEntry(this.c.getKey()));
        NavigableMapNavigationTester.assertEquals(null, this.navigableMap.higherKey(this.c.getKey()));
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testLast() {
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.lastEntry());
    }

    @MapFeature.Require(value={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLast() {
        NavigableMapNavigationTester.assertEquals(this.c, this.navigableMap.pollLastEntry());
        NavigableMapNavigationTester.assertEquals(this.entries.subList(0, this.entries.size() - 1), Helpers.copyToList(this.navigableMap.entrySet()));
    }

    @MapFeature.Require(absent={MapFeature.SUPPORTS_REMOVE})
    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testPollLastUnsupported() {
        try {
            this.navigableMap.pollLastEntry();
            NavigableMapNavigationTester.fail();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    @CollectionSize.Require(value={CollectionSize.SEVERAL})
    public void testDescendingNavigation() {
        ArrayList descending = new ArrayList(this.navigableMap.descendingMap().entrySet());
        Collections.reverse(descending);
        NavigableMapNavigationTester.assertEquals(this.entries, descending);
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testHeadMapExclusive() {
        NavigableMapNavigationTester.assertFalse((boolean)this.navigableMap.headMap(this.a.getKey(), false).containsKey(this.a.getKey()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testHeadMapInclusive() {
        NavigableMapNavigationTester.assertTrue((boolean)this.navigableMap.headMap(this.a.getKey(), true).containsKey(this.a.getKey()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testTailMapExclusive() {
        NavigableMapNavigationTester.assertFalse((boolean)this.navigableMap.tailMap(this.a.getKey(), false).containsKey(this.a.getKey()));
    }

    @CollectionSize.Require(absent={CollectionSize.ZERO})
    public void testTailMapInclusive() {
        NavigableMapNavigationTester.assertTrue((boolean)this.navigableMap.tailMap(this.a.getKey(), true).containsKey(this.a.getKey()));
    }
}

