/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.editor;

import proguard.classfile.Clazz;
import proguard.classfile.LibraryClass;
import proguard.classfile.LibraryMember;
import proguard.classfile.LibraryMethod;
import proguard.classfile.ProgramClass;
import proguard.classfile.ProgramMember;
import proguard.classfile.ProgramMethod;
import proguard.classfile.constant.ClassConstant;
import proguard.classfile.constant.RefConstant;
import proguard.classfile.constant.StringConstant;
import proguard.classfile.constant.visitor.ConstantVisitor;
import proguard.classfile.util.AccessUtil;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.SimplifiedVisitor;
import proguard.classfile.visitor.ClassVisitor;
import proguard.classfile.visitor.MemberAccessFilter;
import proguard.classfile.visitor.MemberVisitor;
import proguard.classfile.visitor.NamedMethodVisitor;
import proguard.classfile.visitor.ReferencedClassVisitor;

public class AccessFixer
extends ReferencedClassVisitor
implements ClassVisitor {
    private final ConstantVisitor referencedClassStorer = new MyReferencedClassStorer();

    public AccessFixer() {
        super(new MyAccessFixer());
    }

    @Override
    public void visitProgramClass(ProgramClass programClass) {
        ((MyAccessFixer)this.classVisitor).referencingClass = programClass;
        super.visitProgramClass(programClass);
    }

    @Override
    public void visitLibraryClass(LibraryClass libraryClass) {
        ((MyAccessFixer)this.classVisitor).referencingClass = libraryClass;
        super.visitLibraryClass(libraryClass);
    }

    @Override
    public void visitProgramMethod(ProgramClass programClass, ProgramMethod programMethod) {
        super.visitProgramMember(programClass, programMethod);
        if ((programMethod.getAccessFlags() & 0xA) == 0 && !ClassUtil.isInitializer(programMethod.getName(programClass))) {
            programClass.hierarchyAccept(false, true, false, false, new NamedMethodVisitor(programMethod.getName(programClass), programMethod.getDescriptor(programClass), new MemberAccessFilter(0, 10, (MemberVisitor)((Object)this.classVisitor))));
        }
    }

    @Override
    public void visitLibraryMethod(LibraryClass libraryClass, LibraryMethod libraryMethod) {
        super.visitLibraryMember(libraryClass, libraryMethod);
        if ((libraryMethod.getAccessFlags() & 0xA) == 0 && !ClassUtil.isInitializer(libraryMethod.getName(libraryClass))) {
            libraryClass.hierarchyAccept(false, true, false, false, new NamedMethodVisitor(libraryMethod.getName(libraryClass), libraryMethod.getDescriptor(libraryClass), new MemberAccessFilter(0, 10, (MemberVisitor)((Object)this.classVisitor))));
        }
    }

    @Override
    public void visitStringConstant(Clazz clazz, StringConstant stringConstant) {
        super.visitStringConstant(clazz, stringConstant);
        stringConstant.referencedMemberAccept((MemberVisitor)((Object)this.classVisitor));
    }

    @Override
    public void visitAnyRefConstant(Clazz clazz, RefConstant refConstant) {
        if (ClassUtil.isInternalArrayType(refConstant.getClassName(clazz))) {
            ((MyAccessFixer)this.classVisitor).referencedClass = refConstant.referencedClass;
        } else {
            clazz.constantPoolEntryAccept(refConstant.u2classIndex, this.referencedClassStorer);
        }
        super.visitAnyRefConstant(clazz, refConstant);
        refConstant.referencedMemberAccept((MemberVisitor)((Object)this.classVisitor));
    }

    private static class MyAccessFixer
    extends SimplifiedVisitor
    implements ClassVisitor,
    MemberVisitor {
        private Clazz referencingClass;
        private Clazz referencedClass;

        private MyAccessFixer() {
        }

        @Override
        public void visitLibraryClass(LibraryClass libraryClass) {
        }

        @Override
        public void visitProgramClass(ProgramClass programClass) {
            int n;
            int n2 = programClass.getAccessFlags();
            int n3 = AccessUtil.accessLevel(n2);
            int n4 = n = this.inSamePackage(programClass, this.referencingClass) ? 1 : 3;
            if (n3 < n) {
                programClass.u2accessFlags = AccessUtil.replaceAccessFlags(n2, AccessUtil.accessFlags(n));
            }
        }

        @Override
        public void visitLibraryMember(LibraryClass libraryClass, LibraryMember libraryMember) {
        }

        @Override
        public void visitProgramMember(ProgramClass programClass, ProgramMember programMember) {
            int n;
            int n2 = programMember.getAccessFlags();
            int n3 = AccessUtil.accessLevel(n2);
            int n4 = programClass.equals(this.referencingClass) ? 0 : (this.inSamePackage(programClass, this.referencingClass) ? 1 : (n = this.referencedClass != null && this.referencingClass.extends_(this.referencedClass) && this.referencingClass.extends_(programClass) ? 2 : 3));
            if (n3 < n) {
                programMember.u2accessFlags = AccessUtil.replaceAccessFlags(n2, AccessUtil.accessFlags(n));
            }
        }

        private boolean inSamePackage(ProgramClass programClass, Clazz clazz) {
            return ClassUtil.internalPackageName(programClass.getName()).equals(ClassUtil.internalPackageName(clazz.getName()));
        }
    }

    private class MyReferencedClassStorer
    extends SimplifiedVisitor
    implements ConstantVisitor {
        private MyReferencedClassStorer() {
        }

        @Override
        public void visitClassConstant(Clazz clazz, ClassConstant classConstant) {
            ((MyAccessFixer)AccessFixer.this.classVisitor).referencedClass = classConstant.referencedClass;
        }
    }
}

