/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.ringbuffer.impl.client;

import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.ringbuffer.OverflowPolicy;
import com.hazelcast.ringbuffer.impl.client.RingbufferRequest;
import com.hazelcast.ringbuffer.impl.operations.AddAllOperation;
import com.hazelcast.security.permission.RingBufferPermission;
import com.hazelcast.spi.Operation;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.security.Permission;
import java.util.Arrays;

public class AddAllRequest
extends RingbufferRequest {
    private OverflowPolicy overflowPolicy;
    private Data[] items;

    public AddAllRequest() {
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public AddAllRequest(String name, Data[] items, OverflowPolicy overflowPolicy) {
        super(name);
        this.items = items;
        this.overflowPolicy = overflowPolicy;
    }

    @Override
    protected Operation prepareOperation() {
        return new AddAllOperation(this.name, this.items, this.overflowPolicy);
    }

    @Override
    public int getClassId() {
        return 1;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt("o", this.overflowPolicy.getId());
        writer.writeInt("c", this.items.length);
        for (Data item : this.items) {
            writer.getRawDataOutput().writeData(item);
        }
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        super.read(reader);
        this.overflowPolicy = OverflowPolicy.getById(reader.readInt("o"));
        int length = reader.readInt("c");
        this.items = new Data[length];
        for (int k = 0; k < this.items.length; ++k) {
            this.items[k] = reader.getRawDataInput().readData();
        }
    }

    @Override
    public Permission getRequiredPermission() {
        return new RingBufferPermission(this.name, "put");
    }

    @Override
    public Object[] getParameters() {
        return new Object[]{Arrays.asList(this.items), this.overflowPolicy};
    }

    @Override
    public String getMethodName() {
        return "addAll";
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:ringbufferService";
    }
}

