/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.executor.impl.client;

import com.hazelcast.client.impl.client.TargetClientRequest;
import com.hazelcast.executor.impl.ExecutorPortableHook;
import com.hazelcast.executor.impl.operations.CallableTaskOperation;
import com.hazelcast.nio.ObjectDataInput;
import com.hazelcast.nio.ObjectDataOutput;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.nio.serialization.PortableReader;
import com.hazelcast.nio.serialization.PortableWriter;
import com.hazelcast.security.SecurityContext;
import com.hazelcast.spi.InvocationBuilder;
import com.hazelcast.spi.Operation;
import java.io.IOException;
import java.security.Permission;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;

public class PartitionTargetCallableRequest
extends TargetClientRequest {
    private String name;
    private String uuid;
    private Callable callable;
    private int partitionId;

    public PartitionTargetCallableRequest() {
    }

    public PartitionTargetCallableRequest(String name, String uuid, Callable callable, int partitionId) {
        this.name = name;
        this.uuid = uuid;
        this.callable = callable;
        this.partitionId = partitionId;
    }

    @Override
    public String getServiceName() {
        return "hz:impl:executorService";
    }

    @Override
    public int getFactoryId() {
        return ExecutorPortableHook.F_ID;
    }

    @Override
    protected Operation prepareOperation() {
        SecurityContext securityContext = this.getClientEngine().getSecurityContext();
        if (securityContext != null) {
            Subject subject = this.getEndpoint().getSubject();
            this.callable = securityContext.createSecureCallable(subject, this.callable);
        }
        Object callableData = this.serializationService.toData(this.callable);
        return this.getOperation(this.name, this.uuid, (Data)callableData);
    }

    private Operation getOperation(String name, String uuid, Data callableData) {
        return new CallableTaskOperation(name, uuid, callableData);
    }

    @Override
    protected InvocationBuilder getInvocationBuilder(Operation op) {
        if (this.partitionId == -1) {
            throw new IllegalArgumentException("Partition id is -1");
        }
        return this.operationService.createInvocationBuilder(this.getServiceName(), op, this.partitionId);
    }

    @Override
    public Permission getRequiredPermission() {
        return null;
    }

    @Override
    public int getClassId() {
        return 4;
    }

    @Override
    public void write(PortableWriter writer) throws IOException {
        writer.writeUTF("n", this.name);
        writer.writeUTF("u", this.uuid);
        ObjectDataOutput rawDataOutput = writer.getRawDataOutput();
        rawDataOutput.writeObject(this.callable);
        rawDataOutput.writeInt(this.partitionId);
    }

    @Override
    public void read(PortableReader reader) throws IOException {
        this.name = reader.readUTF("n");
        this.uuid = reader.readUTF("u");
        ObjectDataInput rawDataInput = reader.getRawDataInput();
        this.callable = (Callable)rawDataInput.readObject();
        this.partitionId = rawDataInput.readInt();
    }
}

