/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.cache.impl.merge.entry;

import com.hazelcast.cache.CacheEntryView;
import com.hazelcast.internal.serialization.SerializationService;

public class LazyCacheEntryView<K, V>
implements CacheEntryView<K, V> {
    private Object key;
    private Object value;
    private long expirationTime;
    private long lastAccessTime;
    private long accessHit;
    private SerializationService serializationService;

    public LazyCacheEntryView(Object key, Object value, long expirationTime, long lastAccessTime, long accessHit) {
        this(key, value, expirationTime, lastAccessTime, accessHit, null);
    }

    public LazyCacheEntryView(Object key, Object value, long expirationTime, long lastAccessTime, long accessHit, SerializationService serializationService) {
        this.key = key;
        this.value = value;
        this.expirationTime = expirationTime;
        this.lastAccessTime = lastAccessTime;
        this.accessHit = accessHit;
        this.serializationService = serializationService;
    }

    @Override
    public K getKey() {
        if (this.serializationService != null) {
            this.key = this.serializationService.toObject(this.key);
        }
        return (K)this.key;
    }

    @Override
    public V getValue() {
        if (this.serializationService != null) {
            this.value = this.serializationService.toObject(this.value);
        }
        return (V)this.value;
    }

    @Override
    public long getExpirationTime() {
        return this.expirationTime;
    }

    @Override
    public long getLastAccessTime() {
        return this.lastAccessTime;
    }

    @Override
    public long getAccessHit() {
        return this.accessHit;
    }
}

