/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization.strings;

import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.strings.FastStringCodec;
import com.google.devtools.build.lib.skyframe.serialization.strings.StringCodec;
import java.util.logging.Logger;

public final class StringCodecs {
    private static final Logger logger = Logger.getLogger(StringCodecs.class.getName());
    private static final StringCodec stringCodec = new StringCodec();
    private static final ObjectCodec<String> asciiOptimized;

    private StringCodecs() {
    }

    public static boolean supportsOptimizedAscii() {
        return asciiOptimized instanceof FastStringCodec;
    }

    public static ObjectCodec<String> asciiOptimized() {
        return asciiOptimized;
    }

    public static ObjectCodec<String> simple() {
        return stringCodec;
    }

    static {
        if (FastStringCodec.isAvailable()) {
            asciiOptimized = new FastStringCodec();
        } else {
            logger.warning("Optimized string deserialization unavailable");
            asciiOptimized = stringCodec;
        }
    }
}

