/*
 * Decompiled with CFR 0.152.
 */
package com.google.devtools.build.lib.skyframe.serialization;

import com.google.common.collect.ImmutableMap;
import com.google.devtools.build.lib.skyframe.serialization.JavaSerializableCodec;
import com.google.devtools.build.lib.skyframe.serialization.ObjectCodec;
import com.google.devtools.build.lib.skyframe.serialization.SerializationException;
import com.google.devtools.build.skyframe.SkyFunctionName;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Map;

public class ObjectCodecs {
    private static final ObjectCodec<Object> DEFAULT_CODEC = new JavaSerializableCodec();
    private final Map<String, ObjectCodec<?>> stringMappedCodecs;
    private final Map<ByteString, ObjectCodec<?>> byteStringMappedCodecs;
    private final boolean allowDefaultCodec;

    public static Builder newBuilder() {
        return new Builder();
    }

    private ObjectCodecs(Map<String, ObjectCodec<?>> codecs, boolean allowDefaultCodec) {
        this.stringMappedCodecs = codecs;
        this.byteStringMappedCodecs = ObjectCodecs.makeByteStringMappedCodecs(codecs);
        this.allowDefaultCodec = allowDefaultCodec;
    }

    public ByteString serialize(String classifier, Object subject) throws SerializationException {
        ByteString.Output resultOut = ByteString.newOutput();
        CodedOutputStream codedOut = CodedOutputStream.newInstance((OutputStream)resultOut);
        ObjectCodec<?> codec = this.getCodec(classifier);
        try {
            ObjectCodecs.doSerialize(classifier, codec, subject, codedOut);
            codedOut.flush();
            return resultOut.toByteString();
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + subject + " using " + codec + " for " + classifier, e);
        }
    }

    public void serialize(String classifier, Object subject, CodedOutputStream codedOut) throws SerializationException {
        ObjectCodec<?> codec = this.getCodec(classifier);
        try {
            ObjectCodecs.doSerialize(classifier, codec, subject, codedOut);
        }
        catch (IOException e) {
            throw new SerializationException("Failed to serialize " + subject + " using " + codec + " for " + classifier, e);
        }
    }

    public Object deserialize(ByteString classifier, ByteString data) throws SerializationException {
        return this.deserialize(classifier, data.newCodedInput());
    }

    public Object deserialize(ByteString classifier, CodedInputStream codedIn) throws SerializationException {
        ObjectCodec<?> codec = this.getCodec(classifier);
        codedIn.enableAliasing(true);
        try {
            Object result = codec.deserialize(codedIn);
            if (result == null) {
                throw new NullPointerException("ObjectCodec " + codec + " for " + classifier.toStringUtf8() + " returned null");
            }
            return result;
        }
        catch (IOException e) {
            throw new SerializationException("Failed to deserialize data using " + codec + " for " + classifier.toStringUtf8(), e);
        }
    }

    private ObjectCodec<?> getCodec(String classifier) throws SerializationException.NoCodecException {
        ObjectCodec<?> result = this.stringMappedCodecs.get(classifier);
        if (result != null) {
            return result;
        }
        if (this.allowDefaultCodec) {
            return DEFAULT_CODEC;
        }
        throw new SerializationException.NoCodecException("No codec available for " + classifier + " and default fallback disabled");
    }

    private ObjectCodec<?> getCodec(ByteString classifier) throws SerializationException {
        ObjectCodec<?> result = this.byteStringMappedCodecs.get(classifier);
        if (result != null) {
            return result;
        }
        if (this.allowDefaultCodec) {
            return DEFAULT_CODEC;
        }
        throw new SerializationException("No codec available for " + classifier.toStringUtf8() + " and default fallback disabled");
    }

    private static <T> void doSerialize(String classifier, ObjectCodec<T> codec, Object subject, CodedOutputStream codedOut) throws SerializationException, IOException {
        try {
            codec.serialize(codec.getEncodedClass().cast(subject), codedOut);
        }
        catch (ClassCastException e) {
            throw new SerializationException("Codec " + codec + " for " + classifier + " is incompatible with " + subject + " (of type " + subject.getClass().getName() + ")", e);
        }
    }

    private static Map<ByteString, ObjectCodec<?>> makeByteStringMappedCodecs(Map<String, ObjectCodec<?>> stringMappedCodecs) {
        ImmutableMap.Builder result = ImmutableMap.builder();
        for (Map.Entry<String, ObjectCodec<?>> entry : stringMappedCodecs.entrySet()) {
            result.put((Object)ByteString.copyFromUtf8((String)entry.getKey()), entry.getValue());
        }
        return result.build();
    }

    static class SkyFunctionNameKeyedBuilder {
        private final Builder underlying;

        private SkyFunctionNameKeyedBuilder(Builder underlying) {
            this.underlying = underlying;
        }

        public SkyFunctionNameKeyedBuilder add(SkyFunctionName skyFuncName, ObjectCodec<?> codec) {
            this.underlying.add(skyFuncName.getName(), codec);
            return this;
        }

        public ObjectCodecs build() {
            return this.underlying.build();
        }
    }

    static class ClassKeyedBuilder {
        private final Builder underlying;

        private ClassKeyedBuilder(Builder underlying) {
            this.underlying = underlying;
        }

        public <T> ClassKeyedBuilder add(Class<? extends T> clazz, ObjectCodec<T> codec) {
            this.underlying.add(clazz.getName(), codec);
            return this;
        }

        public ObjectCodecs build() {
            return this.underlying.build();
        }
    }

    static class Builder {
        private final ImmutableMap.Builder<String, ObjectCodec<?>> codecsBuilder = ImmutableMap.builder();
        private boolean allowDefaultCodec = true;

        private Builder() {
        }

        Builder add(String classifier, ObjectCodec<?> codec) {
            this.codecsBuilder.put((Object)classifier, codec);
            return this;
        }

        public Builder setAllowDefaultCodec(boolean allowDefaultCodec) {
            this.allowDefaultCodec = allowDefaultCodec;
            return this;
        }

        public ClassKeyedBuilder asClassKeyedBuilder() {
            return new ClassKeyedBuilder(this);
        }

        public SkyFunctionNameKeyedBuilder asSkyFunctionNameKeyedBuilder() {
            return new SkyFunctionNameKeyedBuilder(this);
        }

        public ObjectCodecs build() {
            return new ObjectCodecs((Map)this.codecsBuilder.build(), this.allowDefaultCodec);
        }
    }
}

