/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.bugpatterns;

import com.google.common.base.MoreObjects;
import com.google.common.collect.Iterables;
import com.google.errorprone.BugPattern;
import com.google.errorprone.VisitorState;
import com.google.errorprone.bugpatterns.BugChecker;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.matchers.Description;
import com.google.errorprone.matchers.Matcher;
import com.google.errorprone.matchers.method.MethodMatchers;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.Regexes;
import com.sun.source.tree.ArrayAccessTree;
import com.sun.source.tree.EnhancedForLoopTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.IdentifierTree;
import com.sun.source.tree.MemberSelectTree;
import com.sun.source.tree.MethodInvocationTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.SimpleTreeVisitor;
import com.sun.source.util.TreePath;
import com.sun.source.util.TreePathScanner;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.tree.JCTree;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;

@BugPattern(name="StringSplitter", summary="Prefer Splitter to String.split", severity=BugPattern.SeverityLevel.WARNING, providesFix=BugPattern.ProvidesFix.REQUIRES_HUMAN_ATTENTION)
public class StringSplitter
extends BugChecker
implements BugChecker.MethodInvocationTreeMatcher {
    private static final Matcher<ExpressionTree> MATCHER = MethodMatchers.instanceMethod().onExactClass("java.lang.String").withSignature("split(java.lang.String)");

    public Description matchMethodInvocation(MethodInvocationTree tree, final VisitorState state) {
        Tree parent;
        if (!MATCHER.matches((Tree)tree, state)) {
            return Description.NO_MATCH;
        }
        String value = (String)ASTHelpers.constValue((Tree)((Tree)Iterables.getOnlyElement(tree.getArguments())), String.class);
        boolean maybeRegex = false;
        if (value != null) {
            Optional regexAsLiteral = Regexes.convertRegexToLiteral((String)value);
            if (regexAsLiteral.isPresent()) {
                value = (String)regexAsLiteral.get();
            } else {
                maybeRegex = true;
            }
        }
        if ((parent = state.getPath().getParentPath().getLeaf()) instanceof EnhancedForLoopTree && ((EnhancedForLoopTree)parent).getExpression().equals(tree)) {
            return this.describeMatch(tree, (Fix)this.replaceWithSplitter(SuggestedFix.builder(), tree, state, "split", maybeRegex).build());
        }
        if (!(parent instanceof VariableTree)) {
            return Description.NO_MATCH;
        }
        VariableTree varTree = (VariableTree)parent;
        if (!varTree.getInitializer().equals(tree)) {
            return Description.NO_MATCH;
        }
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol((VariableTree)varTree);
        TreePath enclosing = this.findEnclosing(state);
        if (enclosing == null) {
            return Description.NO_MATCH;
        }
        final ArrayList uses = new ArrayList();
        new TreePathScanner<Void, Void>(){

            @Override
            public Void visitIdentifier(IdentifierTree tree, Void unused) {
                if (Objects.equals(sym, ASTHelpers.getSymbol((Tree)tree))) {
                    uses.add(this.getCurrentPath());
                }
                return (Void)super.visitIdentifier(tree, null);
            }
        }.scan(enclosing, (Void)null);
        final SuggestedFix.Builder fix = SuggestedFix.builder();
        final boolean[] needsList = new boolean[]{false};
        for (TreePath path : uses) {
            class UseFixer
            extends SimpleTreeVisitor<Boolean, Void> {
                UseFixer() {
                }

                @Override
                public Boolean visitEnhancedForLoop(EnhancedForLoopTree tree, Void unused) {
                    return sym.equals(ASTHelpers.getSymbol((Tree)tree.getExpression()));
                }

                @Override
                public Boolean visitArrayAccess(ArrayAccessTree tree, Void unused) {
                    ExpressionTree expression = tree.getExpression();
                    ExpressionTree index = tree.getIndex();
                    if (!sym.equals(ASTHelpers.getSymbol((Tree)expression))) {
                        return false;
                    }
                    fix.replace(state.getEndPosition((Tree)expression), ((JCTree)((Object)index)).getStartPosition(), ".get(").replace(state.getEndPosition((Tree)index), state.getEndPosition((Tree)tree), ")");
                    needsList[0] = true;
                    return true;
                }

                @Override
                public Boolean visitMemberSelect(MemberSelectTree tree, Void aVoid) {
                    if (sym.equals(ASTHelpers.getSymbol((Tree)tree.getExpression())) && tree.getIdentifier().contentEquals("length")) {
                        fix.replace(state.getEndPosition((Tree)tree.getExpression()), state.getEndPosition((Tree)tree), ".size()");
                        needsList[0] = true;
                        return true;
                    }
                    return false;
                }
            }
            if (((Boolean)MoreObjects.firstNonNull((Object)path.getParentPath().getLeaf().accept(new UseFixer(), null), (Object)false)).booleanValue()) continue;
            return Description.NO_MATCH;
        }
        if (needsList[0]) {
            fix.replace(varTree.getType(), "List<String>").addImport("java.util.List");
            this.replaceWithSplitter(fix, tree, state, "splitToList", maybeRegex);
        } else {
            fix.replace(varTree.getType(), "Iterable<String>");
            this.replaceWithSplitter(fix, tree, state, "split", maybeRegex);
        }
        return this.describeMatch(tree, (Fix)fix.build());
    }

    private SuggestedFix.Builder replaceWithSplitter(SuggestedFix.Builder fix, MethodInvocationTree tree, VisitorState state, String splitMethod, boolean maybeRegex) {
        ExpressionTree receiver = ASTHelpers.getReceiver((ExpressionTree)tree);
        return fix.addImport("com.google.common.base.Splitter").prefixWith((Tree)receiver, "Splitter." + (maybeRegex ? "onPattern" : "on") + "(" + state.getSourceForNode((Tree)Iterables.getOnlyElement(tree.getArguments())) + ")." + splitMethod + "(").replace(state.getEndPosition((Tree)receiver), state.getEndPosition((Tree)tree), ")");
    }

    private TreePath findEnclosing(VisitorState state) {
        for (TreePath path = state.getPath(); path != null; path = path.getParentPath()) {
            switch (path.getLeaf().getKind()) {
                case METHOD: 
                case LAMBDA_EXPRESSION: {
                    return path;
                }
                case CLASS: {
                    return null;
                }
            }
        }
        return null;
    }
}

