/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.testing;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.CharMatcher;
import com.google.common.base.Charsets;
import com.google.common.base.Equivalence;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.base.Throwables;
import com.google.common.base.Ticker;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.Range;
import com.google.common.collect.RowSortedTable;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.Table;
import com.google.common.collect.TreeBasedTable;
import com.google.common.collect.TreeMultiset;
import com.google.common.primitives.Primitives;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedLong;
import com.google.common.reflect.AbstractInvocationHandler;
import com.google.common.reflect.Invokable;
import com.google.common.reflect.Reflection;
import com.google.common.reflect.TypeToken;
import com.google.common.testing.ArbitraryInstances;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.ShortBuffer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Currency;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Optional;
import java.util.OptionalDouble;
import java.util.OptionalInt;
import java.util.OptionalLong;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

@GwtIncompatible
class FreshValueGenerator {
    private static final ImmutableMap<Class<?>, Method> GENERATORS;
    private static final ImmutableMap<Class<?>, Method> EMPTY_GENERATORS;
    private final AtomicInteger freshness = new AtomicInteger(1);
    private final ListMultimap<Class<?>, Object> sampleInstances = ArrayListMultimap.create();
    private final Map<Type, Integer> emptyInstanceGenerated = new HashMap<Type, Integer>();

    FreshValueGenerator() {
    }

    final <T> void addSampleInstances(Class<T> type, Iterable<? extends T> instances) {
        this.sampleInstances.putAll(Preconditions.checkNotNull(type), (Iterable)Preconditions.checkNotNull(instances));
    }

    @Nullable
    final Object generateFresh(TypeToken<?> type) {
        Object generated = this.generate(type);
        if (generated != null) {
            this.freshness.incrementAndGet();
        }
        return generated;
    }

    @Nullable
    final <T> T generateFresh(Class<T> type) {
        return Primitives.wrap(type).cast(this.generateFresh(TypeToken.of(type)));
    }

    final <T> T newFreshProxy(Class<T> interfaceType) {
        T proxy = this.newProxy(interfaceType);
        this.freshness.incrementAndGet();
        return proxy;
    }

    private Object generate(TypeToken<?> type) {
        Method generate;
        Class rawType = type.getRawType();
        List samples = this.sampleInstances.get((Object)rawType);
        Object sample = this.pickInstance(samples, null);
        if (sample != null) {
            return sample;
        }
        if (rawType.isEnum()) {
            return this.pickInstance(rawType.getEnumConstants(), null);
        }
        if (type.isArray()) {
            TypeToken componentType = type.getComponentType();
            Object array = Array.newInstance(componentType.getRawType(), 1);
            Array.set(array, 0, this.generate(componentType));
            return array;
        }
        Method emptyGenerate = (Method)EMPTY_GENERATORS.get((Object)rawType);
        if (emptyGenerate != null) {
            if (this.emptyInstanceGenerated.containsKey(type.getType())) {
                if (this.emptyInstanceGenerated.get(type.getType()).intValue() == this.freshness.get()) {
                    return this.invokeGeneratorMethod(emptyGenerate, new Object[0]);
                }
            } else {
                Object emptyInstance = this.invokeGeneratorMethod(emptyGenerate, new Object[0]);
                this.emptyInstanceGenerated.put(type.getType(), this.freshness.get());
                return emptyInstance;
            }
        }
        if ((generate = (Method)GENERATORS.get((Object)rawType)) != null) {
            ImmutableList params = Invokable.from((Method)generate).getParameters();
            ArrayList args = Lists.newArrayListWithCapacity((int)params.size());
            TypeVariable<Class<T>>[] typeVars = rawType.getTypeParameters();
            for (int i = 0; i < params.size(); ++i) {
                TypeToken paramType = type.resolveType(typeVars[i]);
                Object argValue = this.generate(paramType);
                if (argValue == null) {
                    return null;
                }
                args.add(argValue);
            }
            return this.invokeGeneratorMethod(generate, args.toArray());
        }
        return this.defaultGenerate(rawType);
    }

    private <T> T defaultGenerate(Class<T> rawType) {
        if (rawType.isInterface()) {
            return this.newProxy(rawType);
        }
        return ArbitraryInstances.get(rawType);
    }

    private <T> T newProxy(Class<T> interfaceType) {
        return (T)Reflection.newProxy(interfaceType, (InvocationHandler)((Object)new FreshInvocationHandler(interfaceType)));
    }

    private Object invokeGeneratorMethod(Method generator, Object ... args) {
        try {
            return generator.invoke((Object)this, args);
        }
        catch (InvocationTargetException e) {
            Throwables.throwIfUnchecked((Throwable)e.getCause());
            throw new RuntimeException(e.getCause());
        }
        catch (Exception e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    Object interfaceMethodCalled(Class<?> interfaceType, Method method) {
        throw new UnsupportedOperationException();
    }

    private <T> T pickInstance(T[] instances, T defaultValue) {
        return this.pickInstance(Arrays.asList(instances), defaultValue);
    }

    private <T> T pickInstance(Collection<T> instances, T defaultValue) {
        if (instances.isEmpty()) {
            return defaultValue;
        }
        return (T)Iterables.get(instances, (int)((this.generateInt() - 1) % instances.size()));
    }

    private static String paramString(Class<?> type, int i) {
        return type.getSimpleName() + '@' + i;
    }

    @Generates
    private Class<?> generateClass() {
        return this.pickInstance((Collection)ImmutableList.of(Integer.TYPE, Long.TYPE, Void.TYPE, Object.class, Object[].class, Iterable.class), (Object)Object.class);
    }

    @Generates
    private Object generateObject() {
        return this.generateString();
    }

    @Generates
    private Number generateNumber() {
        return this.generateInt();
    }

    @Generates
    private int generateInt() {
        return this.freshness.get();
    }

    @Generates
    private Integer generateInteger() {
        return new Integer(this.generateInt());
    }

    @Generates
    private long generateLong() {
        return this.generateInt();
    }

    @Generates
    private Long generateLongObject() {
        return new Long(this.generateLong());
    }

    @Generates
    private float generateFloat() {
        return this.generateInt();
    }

    @Generates
    private Float generateFloatObject() {
        return new Float(this.generateFloat());
    }

    @Generates
    private double generateDouble() {
        return this.generateInt();
    }

    @Generates
    private Double generateDoubleObject() {
        return new Double(this.generateDouble());
    }

    @Generates
    private short generateShort() {
        return (short)this.generateInt();
    }

    @Generates
    private Short generateShortObject() {
        return new Short(this.generateShort());
    }

    @Generates
    private byte generateByte() {
        return (byte)this.generateInt();
    }

    @Generates
    private Byte generateByteObject() {
        return new Byte(this.generateByte());
    }

    @Generates
    private char generateChar() {
        return this.generateString().charAt(0);
    }

    @Generates
    private Character generateCharacter() {
        return new Character(this.generateChar());
    }

    @Generates
    private boolean generateBoolean() {
        return this.generateInt() % 2 == 0;
    }

    @Generates
    private Boolean generateBooleanObject() {
        return new Boolean(this.generateBoolean());
    }

    @Generates
    private UnsignedInteger generateUnsignedInteger() {
        return UnsignedInteger.fromIntBits((int)this.generateInt());
    }

    @Generates
    private UnsignedLong generateUnsignedLong() {
        return UnsignedLong.fromLongBits((long)this.generateLong());
    }

    @Generates
    private BigInteger generateBigInteger() {
        return BigInteger.valueOf(this.generateInt());
    }

    @Generates
    private BigDecimal generateBigDecimal() {
        return BigDecimal.valueOf(this.generateInt());
    }

    @Generates
    private CharSequence generateCharSequence() {
        return this.generateString();
    }

    @Generates
    private String generateString() {
        return Integer.toString(this.generateInt());
    }

    @Generates
    private Comparable<?> generateComparable() {
        return this.generateString();
    }

    @Generates
    private Pattern generatePattern() {
        return Pattern.compile(this.generateString());
    }

    @Generates
    private Charset generateCharset() {
        return this.pickInstance(Charset.availableCharsets().values(), Charsets.UTF_8);
    }

    @Generates
    private Locale generateLocale() {
        return this.pickInstance(Locale.getAvailableLocales(), Locale.US);
    }

    @Generates
    private Currency generateCurrency() {
        try {
            Method method = Currency.class.getMethod("getAvailableCurrencies", new Class[0]);
            Set currencies = (Set)method.invoke(null, new Object[0]);
            return this.pickInstance(currencies, Currency.getInstance(Locale.US));
        }
        catch (NoSuchMethodException | InvocationTargetException notJava7) {
            return this.preJava7FreshCurrency();
        }
        catch (IllegalAccessException impossible) {
            throw new AssertionError((Object)impossible);
        }
    }

    private Currency preJava7FreshCurrency() {
        HashSet uselessLocales = Sets.newHashSet();
        Locale locale;
        while (!uselessLocales.contains(locale = this.generateLocale())) {
            try {
                return Currency.getInstance(locale);
            }
            catch (IllegalArgumentException e) {
                uselessLocales.add(locale);
                continue;
            }
            break;
        }
        return Currency.getInstance(Locale.US);
    }

    @Empty
    private <T> Optional<T> generateJavaOptional() {
        return Optional.empty();
    }

    @Generates
    private <T> Optional<T> generateJavaOptional(T value) {
        return Optional.of(value);
    }

    @Generates
    private OptionalInt generateOptionalInt() {
        return OptionalInt.of(this.generateInt());
    }

    @Generates
    private OptionalLong generateOptionalLong() {
        return OptionalLong.of(this.generateLong());
    }

    @Generates
    private OptionalDouble generateOptionalDouble() {
        return OptionalDouble.of(this.generateDouble());
    }

    @Empty
    private <T> com.google.common.base.Optional<T> generateGoogleOptional() {
        return com.google.common.base.Optional.absent();
    }

    @Generates
    private <T> com.google.common.base.Optional<T> generateGoogleOptional(T value) {
        return com.google.common.base.Optional.of(value);
    }

    @Generates
    private Joiner generateJoiner() {
        return Joiner.on((String)this.generateString());
    }

    @Generates
    private Splitter generateSplitter() {
        return Splitter.on((String)this.generateString());
    }

    @Generates
    private <T> Equivalence<T> generateEquivalence() {
        return new Equivalence<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Equivalence.class, FreshValueGenerator.this.generateInt());
            }

            protected boolean doEquivalent(T a, T b) {
                return false;
            }

            protected int doHash(T t) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private CharMatcher generateCharMatcher() {
        return new CharMatcher(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(CharMatcher.class, FreshValueGenerator.this.generateInt());
            }

            public boolean matches(char c) {
                return false;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private Ticker generateTicker() {
        return new Ticker(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ticker.class, FreshValueGenerator.this.generateInt());
            }

            public long read() {
                return 0L;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Generates
    private <T> Comparator<T> generateComparator() {
        return this.generateOrdering();
    }

    @Generates
    private <T> Ordering<T> generateOrdering() {
        return new Ordering<T>(){
            final String string;
            {
                this.string = FreshValueGenerator.paramString(Ordering.class, FreshValueGenerator.this.generateInt());
            }

            public int compare(T left, T right) {
                return 0;
            }

            public String toString() {
                return this.string;
            }
        };
    }

    @Empty
    private static <C extends Comparable<?>> Range<C> generateRange() {
        return Range.all();
    }

    @Generates
    private static <C extends Comparable<?>> Range<C> generateRange(C freshElement) {
        return Range.singleton(freshElement);
    }

    @Generates
    private static <E> Iterable<E> generateIterable(E freshElement) {
        return FreshValueGenerator.generateList(freshElement);
    }

    @Generates
    private static <E> Collection<E> generateCollection(E freshElement) {
        return FreshValueGenerator.generateList(freshElement);
    }

    @Generates
    private static <E> List<E> generateList(E freshElement) {
        return FreshValueGenerator.generateArrayList(freshElement);
    }

    @Generates
    private static <E> ArrayList<E> generateArrayList(E freshElement) {
        ArrayList list = Lists.newArrayList();
        list.add(freshElement);
        return list;
    }

    @Generates
    private static <E> LinkedList<E> generateLinkedList(E freshElement) {
        LinkedList list = Lists.newLinkedList();
        list.add(freshElement);
        return list;
    }

    @Generates
    private static <E> ImmutableList<E> generateImmutableList(E freshElement) {
        return ImmutableList.of(freshElement);
    }

    @Generates
    private static <E> ImmutableCollection<E> generateImmutableCollection(E freshElement) {
        return FreshValueGenerator.generateImmutableList(freshElement);
    }

    @Generates
    private static <E> Set<E> generateSet(E freshElement) {
        return FreshValueGenerator.generateHashSet(freshElement);
    }

    @Generates
    private static <E> HashSet<E> generateHashSet(E freshElement) {
        return FreshValueGenerator.generateLinkedHashSet(freshElement);
    }

    @Generates
    private static <E> LinkedHashSet<E> generateLinkedHashSet(E freshElement) {
        LinkedHashSet set = Sets.newLinkedHashSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    private static <E> ImmutableSet<E> generateImmutableSet(E freshElement) {
        return ImmutableSet.of(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> SortedSet<E> generateSortedSet(E freshElement) {
        return FreshValueGenerator.generateNavigableSet(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> NavigableSet<E> generateNavigableSet(E freshElement) {
        return FreshValueGenerator.generateTreeSet(freshElement);
    }

    @Generates
    private static <E extends Comparable<? super E>> TreeSet<E> generateTreeSet(E freshElement) {
        TreeSet set = Sets.newTreeSet();
        set.add(freshElement);
        return set;
    }

    @Generates
    private static <E extends Comparable<? super E>> ImmutableSortedSet<E> generateImmutableSortedSet(E freshElement) {
        return ImmutableSortedSet.of(freshElement);
    }

    @Generates
    private static <E> Multiset<E> generateMultiset(E freshElement) {
        return FreshValueGenerator.generateHashMultiset(freshElement);
    }

    @Generates
    private static <E> HashMultiset<E> generateHashMultiset(E freshElement) {
        HashMultiset multiset = HashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E> LinkedHashMultiset<E> generateLinkedHashMultiset(E freshElement) {
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E> ImmutableMultiset<E> generateImmutableMultiset(E freshElement) {
        return ImmutableMultiset.of(freshElement);
    }

    @Generates
    private static <E extends Comparable<E>> SortedMultiset<E> generateSortedMultiset(E freshElement) {
        return FreshValueGenerator.generateTreeMultiset(freshElement);
    }

    @Generates
    private static <E extends Comparable<E>> TreeMultiset<E> generateTreeMultiset(E freshElement) {
        TreeMultiset multiset = TreeMultiset.create();
        multiset.add(freshElement);
        return multiset;
    }

    @Generates
    private static <E extends Comparable<E>> ImmutableSortedMultiset<E> generateImmutableSortedMultiset(E freshElement) {
        return ImmutableSortedMultiset.of(freshElement);
    }

    @Generates
    private static <K, V> Map<K, V> generateMap(K key, V value) {
        return FreshValueGenerator.generateHashdMap(key, value);
    }

    @Generates
    private static <K, V> HashMap<K, V> generateHashdMap(K key, V value) {
        return FreshValueGenerator.generateLinkedHashMap(key, value);
    }

    @Generates
    private static <K, V> LinkedHashMap<K, V> generateLinkedHashMap(K key, V value) {
        LinkedHashMap map = Maps.newLinkedHashMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K, V> ImmutableMap<K, V> generateImmutableMap(K key, V value) {
        return ImmutableMap.of(key, value);
    }

    @Empty
    private static <K, V> ConcurrentMap<K, V> generateConcurrentMap() {
        return Maps.newConcurrentMap();
    }

    @Generates
    private static <K, V> ConcurrentMap<K, V> generateConcurrentMap(K key, V value) {
        ConcurrentMap map = Maps.newConcurrentMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K extends Comparable<? super K>, V> SortedMap<K, V> generateSortedMap(K key, V value) {
        return FreshValueGenerator.generateNavigableMap(key, value);
    }

    @Generates
    private static <K extends Comparable<? super K>, V> NavigableMap<K, V> generateNavigableMap(K key, V value) {
        return FreshValueGenerator.generateTreeMap(key, value);
    }

    @Generates
    private static <K extends Comparable<? super K>, V> TreeMap<K, V> generateTreeMap(K key, V value) {
        TreeMap map = Maps.newTreeMap();
        map.put(key, value);
        return map;
    }

    @Generates
    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> generateImmutableSortedMap(K key, V value) {
        return ImmutableSortedMap.of(key, value);
    }

    @Generates
    private static <K, V> Multimap<K, V> generateMultimap(K key, V value) {
        return FreshValueGenerator.generateListMultimap(key, value);
    }

    @Generates
    private static <K, V> ImmutableMultimap<K, V> generateImmutableMultimap(K key, V value) {
        return ImmutableMultimap.of(key, value);
    }

    @Generates
    private static <K, V> ListMultimap<K, V> generateListMultimap(K key, V value) {
        return FreshValueGenerator.generateArrayListMultimap(key, value);
    }

    @Generates
    private static <K, V> ArrayListMultimap<K, V> generateArrayListMultimap(K key, V value) {
        ArrayListMultimap multimap = ArrayListMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> ImmutableListMultimap<K, V> generateImmutableListMultimap(K key, V value) {
        return ImmutableListMultimap.of(key, value);
    }

    @Generates
    private static <K, V> SetMultimap<K, V> generateSetMultimap(K key, V value) {
        return FreshValueGenerator.generateLinkedHashMultimap(key, value);
    }

    @Generates
    private static <K, V> HashMultimap<K, V> generateHashMultimap(K key, V value) {
        HashMultimap multimap = HashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> LinkedHashMultimap<K, V> generateLinkedHashMultimap(K key, V value) {
        LinkedHashMultimap multimap = LinkedHashMultimap.create();
        multimap.put(key, value);
        return multimap;
    }

    @Generates
    private static <K, V> ImmutableSetMultimap<K, V> generateImmutableSetMultimap(K key, V value) {
        return ImmutableSetMultimap.of(key, value);
    }

    @Generates
    private static <K, V> BiMap<K, V> generateBimap(K key, V value) {
        return FreshValueGenerator.generateHashBiMap(key, value);
    }

    @Generates
    private static <K, V> HashBiMap<K, V> generateHashBiMap(K key, V value) {
        HashBiMap bimap = HashBiMap.create();
        bimap.put(key, value);
        return bimap;
    }

    @Generates
    private static <K, V> ImmutableBiMap<K, V> generateImmutableBimap(K key, V value) {
        return ImmutableBiMap.of(key, value);
    }

    @Generates
    private static <R, C, V> Table<R, C, V> generateTable(R row, C column, V value) {
        return FreshValueGenerator.generateHashBasedTable(row, column, value);
    }

    @Generates
    private static <R, C, V> HashBasedTable<R, C, V> generateHashBasedTable(R row, C column, V value) {
        HashBasedTable table = HashBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    private static <R extends Comparable, C extends Comparable, V> RowSortedTable<R, C, V> generateRowSortedTable(R row, C column, V value) {
        return FreshValueGenerator.generateTreeBasedTable(row, column, value);
    }

    @Generates
    private static <R extends Comparable, C extends Comparable, V> TreeBasedTable<R, C, V> generateTreeBasedTable(R row, C column, V value) {
        TreeBasedTable table = TreeBasedTable.create();
        table.put(row, column, value);
        return table;
    }

    @Generates
    private static <R, C, V> ImmutableTable<R, C, V> generateImmutableTable(R row, C column, V value) {
        return ImmutableTable.of(row, column, value);
    }

    @Generates
    private TypeToken<?> generateTypeToken() {
        return TypeToken.of(this.generateClass());
    }

    @Generates
    private File generateFile() {
        return new File(this.generateString());
    }

    @Generates
    private static ByteArrayInputStream generateByteArrayInputStream() {
        return new ByteArrayInputStream(new byte[0]);
    }

    @Generates
    private static InputStream generateInputStream() {
        return FreshValueGenerator.generateByteArrayInputStream();
    }

    @Generates
    private StringReader generateStringReader() {
        return new StringReader(this.generateString());
    }

    @Generates
    private Reader generateReader() {
        return this.generateStringReader();
    }

    @Generates
    private Readable generateReadable() {
        return this.generateReader();
    }

    @Generates
    private Buffer generateBuffer() {
        return this.generateCharBuffer();
    }

    @Generates
    private CharBuffer generateCharBuffer() {
        return CharBuffer.allocate(this.generateInt());
    }

    @Generates
    private ByteBuffer generateByteBuffer() {
        return ByteBuffer.allocate(this.generateInt());
    }

    @Generates
    private ShortBuffer generateShortBuffer() {
        return ShortBuffer.allocate(this.generateInt());
    }

    @Generates
    private IntBuffer generateIntBuffer() {
        return IntBuffer.allocate(this.generateInt());
    }

    @Generates
    private LongBuffer generateLongBuffer() {
        return LongBuffer.allocate(this.generateInt());
    }

    @Generates
    private FloatBuffer generateFloatBuffer() {
        return FloatBuffer.allocate(this.generateInt());
    }

    @Generates
    private DoubleBuffer generateDoubleBuffer() {
        return DoubleBuffer.allocate(this.generateInt());
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Method method : FreshValueGenerator.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Generates.class)) continue;
            builder.put(method.getReturnType(), (Object)method);
        }
        GENERATORS = builder.build();
        builder = ImmutableMap.builder();
        for (Method method : FreshValueGenerator.class.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Empty.class)) continue;
            builder.put(method.getReturnType(), (Object)method);
        }
        EMPTY_GENERATORS = builder.build();
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Empty {
    }

    @Target(value={ElementType.METHOD})
    @Retention(value=RetentionPolicy.RUNTIME)
    private static @interface Generates {
    }

    private final class FreshInvocationHandler
    extends AbstractInvocationHandler {
        private final int identity;
        private final Class<?> interfaceType;

        FreshInvocationHandler(Class<?> interfaceType) {
            this.identity = FreshValueGenerator.this.generateInt();
            this.interfaceType = interfaceType;
        }

        protected Object handleInvocation(Object proxy, Method method, Object[] args) {
            return FreshValueGenerator.this.interfaceMethodCalled(this.interfaceType, method);
        }

        public int hashCode() {
            return this.identity;
        }

        public boolean equals(@Nullable Object obj) {
            if (obj instanceof FreshInvocationHandler) {
                FreshInvocationHandler that = (FreshInvocationHandler)((Object)obj);
                return this.identity == that.identity;
            }
            return false;
        }

        public String toString() {
            return FreshValueGenerator.paramString(this.interfaceType, this.identity);
        }
    }
}

