/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.type;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.turbine.binder.sym.ClassSymbol;
import com.google.turbine.diag.SourceFile;
import com.google.turbine.model.Const;
import com.google.turbine.tree.Tree;
import java.util.Objects;

public class AnnoInfo {
    private final SourceFile source;
    private final ClassSymbol sym;
    private final Tree.Anno tree;
    private final ImmutableMap<String, Const> values;

    public AnnoInfo(SourceFile source, ClassSymbol sym, Tree.Anno tree, ImmutableMap<String, Const> values) {
        this.source = source;
        this.sym = Objects.requireNonNull(sym);
        this.tree = tree;
        this.values = values;
    }

    public SourceFile source() {
        return this.source;
    }

    public int position() {
        return this.tree.position();
    }

    public ImmutableList<Tree.Expression> args() {
        return this.tree.args();
    }

    public ImmutableMap<String, Const> values() {
        return this.values;
    }

    public ClassSymbol sym() {
        return this.sym;
    }

    public AnnoInfo withValues(ImmutableMap<String, Const> values) {
        return new AnnoInfo(this.source, this.sym, this.tree, values);
    }
}

