/*
 * Decompiled with CFR 0.152.
 */
package io.github.applecommander.bastools.tools.st;

import io.github.applecommander.bastools.tools.st.ExtractCommand;
import io.github.applecommander.bastools.tools.st.GenerateCommand;
import io.github.applecommander.bastools.tools.st.VersionProvider;
import java.io.PrintStream;
import java.util.Optional;
import picocli.CommandLine;

@CommandLine.Command(name="st", mixinStandardHelpOptions=true, versionProvider=VersionProvider.class, descriptionHeading="%n", commandListHeading="%nCommands:%n", optionListHeading="%nOptions:%n", description={"Shape Tools utility"}, subcommands={ExtractCommand.class, GenerateCommand.class, CommandLine.HelpCommand.class})
public class Main
implements Runnable {
    @CommandLine.Option(names={"--debug"}, description={"Dump full stack traces if an error occurs"})
    private static boolean debugFlag;

    public static void main(String[] args) {
        try {
            CommandLine.run((Runnable)new Main(), (String[])args);
        }
        catch (Throwable t) {
            if (debugFlag) {
                t.printStackTrace(System.err);
            } else {
                String message = t.getMessage();
                while (t != null) {
                    message = t.getMessage();
                    t = t.getCause();
                }
                System.err.printf("Error: %s\n", Optional.ofNullable(message).orElse("An error occurred."));
            }
            System.exit(1);
        }
    }

    @Override
    public void run() {
        CommandLine.usage((Object)this, (PrintStream)System.out);
    }
}

