/*
 * Decompiled with CFR 0.152.
 */
package org.basex.util.list;

import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import org.basex.util.Array;
import org.basex.util.Token;
import org.basex.util.list.ObjectList;

public final class StringList
extends ObjectList<String, StringList> {
    public StringList() {
        this(-1L);
    }

    public StringList(long capacity) {
        super(new String[Array.initialCapacity(capacity)]);
    }

    public StringList(String ... elements) {
        super(elements);
        this.size = elements.length;
    }

    @Override
    public StringList add(byte[] element) {
        return (StringList)((Object)this.add(Token.string(element)));
    }

    public StringList sort() {
        return this.sort(true);
    }

    public StringList sort(boolean cs) {
        return this.sort(cs, true);
    }

    public StringList sort(boolean cs, boolean asc) {
        Comparator comp = cs ? null : String.CASE_INSENSITIVE_ORDER;
        Arrays.sort((String[])this.list, 0, this.size, asc ? comp : Collections.reverseOrder(comp));
        return this;
    }

    protected String[] newArray(int s) {
        return new String[s];
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object obj) {
        if (obj == this) return true;
        if (!(obj instanceof StringList)) return false;
        StringList l = (StringList)obj;
        if (!Arrays.equals(this.list, 0, this.size, l.list, 0, l.size)) return false;
        return true;
    }
}

