/*
 * Decompiled with CFR 0.152.
 */
package org.basex.query.value.array;

import org.basex.core.jobs.Job;
import org.basex.query.QueryContext;
import org.basex.query.QueryException;
import org.basex.query.QueryPlan;
import org.basex.query.QueryString;
import org.basex.query.iter.Iter;
import org.basex.query.value.Value;
import org.basex.query.value.array.ArrayBuilder;
import org.basex.query.value.array.XQArray;
import org.basex.query.value.item.Item;
import org.basex.query.value.type.ArrayType;
import org.basex.query.value.type.Occ;
import org.basex.util.InputInfo;

public final class ItemArray
extends XQArray {
    private Value members;

    ItemArray(Value members) {
        super(ArrayType.get(members.type.seqType()));
        this.members = members;
    }

    @Override
    public Value memberAt(long index) {
        return this.members.itemAt(index);
    }

    @Override
    public Iter itemsIter() {
        return this.members.iter();
    }

    @Override
    public Value items(QueryContext qc) {
        return this.members;
    }

    @Override
    public Value atomValue(QueryContext qc, InputInfo ii) throws QueryException {
        return this.members.atomValue(qc, ii);
    }

    @Override
    public long structSize() {
        return this.members.size();
    }

    @Override
    public XQArray putMember(long pos, Value value, Job job) {
        return this.toTree(job).putMember(pos, value, job);
    }

    @Override
    public XQArray insertMember(long pos, Value value, Job job) {
        return this.toTree(job).insertMember(pos, value, job);
    }

    @Override
    public XQArray removeMember(long pos, Job job) {
        return this.structSize() == 2L ? ItemArray.get(this.members.itemAt(pos == 0L ? 1L : 0L)) : new ItemArray(this.members.removeItem(pos, job));
    }

    @Override
    protected XQArray subArr(long pos, long length, Job job) {
        return new ItemArray(this.members.subsequence(pos, length, job));
    }

    @Override
    public XQArray reverseArray(Job job) {
        return new ItemArray(this.members.reverse(job));
    }

    private XQArray toTree(Job job) {
        ArrayBuilder ab = new ArrayBuilder(job, Long.MIN_VALUE);
        for (Item member : this.members) {
            ab.add(member);
        }
        return ab.array((ArrayType)this.type);
    }

    @Override
    public Item shrink(Job job) throws QueryException {
        this.members = this.members.shrink(job);
        this.type = ArrayType.get(this.members.seqType().with(Occ.EXACTLY_ONE));
        return this;
    }

    @Override
    public void toXml(QueryPlan plan) {
        plan.add(plan.create(this, "entries", this.structSize()), this.members);
    }

    @Override
    public void toString(QueryString qs) {
        qs.token("array { ");
        this.members.toString(qs);
        qs.token(" }");
    }
}

